import methodMap from './apiMap';
import AsInst from './axios';
import HSHttpClient from './crypto'
import store from '@/store/modules/app.js'
import apiURL from './host.js'

class Http {
}
Http.install = function (Vue) {
  /**
   * 全局请求接口
   * @param method 方法
   * @param opts 参数
   * @param toast 是否提示
   * @returns {string}
   */
  Vue.prototype.request = function (method, opts, toast,header) {
    let m = methodMap[method];
    if (m) {
      let optsType = typeof (opts);
      if (optsType === null || optsType !== 'object') {
        opts = {};
      }
      if (typeof m.method === 'undefined') {
        console.log('method 错误', '缺少请求 method 方法', '\n');
        return false;
      }
      //如果有给 toast 参数则显示 loading 加载数据
      if (toast && typeof (toast) === 'boolean') {
        loading();
      } else if (toast && typeof (toast) === 'string') {
        loading(toast);
      }
      let _params = opts.hasOwnProperty('params') ? opts.params : {};
      let url = new HSHttpClient(apiURL(m.host) + m.url,{},_params).newUrl;

      if (m.method === 'get') {
        return Vue.prototype.apiGet(url,opts.data,toast,header);
      } else if (m.method === 'post') {
        return Vue.prototype.apiPost(url, opts.data,toast,header);
      } else {
        return false;
      }
    } else {
      closeLoading();
      console.log('url 错误', '返回结果：err = ', '无法请求，无效的请求！', '\n');
    }
  };
  /**
   * POST 请求 无提示
   * @param url 请求URL
   * @param data 请求数据
   * @param toast 是否显示 modal
   * @returns {Promise}
   */
  Vue.prototype.apiPost = function (url, data, toast = false,header) {
    for(let x in header){
      AsInst.defaults.headers.common[x] = header[x];
    }
    if (toast && typeof (toast) === 'boolean') {
      loading();
    } else if (toast && typeof (toast) === 'string') {
      loading(toast);
    }
    return new Promise((resolve, reject) => {
      AsInst.post(url, data).then((response) => {
        closeLoading();
        resolve(response.data);
      }).catch((error) => {
        if (error.status === 200) {
          if (!error.data) {
            console.log('Customize Notice post_1', error);
          } else if (error.data && error.data.code == '0') {
            resolve(error.data)
            console.log('Customize Notice post_2', error);
          }
        } else if (error.status === 500) {
          resolve(response.data);
          console.log('Customize Notice post_3', error);
        } else {
          console.log('Customize Notice post_4', error);
        }
        closeLoading();
        reject(error);
      });
    });
  };
  /**
   * GET 请求 无提示
   * @param url 请求URL
   * @param data 请求数据
   * @returns {Promise}
   */
  Vue.prototype.apiGet = function (url, data, toast = false,header) {
    if (toast && typeof (toast) === 'boolean') {
      loading();
    } else if (toast && typeof (toast) === 'string') {
      loading(toast);
    }
    return new Promise((resolve, reject) => {
      for(let x in header){
        AsInst.defaults.headers.common[x] = header[x];
      }
      AsInst.get(url, {
        params: data
      }).then((response) => {
        setTimeout(() => closeLoading(), 800);
        resolve(response.data);
      }).catch((error) => {
        if (error.status === 200) {
          if (!error.data) {
            console.log('Customize Notice get_1', error);
          }
        } else if (error.status === 500) {
          resolve(response.data);
          console.log('Customize Notice get_2', error);
        } else {
          console.log('Customize Notice get_3', error);
        }
        closeLoading();
        reject(error);
      });
    });
  };
  /**
   * 关闭方法
   */
  function loading(str){
    Vue.prototype.$loading(str || '')
  }
  function closeLoading() {
    Vue.prototype.$loading.close();
  }
};
export default Http;
