import Vue from 'vue'
import Router from 'vue-router'
import healthRoutes from './health'

Vue.use(Router)

let tipRoutes = [
  {
    path:'/me',
    name:'me',
    component: () => import('@/view/me/index.vue'),
    meta: {
      title: '我的'
    },
    redirect:'/me/info',
    children:[
      {
        path:'/me/info',
        name:'我的信息',
        component: () => import('@/view/me/info.vue'),
        meta: {
          title: '我的信息'
        }
      },
      {
        path:'/me/help',
        name:'帮助',
        component: () => import('@/view/me/help.vue'),
        meta: {
          title: '帮助'
        }
      }
    ]
  },
  {
    name:'main',
    component: () => import('@/view/main.vue'),
    path:'/main',
    children:[
      {
        path:'/sales/:iProjectId',
        name:'chartMmcolorsale',
        component:()=> import('@/view/chart/sales/index.vue'),
        meta:{
          title: '图表'
        }
      },
      {
        path:'/salesDetail',
        name:'chartMmcolorsaleDetail',
        component:()=> import('@/view/chart/sales/detail.vue'),
        meta:{
          title: '图表'
        }
      },
      {
        path:'/custom/:iProjectId',
        name:'chartCustom',
        component:()=> import('@/view/chart/custom/index.vue'),
        meta:{
          title: '图表'
        }
      },
      {
        path:'/customDetail',
        name:'chartCustomDetail',
        component:()=> import('@/view/chart/custom/detail.vue'),
        meta:{
          title: '图表'
        }
      },
      {
        path:'/income/:iProjectId',
        name:'chartIncome',
        component:()=> import('@/view/chart/income/index.vue'),
        meta:{
          title: '图表'
        }
      },
      {
        path:'/salesStatistics/:iProjectId',
        name:'chartStatistics',
        component:()=> import('@/view/chart/sales/statistics.vue'),
        meta:{
          title: '销售统计'
        }
      },
    ]
  },
  {
    name:'main',
    component: () => import('@/view/main.vue'),
    path:'/main',
    children:[
      {
        path:'/specimen/:iProjectId/:sMaterialNo',
        name:'specimen',
        component:()=> import('@/view/specimen/index.vue'),
        meta:{
          title: '样品信息'
        }
      }
    ]
  },
  {
    name:"main",
    component:()=>import("@/view/main.vue"),
    path:"/main",
    children:[
      {
        path:"/kanban/:userId",
        name:"kanban",
        component:()=>import("@/view/tiip/kanban/index.vue"),
        meta:{
          title:"经营分析"
        }
      },
      {
        path:"/kanbanOperateDetail",
        name:"tiipOperateDetail",
        component:()=>import("@/view/tiip/kanban/operateDetail.vue"),
        meta:{
          title:"接单详情"
        }
      },
      {//往来单位进入
        path:"/kanbanUnitOperateDetail/:userId",
        name:"tiipUnitOperateDetail",
        component:()=>import("@/view/tiip/kanban/unit_operateDetail.vue"),
        meta:{
          title:"产品排行"
        }
      },
      {
        path:"/kanbanOperateCustomDetail/:type",
        name:"tiipOperateCustomDetail",
        component:()=>import("@/view/tiip/kanban/operateCustomDetail.vue"),
        meta:{
          title:"客户订单列表"
        }
      },
      {
        path:"/kanbanOperateSaleDetail",
        name:"tiipOperateSaleDetail",
        component:()=>import("@/view/tiip/kanban/operateSaleDetail.vue"),
        meta:{
          title:"销售员接单情况"
        }
      }
    ]
  },
  {
    name:'main',
    component: () => import('@/view/main.vue'),
    path:'/main',
    children:[
      {
        path:'/tiip/specimen/:userId/:uGuid',
        name:'specimen',
        component:()=> import('@/view/tiip/specimen/index.vue'),
        meta:{
          title: '样品信息'
        }
      }
    ]
  },
  {
    name:'main',
    component: () => import('@/view/main.vue'),
    path:'/main',
    children:[
      {
        path:'/tiip/searchOrder/list/:userId',
        name:'searchOrderList',
        component:()=> import('@/view/tiip/searchOrder/index.vue'),
        meta:{
          title: '订单查询'
        }
      },
      {
        path:'/tiip/searchOrder/detail',
        name:'searchOrderDetail',
        component:()=> import('@/view/tiip/searchOrder/detail.vue'),
        meta:{
          title: '订单详情'
        }
      },
      {
        path:'/tiip/searchOrder/materialDetail',
        name:'searchOrderMaterialDetail',
        component:()=> import('@/view/tiip/searchOrder/materialDetail.vue'),
        meta:{
          title: '产品详情'
        }
      },
      {
        path:'/tiip/searchOrder/track',
        name:'searchOrderTrack',
        component:()=> import('@/view/tiip/searchOrder/track.vue'),
        meta:{
          title: '订单全程跟踪'
        }
      }
    ]
  },
  {
    name:'main',
    component: () => import('@/view/main.vue'),
    path:'/main',
    children:[
      {
        path:'/tiip/profitAnalysis/list/:userId',
        name:'profitAnalysisList',
        component:()=> import('@/view/tiip/profitAnalysis/index.vue'),
        meta:{
          title: '订单利润分析'
        }
      },
      {
        path:'/tiip/profitAnalysis/detail',
        name:'profitAnalysisDetail',
        component:()=> import('@/view/tiip/profitAnalysis/detail.vue'),
        meta:{
          title: '订单明细'
        }
      },
      {
        path:'/tiip/profitAnalysis/track',
        name:'profitAnalysisTrack',
        component:()=> import('@/view/tiip/profitAnalysis/track.vue'),
        meta:{
          title: '订单全程跟踪'
        }
      }
    ]
  },
  {
    name:'main',
    component: () => import('@/view/main.vue'),
    path:'/main',
    children:[
      {
        path:'/tiip/orderDetails/list',
        name:'orderDetailsIndex',
        component:()=> import('@/view/tiip/orderDetails/index.vue'),
        meta:{
          title: '订单详情'
        }
      },
    ]
  },
  {
    name:'main',
    component: () => import('@/view/main.vue'),
    path:'/main',
    children:[
      {
        path:'/common/customField',
        name:'customField',
        component:()=> import('@/view/common/customField.vue'),
        meta:{
          title: '自定义列表'
        }
      },
    ]
  },
  {
    name:'main',
    component: () => import('@/view/main.vue'),
    path:'/main',
    children:[
      {
        path:'/tiip/chart/inventory/:userId',
        name:'tiipChartInventory',
        component:()=> import('@/view/tiip/chart/inventory.vue'),
        meta:{
          title: '库存金额分析'
        }
      },
      {
        path:'/tiip/chart/warehouseDetail',
        name:'tiipChartWarehouseDetail',
        component:()=> import('@/view/tiip/chart/warehouseDetail.vue'),
        meta:{
          title: ''
        }
      },
    ]
  },
  { //贸易智能报表
    name:"main",
    component:()=>import("@/view/main.vue"),
    path:"/main",
    children:[
      {
        path:"/tiip/IntReportForms/:userId",
        name:"IntReportForms",
        component:()=>import("@/view/tiip/IntReportForms/index.vue"),
        meta:{
          title:"智能报表"
        },
      },
      {
        path:"/tiip/liabilitiesDetail/:iCustomerId",
        name:"tipLiabilitiesDetail",
        component:()=>import("@/view/tiip/IntReportForms/liabilities_detail.vue")
      }
    ]
  },
  { //订单进度查询
    name:"main",
    component:()=>import("@/view/main.vue"),
    path:"/main",
    children:[
      {
        path:"/tiip/checkProgress/procurement/list/:userId",
        name:"tipProcurementProgress",
        component:()=>import("@/view/tiip/checkProgress/procurement/list.vue"),
        meta:{
          title:"采购进度查询"
        },
      },
      {
        path:"/tiip/checkProgress/procurement/detail",
        name:"tipProcurementProgressDetail",
        component:()=>import("@/view/tiip/checkProgress/procurement/detail.vue"),
        meta:{
          title:"采购进度查询"
        },
      },
      {
        path:"/tiip/checkProgress/process/list/:userId",
        name:"tipProcessProgress",
        component:()=>import("@/view/tiip/checkProgress/process/list.vue"),
        meta:{
          title:"加工进度查询"
        },
      },
      {
        path:"/tiip/checkProgress/process/detail",
        name:"tipProcessProgressDetail",
        component:()=>import("@/view/tiip/checkProgress/process/detail.vue"),
        meta:{
          title:"加工进度查询"
        },
      },
    ]
  }
];

let shopVersionRoutes = [
  {
    name:'main',
    component: () => import('@/view/main.vue'),
    path:'/main',
    children:[
      {
        path:'/shopVersion',
        name:'shopVersion',
        component:()=> import('@/view/shopVersion/index.vue'),
        meta:{
          title: '布一样'
        }
      }
    ]
  },
  {
    name:'shopVersion',
    component: () => import('@/view/shopVersion/index.vue'),
    path:'/shopVersion',
    children:[
      {
        path:'form/index/:iProjectId',
        name:'shopVersionFormIndex',
        component:()=> import('@/view/shopVersion/form/index.vue'),
        meta:{
          title: '智能报表'
        }
      },
      {
        path:'form/empAna',
        name:'shopVersionFormEmpAna',
        component:()=> import('@/view/shopVersion/form/empAna/index.vue'),
        meta:{
          title: '员工排行'
        }
      },
      {
        path:'form/liabilities',
        name:'Liabilities',
        component:()=> import('@/view/shopVersion/form/liabilities/index.vue'),
        meta:{
          title: '负债分析'
        }
      },
      {
        path:'form/liabilitiesDetail/:iCustomerId/:mode',
        name:'LiabilitiesDetail',
        component:()=> import('@/view/shopVersion/form/liabilities/detail.vue'),
        meta:{
          title: '负债明细'
        }
      }
    ]
  }
]

export default [...tipRoutes,...shopVersionRoutes,...healthRoutes];