const F2 = require('@antv/f2/lib/index');
require('@antv/f2/lib/interaction/pan');
const ScrollBar = require('@antv/f2/lib/plugin/scroll-bar');

export const orderAmount = {
    data(){
        return {
            chartData3:[],
            chart3:null
        }
    },
    methods:{
        async renderChart3(){
            this.chart3 = new F2.Chart({
                id: 'chart3',
                pixelRatio: window.devicePixelRatio,
                plugins: ScrollBar,
            });
            let originX = [],originY = [];
            this.chartData3.forEach((x,y)=> {
                if(y<=5){
                    originX.push(x.sMonth);
                    originY.push(x.nAmount);
                }
            });
            this.chart3.source(this.chartData3, {
                sMonth: {
                    type:'cat',
                    values:originX
                }
            });
            this.chart3.tooltip({
                showCrosshairs: true,
                showItemMarker: false,
                background: {
                    radius: 2,
                    fill: '#1890FF',
                    padding: [ 3, 5 ]
                },
                nameStyle: {
                    fill: '#fff'
                },
                onShow: function onShow(ev) {
                    const items = ev.items;
                    items[0].name = items[0].title;
                    items[0].value = items[0].value + ' 元';
                    ev.items.splice(1,1);
                }
            });
            this.chart3.point().position('sMonth*nAmount').style({
                lineWidth: 1,
                stroke: '#fff'
            });
        
            this.chart3.interaction('pan');
            // 定义进度条
            this.chart3.scrollBar({
                mode: 'x',
                xStyle: {
                    backgroundColor: '#e8e8e8',
                    fillerColor: '#808080',
                    offsetY: -2
                }
            });
            this.chart3.line().position('sMonth*nAmount').color('#708bf6');

            this.chart3.render();
        }
    }
}