const F2 = require('@antv/f2/lib/index');
require('@antv/f2/lib/interaction/pan');
const ScrollBar = require('@antv/f2/lib/plugin/scroll-bar');

export const receivable = {
    data(){
        return {
            chartData2:[],
            chart2:null
        }
    },
    methods:{
        async renderChart2(){
            this.chart2 = new F2.Chart({
                id: 'chart2',
                pixelRatio: window.devicePixelRatio,
                plugins: ScrollBar,
            });
            let originX = [],originY = [];
            this.chartData2.forEach((x,y)=> {
                if(y<=5){
                    originX.push(x.sMonth);
                    originY.push(x.nPaydAmount);
                }
            });
            this.chart2.source(this.chartData2, {
                sMonth: {
                    type:'cat',
                    values:originX
                }
            });
            this.chart2.tooltip({
                showCrosshairs: true,
                showItemMarker: false,
                background: {
                    radius: 2,
                    fill: '#1890FF',
                    padding: [ 3, 5 ]
                },
                nameStyle: {
                    fill: '#fff'
                },
                onShow: function onShow(ev) {
                    const items = ev.items;
                    items[0].name = items[0].title;
                    items[0].value = items[0].value + ' 元';
                    ev.items.splice(1,1);
                }
            });
            
            this.chart2.line().position('sMonth*nPaydAmount').color('#708bf6');
            this.chart2.point().position('sMonth*nPaydAmount').style({
                lineWidth: 1,
                stroke: '#fff'
            });
            this.chart2.interaction('pan');
            // 定义进度条
            this.chart2.scrollBar({
                mode: 'x',
                xStyle: {
                    backgroundColor: '#e8e8e8',
                    fillerColor: '#808080',
                    offsetY: -2
                }
            });
            this.chart2.render();
        }
    }
}