
import Axios from 'axios';
import Qs from 'qs';
import Vue from 'vue';
import  { ConfirmPlugin,ToastPlugin } from 'vux'

Vue.use(ConfirmPlugin)
let vm = new Vue()
window.d = vm;

const config = {
  baseURL: '',
  timeout: 300000, 
  withCredentials: true, //是否允许跨域
  headers: {'Content-Type': 'application/json;charset=UTF-8', 'X-Requested-With': 'XMLHttpRequest'},
  //返回数据类型
  responseType: 'json'
};
const AsInst = Axios.create(config);

// AsInst.defaults.timeout = 300000;
//请求拦截器
AsInst.interceptors.request.use((config) => {
  //若是有做鉴权token , 就给头部带上token
  // if (window.localStorage.getItem('loginToken')) {
  //   config.headers.Authorization = `${window.localStorage.getItem('loginToken')}`;
  // }
  return config;
}, (err) => {
  return Promise.reject(err);
});
//响应拦截器
AsInst.interceptors.response.use(response => {
  //检查数据是否返回NULL
  // if (response.data === null) {
  //   return Promise.reject(response);
  // }
  // //检查是否有错误
  // if(response.data.code!=0){
  //   return Promise.reject(response);
  // }
  return response;
}, (error) => {
  if(error.response.data&&error.response.data.hasOwnProperty('error_data')){
    vm.$vux.confirm.show({
      title:"提示",
      content:error.response.data.error_title,
      showCancelButton:false,
    })
  }
  // 下面是接口回调的status ,因为我做了一些错误页面,所以都会指向对应的报错页面
  if (error.response.status === 404) {
      Vue.prototype.$toast('请求接口不存在！',2000)
      // Message.error('后端服务请求404错误');
  }
  //请求错误时做些事
  return Promise.reject(error);
});
export default AsInst;
