import UTF8 from 'crypto-js/enc-utf8'
import sha256 from 'crypto-js/hmac-sha256'
const _getHeaderUrl = Symbol('_getHeaderUrl')
const secretKey = '018f162e804f945ee6b23aebfa863639';
const signatureUtil={
    makeSignPlain(queryStringMap, body, timestamp, nonce) {
      let signPlain = '';
      [...queryStringMap.keys()].sort((a, b) => {
        if (a.toString().toLowerCase() > b.toString().toLowerCase()) {
          return 1
        }
        return -1
      }).forEach(key => {
        if (queryStringMap.get(key) !== '') {
          signPlain += `${key}=${queryStringMap.get(key)}&`
        }
      })
      if (signPlain.length > 1) {
        signPlain = signPlain.substring(0, signPlain.length - 1)
      }
      if (body) {
        signPlain += JSON.stringify(body)
      }
      signPlain += timestamp.toString() + nonce.toString()
      // console.log('签名结果：', signPlain)
      // signPlain = sha256.hmac('018f162e804f945ee6b23aebfa863639', signPlain);
      signPlain = sha256(signPlain, secretKey).toString(UTF8.Utfd)
      return signPlain
    },
    getRandom(len = 5) {
      return parseInt(Math.random() * Math.pow(10, len))
    },
    getTimeStamp() {
      return parseInt(new Date().getTime() / 1000)
    },
    IgnoreTransform(a, b) {
      if (a.toString().toLowerCase() > b.toString().toLowerCase()) {
        return 1
      }
      return -1
    }
}

export default class HSHttpClient{
    // pathData:路由参数 query: 问号参数 body: body参数
    constructor(url, pathData = {}, query = {}, body = '') {
        this.urlParams = new Map()
        this.realUrl = url
        this[_getHeaderUrl](pathData) // 处理路由参数
        this.newUrl = this.getSignRequestUrl(query, body) // 处理问号参数和body参数
      }
      [_getHeaderUrl](params) {
        for (let key in params.data) {
          params.routerUrl = params.routerUrl.replace(key, encodeURIComponent(params.data[key]))
          this.urlParams.set(key, params.data[key])
        }
        if (params.routerUrl) {
          this.realUrl = this.realUrl + params.routerUrl + '/'
        }
      }
    getSignRequestUrl(paramsObj, body = '') {
      let returnUrl = ''
      let tempParamsUrl = ''
      if (paramsObj) {
        for (var key in paramsObj) {
          tempParamsUrl += `&${key}=${encodeURIComponent(paramsObj[key])}`
          this.urlParams.set(key, paramsObj[key])
        }
      }
      let timestamp = signatureUtil.getTimeStamp()
      let nonce = signatureUtil.getRandom(5)
      let signaPlain = signatureUtil.makeSignPlain(this.urlParams, body, timestamp, nonce)
      returnUrl = `${this.realUrl}?timestamp=${timestamp}&nonce=${nonce}&signature=${signaPlain}${tempParamsUrl}`
      return returnUrl
    }
}