import Axios from 'axios';

var now = new Date(); //当前日期
var nowDayOfWeek = now.getDay(); //今天本周的第几天
var nowDay = now.getDate(); //当前日
var nowMonth = now.getMonth(); //当前月
var nowYear = now.getYear(); //当前年
nowYear += (nowYear < 2000) ? 1900 : 0; //


let util = {

};
util.title = function (title) {
  title = title || '';
  window.document.title = title;
};

/**
 * 返回当前日期
 * @returns {string}
 */
util.currentDate = () => {
  let myDate = new Date();
  let year = parseInt(myDate.getFullYear()); //获取完整的年份(4位,1970-????)
  let month = parseInt(myDate.getMonth()) + 1; //获取当前月份(0-11,0代表1月)
  let day = parseInt(myDate.getDate()); //获取当前日(1-31)
  //小于10的时候
  if (month < 10) {
    month = 0 + month.toString();
  }
  if (day < 10) {
    day = 0 + day.toString();
  }
  return year.toString() + '-' +  month + '-' +day;
};

/**
 * 给一个日期返回时间戳
 * @param date
 * @returns {number}
 */
util.getTimestamp = (date) => {
  if (date) {
    return Date.parse(new Date(date));
  }
  return Date.parse(new Date());
};

util.fullscreenEvent = function (vm) {
  vm.$store.commit('initCachepage');
  // 权限菜单过滤相关
  vm.$store.commit('updateMenulist');
  // 全屏相关
};

util.getType = function (obj) {
  //tostring会返回对应不同的标签的构造函数
  var toString = Object.prototype.toString;
  var map = {
    '[object Boolean]': 'boolean',
    '[object Number]': 'number',
    '[object String]': 'string',
    '[object Function]': 'function',
    '[object Array]': 'array',
    '[object Date]': 'date',
    '[object RegExp]': 'regExp',
    '[object Undefined]': 'undefined',
    '[object Null]': 'null',
    '[object Object]': 'object'
  };
  if (obj instanceof Element) {
    return 'element';
  }
  return map[toString.call(obj)];
}

/**
 * 深拷贝
 * @param {} data
 */
util.deepClone = function (data) {
  var type = util.getType(data);
  var obj;
  if (type === 'array') {
    obj = [];
  } else if (type === 'object') {
    obj = {};
  } else {
    //不再具有下一层次
    return data;
  }
  if (type === 'array') {
    for (var i = 0, len = data.length; i < len; i++) {
      obj.push(util.deepClone(data[i]));
    }
  } else if (type === 'object') {
    for (var key in data) {
      obj[key] = util.deepClone(data[key]);
    }
  }
  return obj;
}

util.dateFormat = function (str, fmt) {
  var usedDate = new Date(util.getType(str) == 'string' ? str.split('.')[0].replace(/-/g, "/") : str);
  var o = {
    "M+": usedDate.getMonth() + 1, //月份
    "d+": usedDate.getDate(), //日
    "h+": usedDate.getHours(), //小时
    "m+": usedDate.getMinutes(), //分
    "s+": usedDate.getSeconds(), //秒
    "q+": Math.floor((usedDate.getMonth() + 3) / 3), //季度
    "S": usedDate.getMilliseconds() //毫秒
  };
  if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (usedDate.getFullYear() + "").substr(4 - RegExp.$1.length));
  for (var k in o)
    if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
  return fmt;
}


util.cutDate = function (date, cutDay, boolean) {
  var Now_Timestamp = date.getTime();
  var CutDay_Timestamp = cutDay * 1000 * 60 * 60 * 24;
  var New_Timestamp = Now_Timestamp - CutDay_Timestamp;
  return util.dateFormat(new Date(New_Timestamp), 'yyyy-MM-dd');
}

/**
 * 去字符串空格
 * @param {*} str
 */
util.Trim = function (str) {
  return str.replace(/(^\s*)|(\s*$)/g, "");
}

/**
 * 手机正则验证
 */
util.isMobile = function (value) {
  return /^(13[0-9]|15[0-9]|16[0-9]|17[0-9]|1[89][0-9]|14[57])[0-9]{8}$/.test(this.Trim(value)) || /^(0\d{2,3}-\d{7,8})/.test(value);
}

/**
 *保留两位小数
  //功能：将浮点数四舍五入，取小数点后2位 } x
 */
util.toDecimal = function (x) {
  var f = parseFloat(x);
  if (isNaN(f)) {
    return;
  }
  f = Math.round(x * 100) / 100;
  return f;
}

var _AgentInfo = {
  deviceType: "", // pc or mobile
  OSname: "", // windows, Android, linux and so on...
  browserName: "", //  chrome, safari, firefox, IE and so on...
  browserVer: "", //  browser version， important if in IE environment.
  adaptType: 0, // A type value, Adapt to the screen due to width
  _init: function () {
    _AgentInfo.setDeviceAndOS();
    _AgentInfo.setBrowser();
  },
  setDeviceAndOS: function () {
    var name = "unknown";
    if (window.navigator.userAgent.indexOf("Android") != -1) {
      name = "Android";
    } else if (window.navigator.userAgent.indexOf("iPhone") != -1) {
      name = "iPhone";
    } else if (window.navigator.userAgent.indexOf("SymbianOS") != -1) {
      name = "SymbianOS";
    } else if (window.navigator.userAgent.indexOf("Windows Phone") != -1) {
      name = "Windows Phone";
    } else if (window.navigator.userAgent.indexOf("iPad") != -1) {
      name = "iPad";
    } else if (window.navigator.userAgent.indexOf("iPod") != -1) {
      name = "iPod";
    }
    if (name != "unknown") {
      _AgentInfo.OSname = name;
      _AgentInfo.deviceType = "mobile";
      return;
    }
    if (window.navigator.userAgent.indexOf("Windows NT 10.0") != -1) {
      name = "Windows 10";
    } else if (window.navigator.userAgent.indexOf("Windows NT 6.2") != -1) {
      name = "Windows 8";
    } else if (window.navigator.userAgent.indexOf("Windows NT 6.1") != -1) {
      name = "Windows 7";
    } else if (window.navigator.userAgent.indexOf("Windows NT 6.0") != -1) {
      name = "Windows Vista";
    } else if (window.navigator.userAgent.indexOf("Windows NT 5.1") != -1) {
      name = "Windows XP";
    } else if (window.navigator.userAgent.indexOf("Windows NT 5.0") != -1) {
      name = "Windows 2000";
    } else if (window.navigator.userAgent.indexOf("Mac") != -1) {
      name = "Mac/iOS";
    } else if (window.navigator.userAgent.indexOf("Linux") != -1) {
      name = "Linux";
    } else if (window.navigator.userAgent.indexOf("X11") != -1) {
      name = "UNIX";
    }
    _AgentInfo.OSname = name;
    _AgentInfo.deviceType = "pc";
  },
  setBrowser: function () {
    var nAgt = navigator.userAgent;
    var browserName = navigator.appName;
    var fullVersion = '' + parseFloat(navigator.appVersion);
    var majorVersion = parseInt(navigator.appVersion, 10);
    var nameOffset, verOffset, ix;
    if ((verOffset = nAgt.indexOf("Opera")) != -1) { // In Opera, the true version is after "Opera" or after "Version"
      browserName = "Opera";
      fullVersion = nAgt.substring(verOffset + 6);
      if ((verOffset = nAgt.indexOf("Version")) != -1)
        fullVersion = nAgt.substring(verOffset + 8);
    } else if ((nAgt.indexOf("Trident")) != -1) { // ( ver >= ie7) In MSIE, the true version is after "MSIE" in userAgent
      if ((verOffset = nAgt.indexOf("MSIE")) != -1) {
        fullVersion = nAgt.substring(verOffset + 5);
      } else {
        fullVersion = '11.0';
      }
      if (fullVersion == 5) {
        fullVersion = "11.0";
      }
      browserName = "IE";
    } else if ((verOffset = nAgt.indexOf("Chrome")) != -1) { // In Chrome, the true version is after "Chrome"
      browserName = "Chrome";
      fullVersion = nAgt.substring(verOffset + 7);
    } else if ((verOffset = nAgt.indexOf("Safari")) != -1) { // In Safari, the true version is after "Safari" or after "Version"
      browserName = "Safari";
      fullVersion = nAgt.substring(verOffset + 7);
      if ((verOffset = nAgt.indexOf("Version")) != -1)
        fullVersion = nAgt.substring(verOffset + 8);
    } else if ((verOffset = nAgt.indexOf("Firefox")) != -1) { // In Firefox, the true version is after "Firefox"
      browserName = "Firefox";
      fullVersion = nAgt.substring(verOffset + 8);
    } else if ((nameOffset = nAgt.lastIndexOf(' ') + 1) < (verOffset = nAgt.lastIndexOf('/'))) { // In most other browsers, "name/version" is at the end of userAgent
      browserName = nAgt.substring(nameOffset, verOffset);
      fullVersion = nAgt.substring(verOffset + 1);
      if (browserName.toLowerCase() == browserName.toUpperCase()) {
        browserName = navigator.appName;
      }
    }
    if ((ix = fullVersion.indexOf(";")) != -1) // trim the fullVersion string at semicolon/space if present
      fullVersion = fullVersion.substring(0, ix);
    if ((ix = fullVersion.indexOf(" ")) != -1)
      fullVersion = fullVersion.substring(0, ix);
    majorVersion = parseInt('' + fullVersion, 10);
    if (isNaN(majorVersion)) {
      fullVersion = '' + parseFloat(navigator.appVersion);
      majorVersion = parseInt(navigator.appVersion, 10);
    }
    _AgentInfo.browserName = browserName;
    _AgentInfo.browserVer = fullVersion;
  },
  isMobile: function () {
    if (_AgentInfo.deviceType == "mobile") {
      return true;
    }
    return false;
  },
  setAdaptType() { // A type value, Adapt to the screen due to width. For convenient
    if (screen.width <= 374) {
      _AgentInfo.adaptType = 0;
    } else if (screen.width <= 413) {
      _AgentInfo.adaptType = 1;
    } else {
      _AgentInfo.adaptType = 2;
    }
  }
}
_AgentInfo._init();

util.agentInfo = _AgentInfo;

util.getWeekStartDate = function () {
  var weekStartDate;
  if (nowDayOfWeek == 0) {
    weekStartDate = new Date(nowYear, nowMonth, nowDay - nowDayOfWeek - 6);
  } else {
    weekStartDate = new Date(nowYear, nowMonth, nowDay - nowDayOfWeek + 1);
  }
  return util.dateFormat(weekStartDate, 'yyyy-MM-dd')
}

util.getYearStartDate = function () {
  //获得当前年份4位年
  var currentYear = now.getFullYear();
  //本年第一天
  var currentYearFirstDate = new Date(currentYear, 0, 1);
  return util.dateFormat(currentYearFirstDate, 'yyyy-MM-dd');
}

/**
 * 格式化金额为千分位显示
 */
util.toThousands = function (num) {
  if (num) {
    return num.toString().replace(/\d+/, function (n) {
      return n.replace(/(\d)(?=(\d{3})+$)/g, function ($1) {
        return $1 + ",";
      });
    });
  } else {
    return 0;
  }
}

/**
 * 小数转换为百分数
 */
util.toPercent = function (point) {
  var str = Number(point * 100).toFixed(2);
  str += "%";
  return str;
}

util.arrayToTree = function (data, id, pid) { //将ID、ParentID这种数据格式转换为树格式
  if (!data || !data.length) return [];
  var targetData = []; //存储数据的容器(返回) 
  var records = {};
  var itemLength = data.length; //数据集合的个数
  for (var i = 0; i < itemLength; i++) {
    var o = data[i];
    records[o[id]] = o;
  }
  for (var i = 0; i < itemLength; i++) {
    var currentData = data[i];
    var parentData = records[currentData[pid]];
    if (!parentData) {
      targetData.push(currentData);
      continue;
    }
    parentData.children = parentData.children || [];
    parentData.children.push(currentData);
  }
  return targetData;
}

util.code2name = function(arr,x,y,value){
  let data;
  arr.map(k=>{
    if(k[x] == value){
      data = k[y];
    }
  })
  return data;
}

//判断是IOS还是Android
util.isIos = function() {
  var userAgent = navigator.userAgent;
  var isAndroid = userAgent.indexOf('Android') > -1 || userAgent.indexOf('Adr') > -1; //android终端
  var isiOS = !!userAgent.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
  if (isAndroid) {
      return false;
  } else if (isiOS) {
      return true;
  }
}
util.getDate = (type) => {
  var date = new Date();
  switch(type){
      case '本日':
          return util.dateFormat(new Date(),'yyyy-MM-dd');
          break;
      case '本周':
          var day = date.getDay() || 7;
          return util.dateFormat(new Date(date.getFullYear(), date.getMonth(), date.getDate() + 1 - day),'yyyy-MM-dd');
          break;
      case '本月':
          return util.dateFormat(new Date(),'yyyy-MM') + '-01';
          break;
      case '本年':
          return `${date.getFullYear()}-01-01`
          break;
      default:
          break;
  }
}

//自动生成颜色
util.Colors=function(hslLength){
    this.hslLength = hslLength?hslLength:1;
    this.cArray = [ "0","1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"];
    this.hslArray = [];
};
//返回颜色数组
util.Colors.prototype.rgbArray=function() {
    var self = this;
    this.hslArray = this.getHslArray();
    if(!self.hslArray.length) return [];

    var rgbArray = self.hslArray.map(function(item) {
        return self.hslToRgb.apply(this, item);
    });

    return rgbArray.map(function(item) {
        return {
            //三原色值
            value: item,
            //16进制的颜色
            hex: self.rgbToHexadecimal(item),
            //rgb颜色
            rgb: item.toString(),
        }
    });
};
/**
 * RGB颜色转为16进制
 * @param {Object} item rgb颜色数组
 */
util.Colors.prototype.rgbToHexadecimal = function(item) {
if(item && item.length == 3){
    var a = item[0], b = item[1], c = item[2], d="#", cArray = this.cArray;
    d += cArray[Math.floor(a/16)] + "" + cArray[a%16] + "";
    d += cArray[Math.floor(b/16)] + "" + cArray[b%16] + "";
    d += cArray[Math.floor(c/16)] + "" + cArray[c%16] + "";
    return d;
}
};

/**
 * HSL颜色值转换为RGB
 * H，S，L 设定在 [0, 1] 之间
 * R，G，B 返回在 [0, 255] 之间
 *
 * @param H 色相
 * @param S 饱和度
 * @param L 亮度
 * @returns Array RGB色值
 */
util.Colors.prototype.hslToRgb = function(H, S, L) {
    var R, G, B;
    if(+S === 0) {
        R = G = B = L; // 饱和度为0 为灰色
    } else {
        var hue2Rgb = function(p, q, t) {
            if(t < 0) t += 1;
            if(t > 1) t -= 1;
            if(t < 1 / 6) return p + (q - p) * 6 * t;
            if(t < 1 / 2) return q;
            if(t < 2 / 3) return p + (q - p) * (2 / 3 - t) * 6;
            return p;
        };
        var Q = L < 0.5 ? L * (1 + S) : L + S - L * S;
        var P = 2 * L - Q;
        R = hue2Rgb(P, Q, H + 1 / 3);
        G = hue2Rgb(P, Q, H);
        B = hue2Rgb(P, Q, H - 1 / 3);
    }
    return [Math.round(R * 255), Math.round(G * 255), Math.round(B * 255)];
};

// 获取随机HSL
util.Colors.prototype.randomHsl = function() {
    var H = Math.random();
    var S = Math.random();
    var L = Math.random();
    return [H, S, L];
},

// 获取HSL数组
util.Colors.prototype.getHslArray= function() {
    var HSL = [];
    var hslLength = this.hslLength ? this.hslLength : 1;
    for(var i = 0; i < hslLength; i++) {
        var ret = this.randomHsl();

        // 颜色相邻颜色差异须大于 0.25
        if(i > 0 && Math.abs(ret[0] - HSL[i - 1][0]) < 0.25) {
            i--;
            continue; // 重新获取随机色
        }
        ret[1] = 0.7 + (ret[1] * 0.2); // [0.7 - 0.9] 排除过灰颜色
        ret[2] = 0.4 + (ret[2] * 0.3); // [0.4 - 0.8] 排除过亮过暗色

        // 数据转化到小数点后两位
        ret = ret.map(function(item) {
            return parseFloat(item.toFixed(2));
        });

        HSL.push(ret);
    }
    return HSL;
};
// util.pageReturn = function(){
//    /*微信自带返回按钮，不刷新，刷新页面start*/
//   if (util.isIos()) {
//     var isPageHide = false;
//     window.addEventListener('pageshow', function () {
//         if (isPageHide) {
//             window.location.reload();
//         }
//     });
//     window.addEventListener('pagehide', function () {
//         isPageHide = true;
//     });
//   } else {
//     var needRefresh = sessionStorage.getItem("need-refresh");
//     if (needRefresh) {
//         sessionStorage.removeItem("need-refresh");
//         window.location.reload();
//     }
//   }
// }

export default util;