// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue';
import FastClick from 'fastclick';
import VueRouter from 'vue-router';
import App from './App';
import Http from './libs/http';
import routes from './router';
import Util from './libs/util';
import store from './store';
import VueWechatTitle from 'vue-wechat-title';
import Toast from './libs/toast/';
// import 'lib-flexible';
import 'layui-src/dist/css/layui.css'
import 'layui-src/dist/layui.js'
import Vuetify from 'vuetify'
import 'vuetify/dist/vuetify.min.css' // Ensure you are using css-loader
import 'babel-polyfill'
import echarts from 'echarts' 
import Calendar from 'vue-mobile-calendar/lib/install.js'
import F2 from '@antv/f2';
import  { ConfirmPlugin,ToastPlugin,DatetimePlugin,LoadingPlugin } from 'vux'
import urlFun from './libs/host.js'
import Meta from 'vue-meta';


Vue.use(Meta);
Vue.use(Calendar)
Vue.use(Vuetify)
Vue.use(VueWechatTitle);
Vue.use(VueRouter);
Vue.use(Http);
Vue.use(Toast)
Vue.use(ConfirmPlugin);
Vue.use(ToastPlugin);
Vue.use(DatetimePlugin);
Vue.use(LoadingPlugin);


Vue.prototype.global = new Vue({});
Vue.prototype.util = Util;
Vue.prototype.$echarts = echarts
Vue.prototype.$F2 = F2
Vue.prototype.$url = urlFun


function getAbsolutePath () {
  let path = location.pathname
  // return path.substring(0, path.lastIndexOf('/') + 1)
  let base;
  if(path.indexOf('/apiproxy/huansi/hszh_report') != -1){
    base = '/apiproxy/huansi/hszh_report/main';
  }else{
    base = '/main';
  }
  return base;
 }
const router = new VueRouter({
  mode:'history',
  routes,
  base:getAbsolutePath()
})

FastClick.attach(document.body)

Vue.config.productionTip = false;

router.beforeEach((to, from, next) => {
  if(to.params.hasOwnProperty('iProjectId')){
    store.dispatch('setIproject',to.params.iProjectId);
  }else if(to.query.hasOwnProperty('iProjectId')){
    console.log(to.query.iProjectId)
    store.dispatch('setIproject',to.query.iProjectId);
  }
  if(to.name != 'tiipOperateDetail'){
    store.dispatch("CAHNGE_META_INFO", {title:to.meta.title})
  }
  next();
})
/* eslint-disable no-new */
new Vue({
  router,
  render: h => h(App),
  router: router,
  store: store,
  data:{},
  mounted(){
    
  },
  created(){

  },
  metaInfo(){
    return {
      title: store.state.app.metaInfo.title,
      meta: [
        {
          name:"keywords",
          content: store.state.app.metaInfo.keywords
        },{
          name:"description",
          content: store.state.app.metaInfo.description
        }
      ]
    }
  },
}).$mount('#app')
