import Util from '@/libs/util';
import Vue from 'vue';

const app = {
    state: {
        userInfo:{},
        chartHearData:{},
        iProjectId:5599,
        userId:'1115442959606779905',
        metaInfo: {
            title: "",
            keywords: "",
            description: ""
        },
        isRefresh:false
    },
    mutations: {
        saveUserId(state,data){
            state.userId = data;
        },
        getUserInfo(state,obj){
            state.userInfo = obj;
        },
        setChartHearData(state,obj){
            state.chartHearData = obj;
        },
        setIproject(state,data){
            state.iProjectId = data;
        },
        CAHNGE_META_INFO(state, metaInfo) {
            state.metaInfo = metaInfo;
        },
        saveRefresh(state,isRefresh){
            state.isRefresh = isRefresh;
        }
    },
    actions: {
        saveUserId({commit},obj){
            commit('saveUserId',obj);
        },
        getUserInfo({commit},obj){
            commit('getUserInfo',obj);
        },
        setChartHearData({commit},obj){
            commit('setChartHearData',obj);
        },
        setIproject({commit},data){
            commit('setIproject',data)
        },
        CAHNGE_META_INFO({commit}, metaInfo) {
            commit('CAHNGE_META_INFO',metaInfo)
        },
        saveRefresh({commit}, isRefresh) {
            commit('saveRefresh',isRefresh)
        },
    }
};

export default app;
