const F2 = require('@antv/f2/lib/index');
require('@antv/f2/lib/interaction/interval-select');
const ScrollBar = require('@antv/f2/lib/plugin/scroll-bar');
const Gesture = require('@antv/f2/lib/plugin/gesture');
// 1.全局注册，也可以给 chart 的实例注册
F2.Chart.plugins.register(Gesture);

export const employees = {
    data(){
        return {
            chartData1:[],
            chart1:null
        }
    },
    methods:{
        async renderChart1(){
            const that = this;
            let originSalesName = [],originAmount = [];

            this.chartData1.forEach((x,y)=> {
                if(y<=5){
                    originSalesName.push(x.sSalesName);
                    originAmount.push(x.nAmount);
                }
            });

            this.chart1 = new F2.Chart({
                id: 'chart1',
                pixelRatio: window.devicePixelRatio,
                plugins: [ScrollBar,Gesture],
            });

            this.chart1.source(this.chartData1, {
                sSalesName: {
                    type:'cat',
                    tickCount: 6,
                    values:originSalesName
                },
                nAmount: {
                    tickCount: 10
                }
            });

            this.chart1.axis('sSalesName', {
                tickLine: {
                    length: 4,
                    stroke: '#cacaca'
                },
                label: {
                    fill: '#cacaca'
                },
                line: {
                    top: true
                }
            });
            this.chart1.axis('nAmount', {
                position: 'left',
                label: function label(text) {
                    return {
                        text: text,
                        fill: '#cacaca'
                    };
                },
                grid: {
                    stroke: '#d1d1d1'
                }
            });
            this.chart1.tooltip({
                showItemMarker: false,
                background: {
                    radius: 2,
                    padding: [ 3, 5 ]
                },
                onShow: function onShow(ev) {
                    const items = ev.items;
                    items[0].name = '';
                    items[0].value = items[0].value + ' 元';
                }
            });
            // this.chart1.interval().position('sSalesName*nAmount').style({
            //     radius: [ 2, 2, 0, 0 ]
            // });

            // 定义进度条
            this.chart1.scrollBar({
                mode: 'x',
                xStyle: {
                    backgroundColor: '#e8e8e8',
                    fillerColor: '#808080',
                    offsetY: -2
                }
            });
            this.chart1.interval()
            .position('sSalesName*nAmount')
            .color('l(90) 0:#708bf6 1:#00B2EE'); // 定义柱状图渐变色

            this.chart1.pluginGesture({
                gesture: {
                    press(data, event) {
                        that.title = data[0]._origin.sSalesName;
                        that.chartData2 = that.tempChartData2.filter(x=>x.iSalesId == data[0]._origin.iSalesId);
                        that.chartData3 = that.tempChartData3.filter(x=>x.iSalesId == data[0]._origin.iSalesId);
                        that.$set(that,'chartData2',that.chartData2);
                        that.$set(that,'chartData3',that.chartData3);
                        
                        setTimeout(()=>{
                            if(that.chartData2.length > 0){
                                that.chart2&&that.chart2.destroy();
                            }
                            if(that.chartData3.length > 0){
                                that.chart3&&that.chart3.destroy();
                            }
                            if(that.chartData2.length > 0){
                                that.renderChart2();
                            }
                            if(that.chartData3.length > 0){
                                that.renderChart3();
                            }
                        },600)
                        
                    }
                },
                hammerOptions: {},
                options: {},
            });
              
            this.chart1.interaction('pan');
            this.chart1.render();
        }
    }
}