# 运用git flow 来处理一下场景
    - 主分支 master 开发分支 dev 
    - 赤山项目代码是最新的tagv3.0.9
    - 环球项目代码版本是tag3.0.2(与最新版本差距7次迭代,不完全兼容最新版!)
## 预设:
 1. 本周定版,3.0.10,需要开发4个新功能:A,B,C,D;
 2. 同时还有一个新功能E,是下一个版本的功能,但是需要本周同步开发
 3. 对于dev分支,变动时,将自动部署到测试环境
 4. 对于release分支,上传到线上会自动打beta版本
 5. 对于正式发布的版本,会为tag打正式版,并删除beta版本

## case1: 周一时,如何对上述4个新功能进行开发,git flow如何操作?
```
新建四个feature 分别开发
git flow feature start A
git flow feature start B
git flow feature start C
git flow feature start D
```

## case2: 周4下午,当这4个功能都开发完成后,现在要进行封版处理,如何操作?
```
第一步先将四个feature 全部finish掉
git flow feature finish A
git flow feature finish B
git flow feature finish C
git flow feature finish D
第二步新建一个release 
git flow release start 3.0.10
将本地release/3.0.10 推送到远端
测试团队进行线上全面测试

```

## case3:  功能E对开始开发时间有要求吗?对合并时间有要求吗?
```
开发时间没有要求
合并要等到release/3.0.10 finish之后才能合并
```

## case4: 周5到周6,测试人员对即将发布的新版本3.0.10(beta)进行了测试,发现了新的bug,如何处理?

```
直接在release/3.0.10这个分支上修改,修改好后再部署测试
```
## case5: 下周一,上周的3.0.10测试完全通过,也没发现新的问题,需要正式发布,如何操作?

```
git flow release finish 3.0.10
将本地dev master tag3.0.10 推送到远端
这步骤操作完成后就交给部署人员去部署了
```
## case6: 又过了2天,项目里发现一个严重的bug,需要立马修复,如何操作?
```
新建 
git flow hotfix start 3.0.11
完成
git flow hotfix finish 3.0.11
将本地dev master tag3.0.11推送到远端
测试团队再测试一下这个bug
测试团队测试完成后再部署到项目
```

## case7: 环球项目,有一特殊需求新功能D需要开发,开发完成后测试并部署到项目中去,该如何操作?
```
由于这个环球项目落后很多,所以把他规划为长期支持版本,分离出 support,以后有啥bug都在这个support上面改. (最坏到结果是 以后会出现无数个support,又会回到原点....)
git branch support/hq 3.0.2
解决完bug或者新功能后,推送到远端,然后在测试环境测试,测试好之后,部署人员再部署到相应到项目中去!
```
