# 运用git flow 来处理一下场景

    - 主分支 master 开发分支 dev 
    - 赤山项目代码是最新的tagv3.0.9
    - 环球项目代码版本是tag3.0.2(与最新版本差距7次迭代,不完全兼容最新版!)

## 预设:

  1. 本周定版,3.0.10,需要开发4个新功能:A,B,C,D;
  2. 同时还有一个新功能E,是下一个版本的功能,但是需要本周同步开发
  3. 对于dev分支,变动时,将自动部署到测试环境
  4. 对于release分支,上传到线上会自动打beta版本
  5. 对于正式发布的版本,会为tag打正式版,并删除beta版本

## case1: 周一时,如何对上述4个新功能进行开发,git flow如何操作?

```
根据四个需求的耦合度建立若干个feature分支，按照任务分配开发。
```

## case2: 周4下午,当这4个功能都开发完成后,现在要进行封版处理,如何操作?

```
开发完成后开发人员自测通过合并回dev，通过dev生成release3.0.10的版本分支，测试人员基于此分支测试。
```

## case3:  功能E对开始开发时间有要求吗?对合并时间有要求吗?

```
开发时间无要求，但在本周发版前不能合并。
```

## case4: 周5到周6,测试人员对即将发布的新版本3.0.10(beta)进行了测试,发现了新的bug,如何处理?

```
直接从release3.0.10分出hotfix 3.0.10_{bug}分支进行紧急修复，修复完成合并回release3.0.10。
```

## case5: 下周一,上周的3.0.10测试完全通过,也没发现新的问题,需要正式发布,如何操作?

```
结束release3.0.10分支，合并回dev和master，并在master上打上3.0.10的tag。
```

## case6: 又过了2天,项目里发现一个严重的bug,需要立马修复,如何操作?

```
从master分出hotfix分支紧急修复，测试通过后合并回dev和master分支，并在master上打上{bugName}的tag。
```

## case7: 环球项目,有一特殊需求新功能D需要开发,开发完成后测试并部署到项目中去,该如何操作?

```
特殊需求与主版本分离的情况下，通过master上环球项目最新的版本tag3.0.2分出huanqiu分支，并在该分支创建realese版本，从此版本分出feature来进行新功能开发，开发完成测试通过后合并回realese版本，release版本确认发版之后合并回huanqiu分支并打上版本tag，之后此项目以huanqiu分支作维护。
```

