# 运用git flow 来处理一下场景
    - 主分支 master 开发分支 dev 
    - 赤山项目代码是最新的tagv3.0.9
    - 环球项目代码版本是tag3.0.2(与最新版本差距7次迭代,不完全兼容最新版!)
    - 请使用git flow 命令 https://github.com/danielkummer/git-flow-cheatsheet
## 预设:
    1. 本周定版,3.0.10,需要开发4个新功能:A,B,C,D;
    2. 同时还有一个新功能E,是下一个版本的功能,但是需要本周同步开发
    3. 对于dev分支,变动时,将自动部署到测试环境
    4. 对于release分支,上传到线上会自动打beta版本
    5. 对于正式发布的版本,会为tag打正式版,并删除beta版本

## case1: 周一时,如何对上述4个新功能进行开发,git flow如何操作?
    - 要创建A,B,C,D 4个feature
    - 使用命令如下:
    - git flow feature start A
    - git flow feature start B
    - git flow feature start C
    - git flow feature start D


## case2: 周4下午,当这4个功能都开发完成后,现在要进行封版处理,如何操作?
    - 4个功能都开发完成了,则需要结束4个分支的开发,并合并到dev,同时创建新的release分支3.0.10
    - 命令如下:
    - git flow feature finish A
    - git flow feature finish B
    - git flow feature finish C
    - git flow feature finish D
    - git flow release start 3.0.10


## case3:  功能E对开始开发时间有要求吗?对合并时间有要求吗?
    - 对开发时间:
        - 对E功能来说,什么时候开发没有要求,可以在A,B,C,D开始开发的同时,新建feature分支E,也可以在A,B,C,D都完成后新建feature E,但是如果E的功能与A,B,C,D有关系,则必须在A,B,C,D都finish合并到dev后
    - 对合并时间:
        - 由于E功能是下一个版本的内容,则必须在新建release 3.0.10分支后才可以finish开发合并回dev,否则会导致release 3.0.10包含E的功能


## case4: 周5到周6,测试人员对即将发布的新版本3.0.10(beta)进行了测试,发现了新的bug,如何处理?
    - 对于还没有finish开发的release分支,应该直接在release分支上解决bug,或者基于release分支使用bugfix分支继续开发
    - 使用bugfix时,假定新建分支bug001fix,注意,bugfix feature等默认都是基于dev的,所以此处必须指定base分支,finish时会自动合并回base分支
        - git flow bugfix start bug001fix release/3.0.10  
        - git flow bugfix finish bug001fix   


## case5: 下周一,上周的3.0.10测试完全通过,也没发现新的问题,需要正式发布,如何操作?
    - git flow release finish 3.0.10
    - 此时会弹出一个tag描述的文件,我们需要录入本次tag的变更内容,之后保存后关闭,程序将继续处理,如果直接关闭会导致finish失败


## case6: 又过了2天,项目里发现一个严重的bug,需要立马修复,如何操作?
    - 此时属于最新的发布版存在bug,适用hotfix分支,我们把版本号往上走一个到3.0.11,finish时与release合并一样,需要注入本次的tag信息保存后关闭编辑器会自动完成hotfix
    - git flow hotfix start 3.0.11  
    - git flow hotfix finish 3.0.11


## case7: 环球项目,有一特殊需求新功能D需要开发,开发完成后测试并部署到项目中去,该如何操作?
    - 由于不是最新的发布版存在bug,则需要把环球项目对应的release tag新建长期支持分支,假定我们继续使用小版本号发布新版本3.0.2.1,此时在huanqiu的分支上存在3.0.2.1的tag
    - 如果仅该项目使用,则应该使用项目编号:huanqiu作为分支名
        - git flow support start huanqiu  3.0.2
        - git flow feature start D support/huanqiu
        - git flow feature finish D
        - git flow release start  3.0.2.1  support/huanqiu
        - git flow release finish 3.0.2.1
    - 扩展:如果是在该大版本上继续往下支持新功能,则版本号应该持续往下走,假定我们最新版本是3.10版本,环球是3.2版,并且后续功能不止针对环球,而是正在3.2版本,则我们分支的长期支持版本应该就叫3.2
        - git flow support start 3.2  3.2     #表示从3.2的tag处新建分支新建长期支持版本3.2  ,前面的3.2为长期支持版本的名字,后面的3.2为base tag
        - git flow feature start D support/3.2
        - git flow feature finish D
        - git flow release start  3.2.1  support/3.2
        - git flow release finish 3.2.1  #此时会合并回support/3.2 并在此版本上新建tag 3.2.1
    
