# 运用git flow 来处理一下场景
    - 主分支 master 开发分支 dev 
    - 赤山项目代码是最新的tagv3.0.9
    - 环球项目代码版本是tag3.0.2(与最新版本差距7次迭代,不完全兼容最新版!)
## 预设:
 1. 本周定版,3.0.10,需要开发4个新功能:A,B,C,D;
 2. 同时还有一个新功能E,是下一个版本的功能,但是需要本周同步开发
 3. 对于dev分支,变动时,将自动部署到测试环境
 4. 对于release分支,上传到线上会自动打beta版本
 5. 对于正式发布的版本,会为tag打正式版,并删除beta版本

## case1: 周一时,如何对上述4个新功能进行开发,git flow如何操作?
```
按照每个功能新建出各个feature分支，开发完成一个就合并到dev一个，全部开发完成并上传到dev上后，dev分出release 3.0.10分支，进行测试
git clone -b dev git地址
git checkout -b A-feature dev //创建并切换到A-feature分支上
git add .  
git commit -m 'A'  //开发完成提交
git checkout dev 
git pull
git merge --no-ff A-feature  //在dev上对A-feature进行合并，并保留A-feature分支历史
git push //提交dev到线上
git branch -d A-feature //删除A-feature
以次类推
git checkout -b B-feature dev
......
直到ABCD功能全部开发完成上传到dev
然后
git checkout -b release-3.0.10 dev
进行测试

```

## case2: 周4下午,当这4个功能都开发完成后,现在要进行封版处理,如何操作?
```
开发人员在dev上测试通过后，新建出release 3.0.10分支，测试人员在基于3.0.10上进行测试，如期间出现bug，就新建hotfix改完合并回3.0.10在让
测试人员进行测试，测试通过后，开发人员合并回master，打上tag3.0.10进行封存
git checkout -b release-3.0.10 dev
git checkout master
git merge --no-ff release-3.0.10
git push
git branch -d release-3.0.10
git tag -a v0.1.0 master
git push --tags
```

## case3:  功能E对开始开发时间有要求吗?对合并时间有要求吗?
```
开发时间无要求，合并时间需在本周版本发布之后在进行上传合并
```

## case4: 周5到周6,测试人员对即将发布的新版本3.0.10(beta)进行了测试,发现了新的bug,如何处理?

```
新建hotfix 3.0.10_bug分支改完合并回3.0.10在让测试人员进行测试
git checkout dev
git merge --no-ff hotfix-3.0.10_bug
git push
git branch -d hotfix-3.0.10_bug
```
## case5: 下周一,上周的3.0.10测试完全通过,也没发现新的问题,需要正式发布,如何操作?

```
将release 3.0.10版本合并回master，打上tag，删除release 3.0.10
git checkout master
git merge --no-ff release-3.0.10
git push
git branch -d release-3.0.10
git tag -a v3.0.10 master
git push --tags
```
## case6: 又过了2天,项目里发现一个严重的bug,需要立马修复,如何操作?
```
从master上分出hotfix3.0.10_bug，修复完成后，根据合并回mater，再次打上3.0.10_bug分支
git checkout -b hotfix-3.0.10_bug master
git add .  
git commit -m 'hotfix-3.0.10_bug' 
git checkout master
git merge --no-ff hotfix-3.0.10_bug
git push
git branch -d hotfix-3.0.10_bug
git tag -a v3.0.10 master
git push --tags
```

## case7: 环球项目,有一特殊需求新功能D需要开发,开发完成后测试并部署到项目中去,该如何操作?
```
找到tag3.0.2的master分支，分出huanqiu分支，新建feature分支，开发完成后合并回huanqiu分支，打上release 3.0.2_功能D版本，测试在此版本上测试通过后，使用tag3.0.2_功能D huanqiu分支推到环球项目上
git checkout -b huanqiu master vtag3.0.2
git checkout -b D-feature huanqiu
git add .  
git commit -m 'D' 
git checkout huanqiu 
git pull
git merge --no-ff D-feature 
git push
git branch -d D-feature 
git tag -a v3.0.2_D huanqiu
git push --tags
```
