# 运用git flow 来处理一下场景
    - 主分支 master 开发分支 dev 
    - 赤山项目代码是最新的tagv3.0.9
    - 环球项目代码版本是tag3.0.2(与最新版本差距7次迭代,不完全兼容最新版!)
## 预设:
 1. 本周定版,3.0.10,需要开发4个新功能:A,B,C,D;
 2. 同时还有一个新功能E,是下一个版本的功能,但是需要本周同步开发
 3. 对于dev分支,变动时,将自动部署到测试环境
 4. 对于release分支,上传到线上会自动打beta版本
 5. 对于正式发布的版本,会为tag打正式版,并删除beta版本

## case1: 周一时,如何对上述4个新功能进行开发,git flow如何操作?
```
在最新的dev分支上根据要开发的功能，建立feature/A,feature/B,feature/C,feature/D
```

## case2: 周4下午,当这4个功能都开发完成后,现在要进行封版处理,如何操作?
```
开发完成之后，依次在各个功能分支上`git flow feature finish {分支名}`将功能挨个合并回dev和master，再提交dev到线上，自动触发测试环境部署，自我测试
测试期间出现问题，通过bugfix来修复错误。
自我测试完毕之后，本地执行`git flow release start 3.0.10`，紧接着`git flow release publish 3.0.10`，上传到线上自动打beta版本，交个测试组测试
```

## case3:  功能E对开始开发时间有要求吗?对合并时间有要求吗?
```
开始开发时间没有要求
这个是下版本的功能，要等到当前版本tag之后才能合并
```

## case4: 周5到周6,测试人员对即将发布的新版本3.0.10(beta)进行了测试,发现了新的bug,如何处理?
```
当前版本还没tag，支持在分支Release/3.0.10上修改，并提交，重新打一个`v3.0_beta`镜像，提交测试
```
## case5: 下周一,上周的3.0.10测试完全通过,也没发现新的问题,需要正式发布,如何操作?
```
本地执行`git flow release finish 3.0.10`，再上传dev，master，tag到线上仓库，自动触发正式版本的tag过程
```
## case6: 又过了2天,项目里发现一个严重的bug,需要立马修复,如何操作?
```
`git flow hotfix start 版本`，紧急修改之后，`git flow hotfix finish 版本`，再上传dev，master，tag到线上仓库，自动触发正式版本的tag过程
```

## case7: 环球项目,有一特殊需求新功能D需要开发,开发完成后测试并部署到项目中去,该如何操作?
```
环球的代码版本是tag3.0.2(与最新版本差距7次迭代,不完全兼容最新版!)
`git branch support/huanqiu 3.0.2`获取环球最新的代码，直接在该分支上修改，并提交，后续环球的镜像版本都为huanqiu
```