
import _ from 'lodash'
import tableHandle from './tableHandle'
const emptyList = [undefined, null]
/**
 * URL编码;
 * @param {参数} param
 */
function toParams(param) {
  var result = ''
  for (const name in param) {
    if (typeof param[name] !== 'function') {
      result += '&' + name + '=' + encodeURI(param[name])
    }
  }
  return result.substring(1)
}
function getUrlParams() {
  const { db_name, is_mock, db_code } = getURLParameters()
  const { appCode, pageName } = parseAppCodePageName()
  const isMock = emptyList.includes(is_mock) ? 1 : is_mock
  const obj = _.cloneDeep({
    dbName: db_name || '',
    appCode,
    pageName,
    isMock,
    dbCode: db_code
  })
  return obj
}
function getSysParams() {
  const { db_name, db_code } = getURLParameters()
  const {
    appCode,
    pageName
  } = parseAppCodePageName()
  const obj = _.cloneDeep({
    dbName: db_name,
    appCode,
    pageName: pageName,
    dbCode: db_code,
    pageCode: pageName
  })
  return obj
}
function getURLParameters(url) {
  const url_ = url || location.href
  const obj = (url_.match(/([^?=&]+)(=([^&]*))/g) || []).reduce(
    (a, v) => ((a[v.slice(0, v.indexOf('='))] = v.slice(v.indexOf('=') + 1)), a),
    {}
  )
  for (const k in obj) {
    obj[k] = typeof obj[k] === 'string' ? decodeURIComponent(obj[k]) : obj[k]
  }
  return obj
}
// 获取登录信息
function parseGlobalParams() {
  const globalParam = {}
  let user_info = sessionStorage['user_info']
  if (user_info && user_info !== 'undefined') {
    user_info = JSON.parse(decodeURIComponent(user_info))
  }
  Object.assign(globalParam, user_info)
  return globalParam
}
// 解析queryBi dync页面路由上的appCode 和pageName
function parseAppCodePageName() {
  const hash = decodeURIComponent(location.hash)
  const hostSplit = hash.split('?')
  let target = hostSplit[0]
  // 如果说最后一位是‘/’ 则删除掉
  if (target.endsWith('/')) {
    target = target.substr(0, target.length - 1)
  }
  const targetSplit = target.split('/')
  const length = targetSplit.length
  let pageName = targetSplit[length - 1]
  const appCode = targetSplit[length - 2]
  if (pageName.includes('/')) {
    pageName = pageName.split('/')[0]
  }
  if (pageName.includes('?')) {
    pageName = pageName.split('?')[0]
  }
  return {
    appCode,
    pageName
  }
}
function filterSingleRow(newObj, oldObj, prop = 'id') {
  delete newObj.isSelected
  delete oldObj.isSelected
  const _newObj = _.cloneDeep(newObj)
  const _oldObj = _.cloneDeep(oldObj)
  const result = {}
  for (const p in _newObj) {
    if ((_oldObj[p] !== _newObj[p] && !emptyList.includes(_newObj[p])) || p === prop) {
      result[p] = _newObj[p]
    }
  }
  return result
}
// newData:当前数据.oldData:原始数据,primaryKey;主键id,reservedObj:保留字段
function comparisonArray(newData_, oldData_, primaryKey, reservedArray = []) {
  const newData = _.cloneDeep(newData_)
  const oldData = _.cloneDeep(oldData_)
  const emptyValue = [undefined, 'undefined', '']
  // 1,找出原始数据中所有的id
  const old_ids = oldData.reduce((pre, curr) => {
    const id = curr[primaryKey]
    if (id) {
      pre.push(id)
    }
    return pre
  }, [])
  // 2,找出新数据中所有项的id
  const new_ids = newData.reduce((pre, curr) => {
    const id = curr[primaryKey]
    if (id) {
      pre.push(id)
    }
    return pre
  }, [])

  // 3,找出删除项
  const delete_ids = old_ids.filter(item => {
    if (!new_ids.includes(item)) {
      return item
    }
  })
  const newItems = newData_.filter(item => {
    if (item.iUpdateStatus === 1) {
      return item
    }
  })

  // 找出修改项目
  const edit_item = newData.filter(item => {
    delete item.isSelected
    const id = item[primaryKey]
    const curr_old_item = oldData.find(element => {
      if (element[primaryKey] === id && item.iUpdateStatus !== 1) {
        return element
      }
    })
    if (id && curr_old_item) {
      // 找出变化的字段 并且保留必要字段
      for (const key in curr_old_item) {
        const hasKey = key in item
        if (!hasKey) { // 如果这个字段不在现有行中 则视为删除了
          item[key] = ''
        } else { // 如果字段对应的值相等 则视为 没更改 提交数据时把这个这段排除
          if (curr_old_item[key] === item[key] && key !== primaryKey && !reservedArray.includes(key)) {
            delete item[key]
          }
        }
      }
      const length1 = Object.keys(item).length
      if (length1 > 1) {
        return item
      }
    }
  })
  // 组装数据
  // 为新增项加一个标示
  newItems.forEach((item, index) => {
    delete item.isSelected
    // 删除空值
    for (const key in item) {
      const value = item[key]
      if (emptyValue.includes(value)) {
        delete item[key]
      }
    }
    delete item._columns
  })
  // 筛选出非空项
  const newItems_ = newItems.filter(item => Object.keys(item).length)
  // 为修改项加标示
  edit_item.filter(item => Object.keys(item).length).forEach(item => {
    delete item.isSelected
    for (const k in item) {
      if (item[k] === undefined) {
        item.k = ''
      }
    }
    if (Object.keys(item).length > 1) {
      item.iUpdateStatus = 2
    }
  })
  const delete_items = []
  delete_ids.forEach(item => {
    const parm = {
      iUpdateStatus: 4
    }
    parm[primaryKey] = item
    delete_items.push(parm)
  })
  const result = [...edit_item, ...delete_items, ...newItems_]
  return result
}
function checkRowChange(newData, oldData) {
  for (const n_k in newData) {
    if (oldData[n_k] !== newData[n_k]) {
      return
    }
  }
  return true
}
function checkListChange(newList, oldList, primaryKey) {
  if (newList.length !== oldList.length) return false
  for (let i = 0; i < newList.length; i++) {
    const item = newList[i]
    const id = item[primaryKey]
    const targetOldItem = oldList.find(x => x[primaryKey] === id)
    if (!targetOldItem) return
    const r = checkRowChange(item, targetOldItem)
    return r
  }
  return true
}
function comparisonJson(newData_, oldData_, primaryKey, reservedArray = []) {
  const newData = _.cloneDeep(newData_)
  const oldData = _.cloneDeep(oldData_)
  const emptyValue = [undefined, 'undefined']
  const iUpdateStatus = newData.iUpdateStatus
  if (iUpdateStatus === 1) { // 新增
    for (const key in newData) {
      if (key === '') {
        delete newData[key]
      }
      const value = newData[key]
      if (emptyValue.includes(value)) {
        delete newData[key]
      }
    }
  } else { // 修改
    for (const key in newData) {
      if (key === '') {
        delete newData[key]
      }
      if (newData[key] === oldData[key] && key !== primaryKey && !reservedArray.includes(key)) {
        delete newData[key]
      }
    }
    newData.iUpdateStatus = 2
  }
  delete newData._columns
  return newData
}

function getClientHeight() {
  var clientHeight = 0
  if (document.body.clientHeight && document.documentElement.clientHeight) {
    clientHeight = (document.body.clientHeight < document.documentElement.clientHeight) ? document.body.clientHeight : document.documentElement.clientHeight
  } else {
    clientHeight = (document.body.clientHeight > document.documentElement.clientHeight) ? document.body.clientHeight : document.documentElement.clientHeight
  }
  return clientHeight
}
function getClientWidth() {
  var clientWidth = 0
  if (document.body.clientWidth && document.documentElement.clientWidth) {
    clientWidth = (document.body.clientHeight < document.documentElement.clientWidth) ? document.body.clientWidth : document.documentElement.clientWidth
  } else {
    clientWidth = (document.body.clientWidth > document.documentElement.clientWidth) ? document.body.clientWidth : document.documentElement.clientWidth
  }
  return clientWidth
}
// 给webframe壳子发消息
function sendErrorToWebframe(err) {
  var data = {}
  data.type = 'errorMSg'
  data.data = err
  console.log(data)
  top.postMessage(data, '*')
}
function getType(data, type) {
  const inner = Object.prototype.toString.call(data) // [object String]
  if (inner === type) return true
  // Object.prototype.toString.call(1) // [object Number]
  // Object.prototype.toString.call(true) // [object Boolean]
  // Object.prototype.toString.call(Symbol()) // [object Symbol]
  // Object.prototype.toString.call(undefined) // [object Undefined]
  // Object.prototype.toString.call(null) // [object Null]
  // Object.prototype.toString.call(new Function()) // [object Function]
  // Object.prototype.toString.call(new Date()) // [object Date]
  // Object.prototype.toString.call([]) // [object Array]
  // Object.prototype.toString.call(new RegExp()) // [object RegExp]
  // Object.prototype.toString.call(new Error()) // [object Error]
  // Object.prototype.toString.call(document) // [object HTMLDocument]
  // Object.prototype.toString.call(window) // [object global] window 是全局对象 global 的引用
}
function isObject(data) {
  return Object.prototype.toString.call(data) === '[object Object]'
}
function isNull(data) {
  return Object.prototype.toString.call(data) === '[object Null]'
}
function isUndefined(data) {
  return Object.prototype.toString.call(data) === '[object Undefined]'
}
function isBoolean(data) {
  return Object.prototype.toString.call(data) === '[object Boolean]'
}
function isNumber(data) {
  return Object.prototype.toString.call(data) === '[object Number]'
}
function isFunction(data) {
  return Object.prototype.toString.call(data) === '[object Function]'
}
function isArray(data) {
  return Object.prototype.toString.call(data) === '[object Array]'
}
function hasClass(dom, selector) {
  if (dom.classList.contains(selector)) {
    return true
  } else {
    return false
  }
}
export default {
  getUrlParams,
  parseGlobalParams,
  parseAppCodePageName,
  filterSingleRow,
  comparisonJson,
  comparisonArray,
  _,
  cloneDeep: _.cloneDeep, // 深拷贝
  getURLParameters,
  getSysParams,
  getClientHeight,
  getClientWidth,
  sendErrorToWebframe,
  checkRowChange,
  checkListChange,
  toParams,
  tableHandle,
  getType,
  isObject,
  isNull,
  isBoolean,
  isUndefined,
  isNumber,
  isFunction,
  isArray,
  hasClass
}
