class TableHandle {
  constructor() {
    this.moduleName = 'TableHandle'
  }
  /**
   *把index1 和 index2交换
   * @param {*} arr 数据源
   * @param {*} index1
   * @param {*} index2
   */
  swapArr(arr, index1, index2) {
    arr[index1] = arr.splice(index2, 1, arr[index1])[0]
    return arr
  }
  // 向前移动一格
  moveUp(arrayData, index1, order = 'order') {
    if (index1 >= arrayData.length) return arrayData
    let index2 = index1 - 1
    if (index2 < 0) {
      index2 = arrayData.length - 1
    }
    const index1Order = arrayData[index1][order]
    const index2Order = arrayData[index2][order]
    arrayData[index1][order] = index2Order
    arrayData[index2][order] = index1Order
    // 再交换两个元素的位置
    this.swapArr(arrayData, index1, index2)
  }
  // 向下移动一格
  moveDown(arrayData, index1, order = 'order') {
    if (index1 >= arrayData.length) return arrayData
    let index2 = index1 + 1
    if (arrayData.length <= index2) {
      index2 = 0
    }
    const index1Order = arrayData[index1][order]
    const index2Order = arrayData[index2][order]
    arrayData[index1][order] = index2Order
    arrayData[index2][order] = index1Order
    // 再交换两个元素的位置
    this.swapArr(arrayData, index1, index2)
  }
  /**
   * 向下移动逻辑 有两种复杂情况
   * 如果移动行中有最后一项和第一项(0,1,8,9) 这种情况移动顺序是1,0,9,8
   * 1,3,5,6 这种移动顺序是 6,5,3,1
   * @param {*} array
   * @param {*} listIndex
   * @param {*} order
   */
  batchDown(array, listIndex, order = 'order') {
    // 同时包含第一项和最后一项时
    const list = []
    const itemLast = listIndex[listIndex.length - 1]
    const lastIndex = listIndex.length - 1
    listIndex.forEach((item, index) => {
      if (item - itemLast === index - lastIndex) {
        list.push(listIndex[index])
      }
    })
    const max = Math.min(...list)
    const maxIndex = listIndex.findIndex(x => x === max)
    const spliceList = listIndex.splice(maxIndex, lastIndex)
    spliceList.reverse()
    let listIndexReverse = listIndex// listIndex.reverse()
    if (listIndex.includes(0) && listIndex.includes(array.length - 1)) {
      listIndexReverse = listIndex
    } else {
      listIndexReverse = listIndex.reverse()
    }
    listIndexReverse.push(...spliceList)
    listIndexReverse.forEach(index => {
      this.moveDown(array, index, order)
    })
  }
  /**
   * 向上移动 也有两种复杂情况
   * 如果移动行中有最后一项和第一项(0,1,8,9) 这种情况移动顺序是8,9,0,1
   * 1,3,5,6 这种移动顺序是 1,3,5,6
   * @param {*} array
   * @param {*} listIndex
   * @param {*} order
   */
  batchUp(array, listIndex, order = 'order') {
    // 同时包含第一项和最后一项时
    const list = []
    const item0 = listIndex[0]
    listIndex.forEach((item, index) => {
      if (index - item0 === listIndex[index]) {
        list.push(listIndex[index])
      }
    })
    const max = Math.max(...list)
    const maxIndex = listIndex.findIndex(x => x === max)
    const spliceList = listIndex.splice(0, maxIndex + 1)
    if (listIndex.includes(0) && listIndex.includes(array.length - 1)) {
      const index1 = listIndex.shift()
      listIndex.push(index1)
    }
    listIndex.push(...spliceList)
    listIndex.forEach(index => {
      this.moveUp(array, index, order)
    })
  }
  batchTop(array, listIndex, order = 'order') {
    listIndex.forEach((x, index) => {
      let l = x - index
      while (l > 0 && x > 0) {
        this.moveUp(array, x, order)
        x--
        l--
      }
    })
  }
  batchBottom(array, listIndex, order = 'order') {
    listIndex.reverse()
    const arrayLength = array.length
    listIndex.forEach((x, index) => {
      const ducex = arrayLength - x - 1
      let l = ducex - index
      while (l > 0 && x >= 0) {
        this.moveDown(array, x, order)
        x++
        l--
      }
    })
  }
}
// const list = [{ order: 1, name: 1 }, { order: 2, name: 2 }, { order: 3, name: 3 }, { order: 4, name: 4 }, { order: 5, name: 5 }, { order: 6, name: 6 }, { order: 7, name: 7 }]
// const t = new TableHandle()
// // t.batchTop(list, [0, 3, 5, 6])
// // console.log(list)
// t.batchBottom(list, [1, 2, 3])
// console.log(list)

export default new TableHandle()
