import uuidv1 from 'uuid/v1'
export default {
  data() {
    return {
      elId: '',
      outBoxDom: null,
      jsoneditorVisible: false
    }
  },
  created() {
    this.initElid()
  },
  mounted() {
    this.initElid()
    setTimeout(() => {
      this.showEditJsonDialog()
    }, 2000)
  },
  destroyed() {
    if (this.outBoxDom) {
      this.outBoxDom.removeEventListener('mousedown', this.boxEventMouse)
      this.outBoxDom = null
    }
    this.chart = null
  },
  beforeDestroy() {
    clearInterval(this.timer)// 清除定时器
    this.timer = null
    if (this.chart) {
      this.chart.clear()
      this.chart.dispose()
      this.chart = null
    }
  },
  methods: {
    showJsonEditDialog() {
      this.jsoneditorVisible = true
    },
    initElid() {
      if (!this.elId) {
        this.elId = uuidv1() // 获取随机id
      }
    },
    boxEventMouse(event) {
      const that = this
      event.stopPropagation()
      if (event.shiftKey && event.altKey && !event.ctrlKey) {
        that.showJsonEditDialog()
      }
    },
    // 弹出可编辑的弹框
    showEditJsonDialog() {
      this.outBoxDom = document.getElementById(this.elId)
      this.outBoxDom && this.outBoxDom.addEventListener('mousedown', this.boxEventMouse)
    }

  }
}
