String.prototype.format = function(...array) {
  if (array.length == 1 && Array.isArray(array[0])) {
    array = array[0]
  }
  return this.replace(/\{(\d+)\}/g,
    function(m, i) {
      return array[i]
    })
}

String.prototype.before = function(str) {
  var index = this.lastIndexOf(str)
  return this.substring(0, index)
}
String.prototype.after = function(str) {
  var index = this.lastIndexOf(str)
  return this.substring(index + 1, this.length)
}
String.prototype.splitByArray = function(...array) {
  if (array.length == 1 && Array.isArray(array[0])) {
    array = array[0]
  }
  let temp = this
  array.forEach(item => {
    temp = temp.split(item)
  })
  return temp
}
const data = [
  {
    'A__a': '1',
    'A__b': '2',
    'A__c': '1',
    'A__d': '2',
    'b.a': '1',
    'b.b': '2',
    'b.c': '3',
    'name': 'cesi'
  }
]
const colums = [
  { prop: 'age', label: '年龄' },
  { prop: '*', label: '*' },
  { prop: 'A__b', label: '姓名' },
  // { prop: 'A__*', label: '*', topTitle: 'A' },
  // { prop: '*.*', label: '{1}', topTitle: '{0}' }
  { prop: 'name', label: 'namexingmsss' }

]

// console.log('{0}'.format(...[1, 2]))
// console.log('{0}'.format(...[2]))
// console.log('{1}'.format(...[1, 2]))
// console.log('{3}'.format(...[1, 2]))
// let caption = calcCaption('*', 'A__*', 'A__a')
// console.log(caption)
// caption = calcCaption('{1}', '*__*', 'A__b')
// console.log(caption)
// caption = calcCaption('{1}', '*__*', 'A__c')
// console.log(caption)

/**
 *
 * @param {*} caption
 * @param {*} fieldName
 * @param {*} realFieldName
 */

function calcCaption(caption, fieldName, realFieldName) {
  if (!caption) return caption
  if (!caption.includes('*') && !caption.includes('{') && !caption.includes('}')) { return caption }
  if (fieldName === '*' && caption === '*') { return realFieldName }

  const xin = '*'
  // 字段名里面最多几个*，则代表string.Format将*替换成{0}...时的最大数
  const iMaxXinCount = fieldName.split(xin).length - 1 // _sFieldName.Where(x => x == xin).Count();
  let i = 0
  while (i < iMaxXinCount && caption.includes(xin)) {
    caption = caption.before(xin) + '{' + i + '}' + caption.after(xin)
    i++
  }
  const a = fieldName.split(xin).filter(x => x)
  const s = realFieldName.splitByArray(a).filter(x => x)
  // console.log(caption, a, s)
  return caption.format(s)
}

function filterDynamicColumns(allColumns, field, allFixedFields) {
  if (field === '*') {
    // 如果仅有一个*列，则表示所有列都是动态创建
    if (allFixedFields.length === 1) {
      return allColumns
    } else {
      // 排除掉已经存在的列
      // 1.首先排除掉固定列已经存在的
      const staticColumns = allFixedFields.filter(x => !x.prop.includes('*'))
      // 排除掉固定列
      let dynamicColumns = allColumns.filter(field =>
        !staticColumns.find(item => item.prop === field)
      )
      // 匹配*.x列,缩小*匹配的列范围
      var otherStartColumns = allFixedFields.filter(x => x.prop !== '*' && x.prop.includes('*'))
      if (otherStartColumns.length) {
        otherStartColumns.forEach(item => {
          const otherDynamicMatchColumns = filterDynamicColumns(dynamicColumns, item.prop, allFixedFields)
          dynamicColumns = dynamicColumns.filter(x => !otherDynamicMatchColumns.includes(x))
        })
      }
      return dynamicColumns
    }
  } else {
    const sRegexPattern = field.replace('.', '\\.').replace('$', '\\$').replace('^', '\\^').replace(/\*/g, '.*')
    const regex = new RegExp(sRegexPattern, 'i')
    let dynamicColumns = allColumns.filter(x => regex.test(x))
    // 首先排除掉固定列已经存在的
    dynamicColumns = dynamicColumns.filter(item =>
      !allFixedFields.find(field => field.prop === item && field !== '*')
    )
    return dynamicColumns
  }
}
// const allColumns = Object.keys(data[0])
function getTableColums(colums, allColumns) {
  const list = []
  colums.forEach(item => {
    if (item.isHide) return
    if (item.prop && item.prop.includes('*')) {
      const dynamicColumns = filterDynamicColumns(allColumns, item.prop, colums)
      const obj = {
        childs: []
      }
      const { showType, isDisabled, isRequired, fixed, isSort, width, control_name, elInfo, allSourceData } = item
      dynamicColumns.forEach(fieldName => {
        const caption = calcCaption(item.label, item.prop, fieldName)
        const caption1 = calcCaption(item.topTitle, item.prop, fieldName) // 二级标题
        if (caption1) {
          obj.label = caption1
          obj.childs.push({
            label: caption,
            prop: fieldName,
            showOverflowTooltip: true,
            showType,
            isDisabled,
            isRequired,
            fixed,
            isSort,
            width
          })
        } else {
          list.push({
            label: caption,
            prop: fieldName,
            showOverflowTooltip: true,
            showType,
            isDisabled,
            isRequired,
            fixed,
            isSort,
            width,
            control_name,
            elInfo,
            allSourceData
          })
        }
      })
      list.push(obj)
      if (!obj.childs.length) {
        delete obj.childs
      }
    } else if (item.topTitle && !item.topTitle.includes('*')) {
      const t = list.find(x => x.label === item.topTitle)
      if (t) return
      // 筛选出 分组
      const groupList = colums.filter(x => x.topTitle === item.topTitle)
      list.push({
        label: item.topTitle,
        childs: groupList
      })
    } else {
      list.push(item)
    }
  })
  return list.filter(item => Object.keys(item).length)
}
// const list = getTableColums(colums, allColumns)
// console.log(list)
export default {
  getTableColums
}
