// 折线图和柱状图原始配置和数据
const initLineBar = {
  config: {
    isTransverse: false,
    'title': {
      'text': '标题（模拟数据）',
      'left': 'center',
      'textStyle': {
        'color': '#a2a3e3',
        'fontSize': 20
      }
    },
    'tooltip': {
      'trigger': 'axis'
    },
    'grid': {
      'left': '10',
      'right': '20',
      'bottom': '20',
      'top': '40',
      'containLabel': true
    },
    'xAxis': {
      'name': '',
      'nameLocation': 'end',
      'axisLine': {
        'show': true,
        'lineStyle': {
          'color': '#a2a3e3'
        }
      },
      'data': [
        'DKN1',
        'DKN2',
        'DKN3',
        'DKN4',
        'DKN5'
      ]
    },
    'yAxis': [
      {
        'show': true,
        'type': 'value',
        'name': '%',
        'nameLocation': 'end',
        'min': null,
        'max': null,
        'splitNumber': 5,
        'axisLine': {
          'show': true,
          'lineStyle': {
            'color': '#a2a3e3'
          }
        },
        'axisTick': {
          'show': true
        },
        'axisLabel': {
          'show': true
        },
        'splitLine': {
          'lineStyle': {
            'color': '#282953'
          }
        }
      }
    ],
    'legend': {
      'show': false,
      'orient': 'horizontal',
      'bottom': '0',
      'textStyle': {
        'fontSize': 12
      },
      'data': [
        '计划数',
        '完成数'
      ]
    },
    'series': [
      {
        'name': '计划数',
        'type': 'bar',
        'yAxisIndex': 0,
        'barWidth': '12',
        'stack': '这个值相同的话 就会叠加',
        'data': [],
        'itemStyle': {
          'color': {
            'x': 0,
            'y': 0,
            'x2': 0,
            'y2': 1,
            'type': 'linear',
            'global': false,
            'colorStops': [
              {
                'offset': 0,
                'color': '#436EEE'
              },
              {
                'offset': 1,
                'color': '#8B2252'
              }
            ]
          },
          'barBorderRadius': [
            10,
            10,
            0,
            0
          ],
          'hsColor': [
            '#4fcee4',
            '#ab5ee2'
          ]
        },
        'label': {
          'show': true,
          'position': 'top',
          'color': '#8888b0',
          'fontSize': 12
        },
        'xData': []
      },
      {
        'name': '完成数',
        'type': 'bar',
        'yAxisIndex': 0,
        'barWidth': '12',
        'data': [],
        'itemStyle': {
          'color': {
            'x': 0,
            'y': 0,
            'x2': 0,
            'y2': 1,
            'type': 'linear',
            'global': false,
            'colorStops': [
              {
                'offset': 0,
                'color': '#436EEE'
              },
              {
                'offset': 1,
                'color': '#8B2252'
              }
            ]
          },
          'barBorderRadius': [
            10,
            10,
            0,
            0
          ],
          'hsColor': [
            '#4fcee4',
            '#ab5ee2'
          ]
        },
        'label': {
          'show': true,
          'position': 'top',
          'color': '#8888b0',
          'fontSize': 12
        },
        'xData': []
      },
      {
        'name': 'G04',
        'type': 'bar',
        'yAxisIndex': 0,
        'barWidth': '12',
        'stack': '这个值相同的话 就会叠加',
        'data': [],
        'itemStyle': {
          'color': {
            'x': 0,
            'y': 0,
            'x2': 0,
            'y2': 1,
            'type': 'linear',
            'global': false,
            'colorStops': [
              {
                'offset': 0,
                'color': '#436EEE'
              },
              {
                'offset': 1,
                'color': '#8B2252'
              }
            ]
          },
          'barBorderRadius': [
            10,
            10,
            0,
            0
          ],
          'hsColor': [
            '#4fcee4',
            '#ab5ee2'
          ]
        },
        'label': {
          'show': true,
          'position': 'top',
          'color': '#8888b0',
          'fontSize': 12
        },
        'xData': []
      }
    ]
  },
  data: [
    {
      'sSeries': '计划数',
      'sName': '五车间',
      'dValue': '15',
      'sShowValue': '15'
    },
    {
      'sSeries': '计划数',
      'sName': '六车间',
      'dValue': '28',
      'sShowValue': '28'
    },
    {
      'sSeries': '计划数',
      'sName': '七车间',
      'dValue': '31',
      'sShowValue': '31'
    },
    {
      'sSeries': '计划数',
      'sName': '八车间',
      'dValue': '45',
      'sShowValue': '45'
    },
    {
      'sSeries': '计划数',
      'sName': '九车间',
      'dValue': '57',
      'sShowValue': '57'
    },
    {
      'sSeries': '计划数',
      'sName': '十一车间',
      'dValue': '98',
      'sShowValue': '98'
    },
    {
      'sSeries': '完成数',
      'sName': '五车间',
      'dValue': '45',
      'sShowValue': '45'
    },
    {
      'sSeries': '完成数',
      'sName': '六车间',
      'dValue': '48',
      'sShowValue': '48'
    },
    {
      'sSeries': '完成数',
      'sName': '七车间',
      'dValue': '41',
      'sShowValue': '41'
    },
    {
      'sSeries': '完成数',
      'sName': '八车间',
      'dValue': '60',
      'sShowValue': '60'
    },
    {
      'sSeries': '完成数',
      'sName': '九车间',
      'dValue': '39',
      'sShowValue': '39'
    },
    {
      'sSeries': '完成数',
      'sName': '十一车间',
      'dValue': '39',
      'sShowValue': '39'
    }
  ]
}
// 饼图
const initPie = {
  config: {
    tooltip: {
      trigger: 'item',
      formatter: '{a} <br/>{b}: {c} ({d}%)'
    },
    legend: {
      orient: 'vertical',
      x: 'left',
      data: ['测试1', '测试2']
    },
    color: ['#F5D423', '#47FE75', '#47FDFE', '#325AF0', '#8266F5', '#C566F5', '#F566B5', '#F56666', '#F58566', '#F5A623'],
    calculable: true,
    graphic: [
      { // 设置饼状图内部文字
        type: 'text',
        left: 'center', // 设置偏移量
        top: 180,
        z: 2
      }
    ],
    series: [{
      name: '访问来源',
      type: 'pie',
      radius: ['45%', '70%'],
      itemStyle: {
        normal: {
          label: {
            show: true,
            position: 'outer',
            formatter: params => {
              return params.data.name
            }
          },
          labelLine: {
            show: false,
            length: 2
          }
        }
      },
      data: []
    }]
  },
  data: [
    {
      name: '测试1',
      sName: '上衣',
      dValue: 30,
      msg: '测试1',
      sSeries: '访问来源',
      sLegendData: ''
    },
    {
      name: '测试2',
      sName: '裤子2',
      dValue: 25,
      msg: '测试2',
      sSeries: '访问来源',
      sLegendData: ''
    }]
}
// 雷达图
const initRadar = {
  config: {
    grid: {
      left: '20',
      right: '10',
      bottom: '2',
      top: '20',
      containLabel: true
    },
    title: {
      text: '面料（米）',
      bottom: '10px',
      left: 'center',
      textStyle: {
        fontSize: 20,
        color: '#A48463',
        fontFamily: 'myFont',
        fontWeight: 400
      }
    },
    tooltip: {
      trigger: 'axis'
    },
    radar: [{
      triggerEvent: true,
      shape: 'circle',
      center: ['50%', '50%'],
      radius: '55%',
      splitNumber: 4,
      nameGap: 35,
      name: {
        textStyle: {
          fontFamily: 'myFont',
          color: '#A48463',
          fontSize: '20'
        }
      },
      label: { // 坐标轴文本标签，详见axis.axisLabel
        show: true,
        textStyle: {
          color: '#FFC774' // 坐标轴刻度文字的样式
        }
      },
      splitArea: {
        show: false,
        areaStyle: {
          color: 'rgba(167,134,99,0.9)' // 图表背景网格的颜色
        }
      },
      splitLine: {
        show: true,
        lineStyle: {
          width: 1,
          color: '#A48463' // 图表背景网格线的颜色
        }
      },
      indicator: [{
        text: '来料',
        max: 10000
      },
      {
        text: '裁剪入库',
        max: 10000
      },
      {
        text: '裁剪下线',
        max: 10000
      },
      {
        text: '已裁',
        max: 10000
      },
      {
        text: '已领',
        max: 10000
      }
      ]
    }],
    calculable: true,
    series: [{
      name: '雷达图',
      type: 'radar',
      data: [],
      itemStyle: {
        normal: {
          lineStyle: {
            width: 1,
            color: '#FFC774' // 图表中各个图区域的边框线颜色
          },
          areaStyle: {
            type: 'default',
            color: '#6495ED',
            opacity: 0.4
          }
        }
      },
      label: {
        normal: {
          show: true,
          position: 'outer',
          textStyle: {
            color: '#6495ED',
            fontSize: 18
          }
        }
      }
    }]
  },
  data: [{
    sSeries: '雷达图',
    dValue: [10000, 4000, 3000, 3100, 4000]
  }]
}
const hsStatusGroup = {
  config: {
    'ref': {
      const_id: '0',
      table_name: '',
      columns: ''
    },
    dyncQueryParms: {},
    disabled: false,
    size: 'mini',
    value: '',
    label: '',
    is_computed: false
  },
  data: [
    {
      value: '选项1',
      label: '黄金糕'
    }, {
      value: '选项2',
      label: '双皮奶'
    }
  ]
}
const hsSelectPlus = {
  config: {
    autoAddEmpty: false,
    refreshBtn: false,
    'ref': {
      const_id: '0',
      table_name: '',
      columns: '',
      remote_condition: '',
      displayfield: '',
      writebackfield: []
    },
    dyncQueryParms: {},
    multiple: false,
    disabled: false,
    size: 'mini',
    clearable: true,
    title: '',
    placeholder: '',
    value: '',
    label: '',
    is_computed: false
  },
  data: [
    {
      value: '选项1',
      label: '黄金糕'
    }, {
      value: '选项2',
      label: '双皮奶'
    }
  ]
}
const hsTagsTable = {
  config: {
    valueField: '',
    displayField: '',
    submitClick: '',
    refSqlName: '',
    disabled: false,
    closable: true,
    size: 'mini',
    isShowAddIcon: true,
    addMode: false,
    showDialogAdd: false,
    isShowLinkPage: false,
    linkPage: {
      dyncQueryParms: {}, writebackfield: {}, url: ''
    }
  }
}
const hsTagsSelect = {
  config: {
    autoAddEmpty: false,
    refreshBtn: false,
    maxHeight: '100%',
    'ref': {
      const_id: '0',
      table_name: '',
      columns: '',
      writebackfield: []
    },
    dyncQueryParms: {},
    multiple: true,
    disabled: false,
    size: 'mini',
    clearable: true,
    title: '',
    placeholder: '',
    value: '',
    label: '',
    is_computed: false
  },
  data: [
    {
      value: '选项1',
      label: '黄金糕'
    }, {
      value: '选项2',
      label: '双皮奶'
    }
  ]
}
const hsTableImport = {
  data: {
    'paging': {
      'page': 1,
      'per_page': 10,
      'total': 78
    },
    'total': [
      {
        '任务数': '1000',
        '完成数': 6600
      }
    ],
    'table': [
      {
        'name': '海宁安正1',
        'age': 18,
        '计划数/完成数__2019-08-14': '0/0',
        '计划数/完成数__2019-08-15': '60/0'
      },
      {
        'name': '海宁安正2',
        'age': 18,
        '计划数/完成数__2019-08-14': '0/0',
        '计划数/完成数__2019-08-15': '60/0'
      }
    ]
  },
  config: {
    bindEntity: '',
    'isAdaptive': true,
    'showHandle': false,
    disaledDblClick: false,
    expandChild: false,
    handleWidth: 80,
    selection: false,
    showIndex: true,
    isShowTools: false,
    toolDirection: 'column',
    'toolItems': [
      {
        label: '表格列设置',
        isShow: true,
        click: '$tableColumnSet',
        disabled: false
      }
    ],
    'columnsConfig': [
      {
        'label': '测试列1',
        'prop': 'name',
        'showOverflowTooltip': true
      },
      {
        'label': '测试列2',
        'prop': 'age',
        'showOverflowTooltip': true
      }
    ]
  }
}
// 表格模拟数据
const hsTableImportList = {
  data: {
    'paging': {
      'page': 1,
      'per_page': 10,
      'total': 78
    },
    'total': [
      {
        '客户': '1000',
        '款式': 6600
      }
    ],
    'table': [
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣'

      },
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣'

      }
    ]
  },
  config: {
    bindEntity: '',
    'isAdaptive': true,
    'showHandle': false,
    disaledDblClick: false,
    expandChild: false,
    handleWidth: 80,
    selection: true,
    showIndex: true,
    isShowTools: true,
    toolDirection: 'column',
    'toolItems': [
      {
        label: '表格列设置',
        isShow: true,
        click: '$tableColumnSet',
        disabled: false
      }
    ],
    'columnsConfig': [
      {
        'label': '测试列1',
        'prop': '客户',
        'showOverflowTooltip': true
      },
      {
        'label': '测试列2',
        'prop': '客户',
        'showOverflowTooltip': true
      }
    ]
  }
}
const hsTableSimple = {
  data: [],
  config: {
    bindEntity: '',
    'isAdaptive': true,
    'showHandle': false,
    disaledDblClick: false,
    expandChild: false,
    handleWidth: 80,
    selection: false,
    showIndex: true,
    isShowTools: false,
    toolDirection: 'column',
    exportExcelName: '',
    handleColumns: [
    ],
    'toolItems': [
    ],
    'columnsConfig': [
      {
        'label': 'A',
        'prop': 'A',
        'showOverflowTooltip': true
      },
      {
        'label': 'B',
        'prop': 'B',
        'showOverflowTooltip': true
      }
    ]
  }
}
// 表格模拟数据
const hsTableList = {
  data: {
    'paging': {
      'page': 1,
      'per_page': 10,
      'total': 78
    },
    'total': [
      {
        '客户': '1000',
        '款式': 6600
      }
    ],
    'table': [
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣'

      },
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣'

      }
    ]
  },
  config: {
    bindEntity: '',
    'isAdaptive': true,
    'showHandle': false,
    disaledDblClick: false,
    expandChild: false,
    handleWidth: 80,
    selection: false,
    showIndex: true,
    isShowTools: true,
    toolDirection: 'column',
    exportExcelName: '导出表的名字',
    handleColumns: [
      {
        label: '',
        icon: 'el-icon-edit',
        isShow: true,
        disabled: false,
        type: 'text',
        click: '$editRow'
      }
    ],
    'toolItems': [
      {
        label: '导出本页',
        isShow: true,
        click: '$exportCurrPageData',
        disabled: false
      }, {
        label: '导出全部',
        isShow: true,
        click: '$exportAllPageData',
        disabled: false
      }, {
        label: '表格列设置',
        isShow: true,
        click: '$tableColumnSet',
        disabled: false
      }
    ],
    'columnsConfig': [
      {
        'label': '测试列1',
        'prop': '客户',
        'showOverflowTooltip': true
      },
      {
        'label': '测试列2',
        'prop': '客户',
        'showOverflowTooltip': true
      }
    ]
  }
}
const hsTableDtl = {
  data: [],
  config: {
    bindEntity: '',
    'isAdaptive': true,
    'showHandle': false,
    disaledDblClick: false,
    expandChild: false,
    handleWidth: 80,
    selection: false,
    showIndex: true,
    isShowTools: true,
    toolDirection: 'column',
    exportExcelName: '导出表的名字',
    handleColumns: [
      {
        'label': '',
        'icon': 'el-icon-plus',
        'isShow': true,
        disabled: false,
        'type': 'text',
        'click': '$addRow'
      },
      {
        'label': '',
        'icon': 'el-icon-delete',
        'isShow': true,
        disabled: false,
        'type': 'text',
        'click': '$deleteRow'
      }
    ],
    'toolItems': [
      {
        label: '导出本页',
        isShow: true,
        click: '$exportCurrPageData',
        disabled: false
      }, {
        label: '导出全部',
        isShow: true,
        click: '$exportAllPageData',
        disabled: false
      }, {
        label: '表格列设置',
        isShow: true,
        click: '$tableColumnSet',
        disabled: false
      },
      {
        label: '新增行',
        isShow: true,
        click: '$addRow',
        disabled: false
      }, {
        label: '删除行',
        isShow: true,
        click: '$deleteRow',
        disabled: false
      }
    ],
    'columnsConfig': [
      {
        'label': '测试列1',
        'prop': '客户',
        'showOverflowTooltip': true
      },
      {
        'label': '测试列2',
        'prop': '客户',
        'showOverflowTooltip': true
      }
    ]
  }
}
// 表格模拟数据
const hsTable = {
  data: {
    'paging': {
      'page': 1,
      'per_page': 10,
      'total': 78
    },
    'total': [
      {
        '任务数': '1000',
        '完成数': 6600
      }
    ],
    'table': [
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣',
        '订单号': '3204HT190771',
        '批次': '3204HT',
        '颜色': '缺省',
        '尺码': '缺省',
        '班组': '二组',
        '任务数': 230,
        '完成数': 660,
        '计划数/完成数__2019-08-14': '0/0',
        '计划数/完成数__2019-08-15': '60/0',
        '计划数/完成数__2019-08-16': '0/98',
        '计划数/完成数__2019-08-17': '60/98',
        '计划数/完成数__2019-08-18': '60/50',
        '计划数/完成数__2019-08-19': '0/60'
      },
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣',
        '订单号': '3204HT190771',
        '批次': '3204HT',
        '颜色': '缺省',
        '尺码': '缺省',
        '班组': '二组',
        '任务数': 230,
        '完成数': 660,
        '计划数/完成数__2019-08-14': '0/0',
        '计划数/完成数__2019-08-15': '60/0',
        '计划数/完成数__2019-08-16': '0/98',
        '计划数/完成数__2019-08-17': '60/98',
        '计划数/完成数__2019-08-18': '60/50',
        '计划数/完成数__2019-08-19': '0/60'
      }
    ]
  },
  config: {
    'isAdaptive': true,
    'showHandle': false,
    disaledDblClick: false,
    expandChild: false,
    handleWidth: 80,
    selection: false,
    showIndex: true,
    isShowTools: true,
    toolDirection: 'column',
    exportExcelName: '导出表的名字',
    toolItems: [{
      label: '导出本页',
      isShow: true,
      click: '$exportCurrPageData',
      disabled: false
    }, {
      label: '导出全部',
      isShow: true,
      click: '$exportAllPageData',
      disabled: false
    }, {
      label: '表格列设置',
      isShow: true,
      click: '$tableColumnSet',
      disabled: false
    }],
    'columnsConfig': [
      {
        'label': '测试列1',
        'prop': '客户',
        'showOverflowTooltip': true
      },
      {
        'label': '测试列2',
        'prop': '客户',
        'showOverflowTooltip': true
      }
    ]
  }
}
const hsTableInDyncDialog = {
  data: {
    'paging': {
      'page': 1,
      'per_page': 10,
      'total': 78
    },
    'total': [
      {
        '任务数': '1000',
        '完成数': 6600
      }
    ],
    'table': [
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣',
        '订单号': '3204HT190771',
        '批次': '3204HT',
        '颜色': '缺省',
        '尺码': '缺省',
        '班组': '二组',
        '任务数': 230,
        '完成数': 660,
        '计划数/完成数__2019-08-14': '0/0',
        '计划数/完成数__2019-08-15': '60/0',
        '计划数/完成数__2019-08-16': '0/98',
        '计划数/完成数__2019-08-17': '60/98',
        '计划数/完成数__2019-08-18': '60/50',
        '计划数/完成数__2019-08-19': '0/60'
      },
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣',
        '订单号': '3204HT190771',
        '批次': '3204HT',
        '颜色': '缺省',
        '尺码': '缺省',
        '班组': '二组',
        '任务数': 230,
        '完成数': 660,
        '计划数/完成数__2019-08-14': '0/0',
        '计划数/完成数__2019-08-15': '60/0',
        '计划数/完成数__2019-08-16': '0/98',
        '计划数/完成数__2019-08-17': '60/98',
        '计划数/完成数__2019-08-18': '60/50',
        '计划数/完成数__2019-08-19': '0/60'
      }
    ]
  },
  config: {
    bindEntity: '',
    'isAdaptive': true,
    'showHandle': false,
    disaledDblClick: false,
    expandChild: false,
    handleWidth: 80,
    selection: false,
    showIndex: true,
    isShowTools: true,
    toolDirection: 'column',
    toolItems: [{
      label: '表格列设置',
      isShow: true,
      click: '$tableColumnSet',
      disabled: false
    }, {
      label: '新增行',
      isShow: true,
      click: '$addRow',
      disabled: false
    }],
    handleColumns: [
      {
        'label': '',
        'icon': 'el-icon-plus',
        'isShow': true,
        disabled: false,
        'type': 'text',
        'click': '$addRow'
      },
      {
        'label': '',
        'icon': 'el-icon-delete',
        'isShow': true,
        disabled: false,
        'type': 'text',
        'click': '$deleteRow'
      }
    ],
    'columnsConfig': [
      {
        'label': '测试列1',
        'prop': '客户',
        'showOverflowTooltip': true
      },
      {
        'label': '测试列2',
        'prop': '客户',
        'showOverflowTooltip': true
      }
    ]
  }
}
const hsAction = {
  data: [],
  config: {
    text: '按钮',
    'buttonProps': {
      'size': 'mini'
    }
  }
}
const hsInput = {
  data: [],
  config: {
    title: '',
    placeholder: '',
    size: 'mini',
    clearable: true,
    disabled: false,
    innerValidateRegex: '',
    validateRegex: '',
    validateAction: '',
    maxlength: 100000,
    minlength: 0,
    type: 'text',
    'show-word-limit': false,
    'show-password': false,
    rows: 2,
    autosize: false,
    readonly: false
  }
}
const hsInputNumber = {
  data: [],
  config: {
    title: '',
    placeholder: '',
    size: 'mini',
    disabled: false
  }
}
const hsDivider = {
  data: [],
  config: {
    direction: 'horizontal',
    contentPosition: 'left'
  }
}
const hsDatePicker = {
  config: {
    'title': '',
    'type': 'daterange',
    'valueFormat': 'yyyy-MM-dd',
    'rangeSeparator': '至',
    'startPlaceholder': '开始日期',
    'endPlaceholder': '结束日期'
  },
  data: []
}
const hsTags = {
  config: {
    'size': 'medium'
  },
  data: [
    {
      'title': '数学',
      'type': 'primary'
    },
    {
      'title': '语文',
      'type': 'primary'
    },
    {
      'title': '美术',
      'type': 'primary'
    },
    {
      'title': '英语',
      'type': 'primary'
    }
  ]
}
const hsCheckbox = {
  config: {
    title: ''
  },
  data: []
}
const hsTree = {
  config: {
    label: '',
    parentId: '',
    nodeKey: ''
  },
  data: []
}
const hsDyncFormComponent = {
  height: '130px',
  config: {
    'formColumn': [
      {
        'type': 'input',
        'label': '标题1',
        'prop': 'title1',
        labelWidth: 120
      },
      {
        'type': 'input',
        'label': '标题2',
        'prop': 'title2',
        labelWidth: 120,
        'isMoreSearch': true
      }
    ]
  },
  data: []
}
const hsPageConfigSingle = {
  config: {
    'restful_appcode': '', // appcode
    'isInitMenuParam': false, // 是否初始化menuParam
    pageMode: true,
    'version': '2.0',
    ui: {
      main: {
        isTabsForm: false,
        tableHeightAdaption: false
      },
      index: {
        showQueryComponent: false
      }
    },
    'entity': { // 实体节点
      'index': {
        'isInitNewDefault': false, // 初始化新增默认值
        'initNewDefaultOnce': true, // 是否只调用一次
        'width': '220px',
        'group': 'Tree',
        'isShowTreeHeader': false, // 是否显示树的头部
        'isHideButtonTools': false, // 是否隐藏按钮组(True:右上角按钮组隐藏)
        'table_name': '', // 表名
        'primaryKey': 'id', // 主键
        'saveIncludeFields': '', // 保存时一定会传入到后台的字段,无论这些字段是否有修改,多字段时逗号串联
        'saveExcludeFields': '', // 保存时不传给后端的字段,无论这些字段是否有修改,多字段时逗号串联
        'dyncQueryParms': {}, // 动态查询参数
        'queryOneDyncQueryParms': {},
        'indexTitle': '', // 标题
        'saveDyncParms': {},
        'check': {} // 修改或者新增时 数据校验
      },
      'main': {
        'refreshIndex': false, // 单行修改后 是否刷新左侧
        'isInitNewDefault': false, // 初始化新增默认值
        'initNewDefaultOnce': true, // 是否只调用一次
        'check': {}, // 修改时数据校验
        'enableBillFlow': true, // 是否开启审核流程
        'queryDefault': {}, // 查询默认值
        'isHideQueryZone': false, // 是否隐藏搜索区域
        'group': '', // 分组
        'table_name': '', // 表名
        'primaryKey': 'id', // 主键
        'saveIncludeFields': '', // 保存时一定会传入到后台的字段,无论这些字段是否有修改,多字段时逗号串联
        'saveExcludeFields': '', // 保存时不传给后端的字段,无论这些字段是否有修改,多字段时逗号串联
        'dyncQueryParms': { // 动态查询参数
        },
        'saveDyncParms': {},
        'queryOneDyncQueryParms': {},
        'importInfo': [// 导入、excel、数据导入
          {
            'label': '单表数据导入', // 按钮名称
            'url': '/DyncUI/Import/{appCode}/{pageCode}', // 单表导入模版
            'import_name': '', // 导入名
            'parms': {}, // 作为导入页面的问号参数
            'click': '$dataImportItem',
            'saveParms': {}// 保存时作为问好参数传给后端
          },
          {
            'label': '主从数据导入',
            'url': '/DyncUI/ImportHdrDtl/{appCode}/{pageCode}', // 主从导入模版
            'import_name': '',
            'parms': {},
            'click': '$dataImportItem',
            'saveParms': {}
          },
          {
            'label': 'Excel导入', // excel 导入
            'click': '$excelImportItem',
            'saveParms': {}
          }
        ]
      }
    },
    'new_default': {// 新增默认值
      'main': {
        'columns': {
        }
      },
      'index': {
        'columns': {
        }
      }
    }
  },
  data: []
}
const hsPageConfigIndexHdrDtl = {
  config: {
    'restful_appcode': '',
    'isInitMenuParam': false, // 是否初始化menuParam
    'pageMode': true,
    'version': '2.0',
    'ui': {
      main: {
        tableHeightAdaption: false
      },
      index: {
        isShow: true,
        showQueryComponent: false,
        width: '300px',
        'displayControl': 'tree',
        'title': '测试',
        'showHeader': false,
        'isPaging': false,
        'titleStyle': {
          'font-size': '14px',
          'color': 'red'
        }
      }
    },
    'entity': {
      'index': {
        'isInitNewDefault': false, // 初始化新增默认值
        'initNewDefaultOnce': true, // 是否只调用一次
        'width': '220px',
        'group': 'Tree',
        'table_name': '', // 表名
        'primaryKey': 'id', // 主键
        'saveIncludeFields': '', // 保存时一定会传入到后台的字段,无论这些字段是否有修改,多字段时逗号串联
        'saveExcludeFields': '', // 保存时不传给后端的字段,无论这些字段是否有修改,多字段时逗号串联
        'dyncQueryParms': {}, // 动态查询参数
        'queryOneDyncQueryParms': {},
        'check': {} // 修改或者新增时 数据校验
      },
      'main': {
        'isInitNewDefault': false, // 初始化新增默认值
        'initNewDefaultOnce': true, // 是否只调用一次
        'bill_type': '',
        'enableBillFlow': true,
        'table_name': '',
        'primaryKey': 'id',
        'saveIncludeFields': '', // 保存时一定会传入到后台的字段,无论这些字段是否有修改,多字段时逗号串联
        'saveExcludeFields': '', // 保存时不传给后端的字段,无论这些字段是否有修改,多字段时逗号串联
        'dyncQueryParms': {},
        'check': {}
      },
      'dtl': {
        'isInitNewDefault': false, // 初始化新增默认值
        'initNewDefaultOnce': true, // 是否只调用一次
        'check': {},
        'showQueryComponent': false,
        'addNewCount': 0,
        'table_name': '',
        'primaryKey': 'id',
        'saveIncludeFields': '', // 保存时一定会传入到后台的字段,无论这些字段是否有修改,多字段时逗号串联
        'saveExcludeFields': '', // 保存时不传给后端的字段,无论这些字段是否有修改,多字段时逗号串联
        'dyncQueryParms': {},
        'queryOneDyncQueryParms': {},
        'importInfo': [
        ]
      }
    },
    'new_default': {
      'main': {
        'columns': {}
      },
      'dtl': {
        'columns': {}
      }
    }
  },
  data: []
}
const hsPageConfigSingleForm = {
  config: {
    restful_appcode: '',
    'isInitMenuParam': false, // 是否初始化menuParam
    'pageMode': true,
    'version': '2.0',
    callSave: true,
    callQueryOne: true,
    'ui': {
      main: {
        isTabsForm: false
      }
    },
    'entity': {
      'main': {
        'isInitNewDefault': false, // 初始化新增默认值
        'initNewDefaultOnce': true, // 是否只调用一次
        'bill_type': '',
        'enableBillFlow': true,
        'table_name': '',
        'primaryKey': 'id',
        'saveIncludeFields': '', // 保存时一定会传入到后台的字段,无论这些字段是否有修改,多字段时逗号串联
        'saveExcludeFields': '', // 保存时不传给后端的字段,无论这些字段是否有修改,多字段时逗号串联
        'dyncQueryParms': {},
        'check': {}, // 校验字段对象
        'saveDyncParms': {// 保存时的动态参数

        }
      }
    },
    'new_default': {
      'main': {
        'columns': {}
      }
    }
  },
  data: []
}
const hsPageConfigHdrDtl = {
  config: {
    restful_appcode: '',
    'isInitMenuParam': false, // 是否初始化menuParam
    'pageMode': true,
    'version': '2.0',
    ui: {
      main: {
        isTabsForm: false
      },
      dtl: {
        isShow: true,
        showQueryComponent: false,
        tableHeightAdaption: false
      }
    },
    'entity': {
      'childs': [
      ],
      'main': {
        'isInitNewDefault': false, // 初始化新增默认值
        'initNewDefaultOnce': true, // 是否只调用一次
        'bill_type': '',
        'enableBillFlow': true,
        'table_name': '',
        'primaryKey': 'id',
        'saveIncludeFields': '', // 保存时一定会传入到后台的字段,无论这些字段是否有修改,多字段时逗号串联
        'saveExcludeFields': '', // 保存时不传给后端的字段,无论这些字段是否有修改,多字段时逗号串联
        'dyncQueryParms': {},
        'check': {}, // 校验字段对象
        'saveDyncParms': {// 保存时的动态参数

        }
      },
      'dtl': {
        'isInitNewDefault': false, // 初始化新增默认值
        'initNewDefaultOnce': true, // 是否只调用一次
        'check': {},
        'showQueryComponent': false,
        'addNewCount': 0,
        'table_name': '',
        'primaryKey': 'id',
        'saveIncludeFields': '', // 保存时一定会传入到后台的字段,无论这些字段是否有修改,多字段时逗号串联
        'saveExcludeFields': '', // 保存时不传给后端的字段,无论这些字段是否有修改,多字段时逗号串联
        'dyncQueryParms': {},
        'queryOneDyncQueryParms': {},
        'importInfo': [
        ]
      }
    },
    'new_default': {
      'main': {
        'columns': {}
      },
      'dtl': {
        'columns': {}
      }
    }
  },
  data: []
}
const hsPageConfigBill = {
  config: {
    restful_appcode: '',
    'isInitMenuParam': false, // 是否初始化menuParam
    'pageMode': true,
    'version': '2.0',
    'ui': {
      main: {
        tableHeightAdaption: false
      },
      index: {
        showQueryComponent: false
      }
    },
    'entity': {
      'index': {
        'isInitNewDefault': false, // 初始化新增默认值
        'initNewDefaultOnce': true, // 是否只调用一次
        'width': '220px',
        'group': 'Tree',
        'isShowTreeHeader': false, // 是否显示树的头部
        'isHideButtonTools': false, // 是否隐藏按钮组(True:右上角按钮组隐藏)
        'table_name': '',
        'primaryKey': 'id',
        'saveIncludeFields': '', // 保存时一定会传入到后台的字段,无论这些字段是否有修改,多字段时逗号串联
        'saveExcludeFields': '', // 保存时不传给后端的字段,无论这些字段是否有修改,多字段时逗号串联
        'dyncQueryParms': {},
        'queryOneDyncQueryParms': {},
        'indexTitle': '',
        'check': {}
      },
      'main': {
        'isInitNewDefault': false, // 初始化新增默认值
        'initNewDefaultOnce': true, // 是否只调用一次
        'queryDefault': {},
        'isHideQueryZone': false,
        'group': '',
        'table_name': '',
        'primaryKey': 'id',
        'saveIncludeFields': '', // 保存时一定会传入到后台的字段,无论这些字段是否有修改,多字段时逗号串联
        'saveExcludeFields': '', // 保存时不传给后端的字段,无论这些字段是否有修改,多字段时逗号串联
        'detailPath': '',
        detailRunAppCode: '',
        'detailName': '',
        'detailDyncQueryParms': {},
        'dyncQueryParms': {
        },
        'queryOneDyncQueryParms': {},
        'importInfo': [
        ],
        'check': {}
      }
    },
    'new_default': {
      'main': {
        'columns': {
        }
      }
    }
  },
  data: []
}
const hsPageConfigImport = {
  config: {
    'restful_appcode': '',
    'pageMode': true,
    'version': '2.0',
    'ui': {
      main: {
        tableHeightAdaption: false
      }
    },
    'entity': {
      'main': {
        'queryDefault': {}, // 默认查询参数
        'isHideQueryZone': false, // 是否隐藏查询区域
        'group': '', // 分组
        'table_name': '', // 表名
        'primaryKey': 'id', // 主键id
        'dyncQueryParms': { // 动态查询参数
        }
      }
    }
  },
  data: []
}
const hsPageConfigHdrDtlImport = {
  config: {
    restful_appcode: '',
    pageMode: true,
    'version': '2.0',
    'ui': {
      main: {
        tableHeightAdaption: false
      },
      dtl: {

      }
    },
    'entity': {
      'main': {
        'isHideQueryZone': false,
        'group': '',
        'table_name': '',
        'primaryKey': 'id',
        'dyncQueryParms': {
        }
      },
      'dtl': {
        'group': '',
        'table_name': '',
        'primaryKey': 'id',
        'dyncQueryParms': {
        }
      }
    }
  },
  data: []
}
const hsPageConfig = {
  config: {
    restful_appcode: '',
    'entity': {
      'index': {
        'width': '220px',
        'group': 'Tree',
        'defaultProps': {
          'label': 'department_name'
        },
        'isTree': true,
        'table_name': '',
        'primaryKey': 'id',
        'dyncQueryParms': {},
        'indexTitle': '部门'
      },
      'main': {
        'isHideQueryZone': false,
        'group': '',
        'table_name': '',
        'primaryKey': 'id',
        'detailPath': '/DyncUI/HdrDtl/PBOrg/im_arrive_dtl',
        'detailName': '到货单详情',
        'detailDyncQueryParms': {},
        'dyncQueryParms': {
        }
      },
      'dtl': {
        'group': '',
        'table_name': '',
        'primaryKey': 'id',
        'dyncQueryParms': {
        }
      }
    },
    'new_default': {
      'main': {
        'columns': {
        }
      }
    }
  },
  data: []
}
const hsButtonToolsSingleMain = {
  config: {
    'buttonList': [
      {
        'label': '',
        'icon': 'el-icon-search',
        'click': '$search',
        'isMore': false,
        'isShow': true,
        disabled: false
      },
      {
        'label': '',
        'icon': 'el-icon-plus',
        'click': '$add',
        'isMore': false,
        'isShow': true,
        disabled: false
      },
      {
        'label': '',
        'icon': 'el-icon-delete',
        'click': '$delete',
        'isMore': false,
        'isShow': true,
        disabled: false
      },
      {
        'label': '配置',
        'icon': '',
        'click': '$setPageConfig',
        'isShow': true,
        'isMore': true,
        disabled: false
      },
      {
        'label': 'Action',
        'icon': '',
        'click': '$setAction',
        'isShow': true,
        'isMore': true,
        disabled: false
      }
    ]
  },
  data: []
}
const hsButtonToolsBillIndex = {
  config: {
    'buttonList': [
      {
        'label': '',
        'icon': 'el-icon-refresh',
        'click': '$refresh',
        'isMore': false,
        'isShow': true,
        disabled: false
      },
      {
        'label': '',
        'icon': 'el-icon-plus',
        'click': '$add',
        'isMore': false,
        'isShow': true,
        disabled: false
      },
      {
        'label': '',
        'icon': 'el-icon-edit',
        'click': '$edit',
        'isMore': false,
        'isShow': true,
        disabled: false
      },
      {
        'label': '',
        'icon': 'el-icon-delete',
        'click': '$delete',
        'isMore': false,
        'isShow': true,
        disabled: false
      }
    ]
  },
  data: []
}
const hsButtonToolsBillMain = {
  config: {
    'buttonList': [
      {
        'label': '',
        'icon': 'el-icon-search',
        'click': '$search',
        'isMore': false,
        'isShow': true,
        disabled: false
      },
      {
        'label': '',
        'icon': 'el-icon-plus',
        'click': '$add',
        'isMore': false,
        'isShow': true,
        disabled: false
      },
      {
        'label': '',
        'icon': 'el-icon-delete',
        'click': '$delete',
        'isMore': false,
        'isShow': true,
        disabled: false
      },
      {
        'label': '审核',
        'icon': '',
        'click': '$billAudit',
        'isMore': true,
        'isShow': true,
        disabled: false
      },
      {
        'label': '取消审核',
        'icon': '',
        'click': '$billUnAudit',
        'isMore': true,
        'isShow': true,
        disabled: false
      },

      {
        'label': '关闭',
        'icon': '',
        'click': '$billClose',
        'isMore': true,
        'isShow': true,
        disabled: false
      },
      {
        'label': '取消关闭',
        'icon': '',
        'click': '$billUnClose',
        'isMore': true,
        'isShow': true,
        disabled: false
      },
      {
        'label': '打印',
        'icon': '',
        'click': '$sendToPrintTask',
        'isShow': true,
        'isMore': true,
        disabled: false
      },
      {
        'label': '配置',
        'icon': '',
        'click': '$setPageConfig',
        'isShow': true,
        'isMore': true
      },
      {
        'label': 'Action',
        'icon': '',
        'click': '$setAction',
        'isShow': true,
        'isMore': true,
        disabled: false
      }
    ]
  },
  data: []
}
const hsButtonToolsSingleForm = {
  config: {
    'buttonList': [
      {
        'label': '',
        'icon': 'el-icon-refresh',
        'click': '$refresh',
        'isMore': false,
        'isShow': true,
        disabled: false
      },
      {
        'label': '保存',
        'click': '$save',
        'icon': '',
        'isShow': true,
        'isMore': false,
        disabled: false
      },
      {
        'label': '配置',
        'icon': '',
        'click': '$setPageConfig',
        'isShow': true,
        'isMore': true,
        disabled: false
      },
      {
        'label': 'Action',
        'icon': '',
        'click': '$setAction',
        'isShow': true,
        'isMore': true,
        disabled: false
      }
    ]
  },
  data: []
}
const hsButtonToolsHdrDtl = {
  config: {
    'buttonList': [
      {
        'label': '',
        'icon': 'el-icon-refresh',
        'click': '$refresh',
        'isMore': false,
        'isShow': true,
        disabled: false
      },
      {
        'label': '',
        'icon': 'el-icon-delete',
        'click': '$delete',
        'isMore': false,
        'isShow': true,
        disabled: false
      },
      {
        'label': '保存',
        'click': '$save',
        'icon': '',
        'isShow': true,
        'isMore': false,
        disabled: false
      },
      {
        'label': '审核',
        'icon': '',
        'click': '$billAudit',
        'isShow': true,
        'isMore': true,
        disabled: false
      },
      {
        'label': '驳回',
        'icon': '',
        'click': '$billReject',
        'isShow': true,
        'isMore': true,
        'disabled': false
      },
      {
        'label': '取消审核',
        'icon': '',
        'click': '$billUnAudit',
        'isShow': true,
        'isMore': true,
        disabled: false
      },
      {
        'label': '关闭',
        'icon': '',
        'click': '$billClose',
        'isShow': true,
        'isMore': true,
        disabled: false
      },
      {
        'label': '取消关闭',
        'icon': '',
        'click': '$billUnClose',
        'isShow': true,
        'isMore': true,
        disabled: false
      },

      {
        'label': '打印',
        'icon': '',
        'click': '$sendToPrintTask',
        'isShow': true,
        'isMore': true,
        disabled: false
      },
      {
        'label': '配置',
        'icon': '',
        'click': '$setPageConfig',
        'isShow': true,
        'isMore': true,
        disabled: false
      },
      {
        'label': 'Action',
        'icon': '',
        'click': '$setAction',
        'isShow': true,
        'isMore': true,
        disabled: false
      }
    ]
  },
  data: []
}
const importHdrHsButtonTools = {
  config: {
    'buttonList': [
      {
        'label': '配置',
        'icon': '',
        'click': '$setPageConfig',
        'isShow': true,
        'isMore': true,
        disabled: false
      },
      {
        'label': 'Action',
        'icon': '',
        'click': '$setAction',
        'isShow': true,
        'isMore': true,
        disabled: false
      }
    ]
  },
  data: []
}
const importDtlHsButtonTools = {
  config: {
    'buttonList': [
      {
        'label': '导入',
        'icon': '',
        'click': '$dataImportHdrDtl',
        'isMore': false,
        'isShow': true,
        disabled: false
      },
      {
        'label': '导入并关闭',
        'icon': '',
        'click': '$dataImportHdrDtlClose',
        'isMore': false,
        'isShow': true,
        disabled: false
      }
    ]
  },
  data: []
}
const hsButtonToolsImport = {
  config: {
    'buttonList': [
      {
        'label': '导入',
        'click': '$dataImport',
        'icon': '',
        'isShow': true,
        'isMore': false,
        disabled: false
      },
      {
        'label': '导入并关闭',
        'click': '$dataImportClose',
        'icon': '',
        'isShow': true,
        'isMore': false,
        disabled: false
      },
      {
        'label': '',
        'icon': 'el-icon-search',
        'click': '$search',
        'isMore': false,
        'isShow': true,
        disabled: false
      },
      {
        'label': '配置',
        'icon': '',
        'click': '$setPageConfig',
        'isShow': true,
        'isMore': true,
        disabled: false
      },
      {
        'label': 'Action',
        'icon': '',
        'click': '$setAction',
        'isShow': true,
        'isMore': true,
        disabled: false
      }
    ]
  },
  data: []
}

const hsButtonToolsCommon = {
  config: {
    'buttonList': [
      {
        'label': '确定',
        'icon': '',
        'isMore': false,
        'isShow': true,
        disabled: false
      }
    ]
  },
  data: []
}
const hsButtonToolsSingleEditRight = {
  config: {
    'buttonList': [
      {
        'label': '取消',
        type: '',
        'icon': '',
        'isMore': false,
        'isShow': true,
        'click': '$cancel',
        disabled: false
      },
      {
        'label': '确定',
        'icon': '',
        'isMore': false,
        'isShow': true,
        disabled: false,
        'click': '$confirm'
      }
    ]
  },
  data: []
}
const hsButtonToolsInDyncDialog = {
  config: {
    'buttonList': [
      {
        'label': '取消',
        'icon': '',
        'isMore': false,
        'isShow': true,
        disabled: false,
        'click': '$cancel'
      },
      {
        'label': '确定',
        'icon': '',
        'isMore': false,
        'isShow': true,
        disabled: false,
        'click': '$confirm'
      }
    ]
  },
  data: []
}
const hsButtonTools = {
  config: {
    'buttonList': [
      {
        'label': '',
        'icon': 'el-icon-refresh',
        'click': '$refresh',
        'isMore': false,
        'isShow': true,
        disabled: false
      },
      {
        'label': '',
        'icon': 'el-icon-plus',
        'click': '$add',
        'isMore': false,
        'isShow': true,
        disabled: false
      },
      {
        'label': '',
        'icon': 'el-icon-delete',
        'click': '$delete',
        'isMore': false,
        'isShow': true,
        disabled: false
      },
      {
        'label': '配置',
        'icon': '',
        'click': '$setPageConfig',
        'isShow': true,
        'isMore': true,
        disabled: false
      },
      {
        'label': 'Action',
        'icon': '',
        'click': '$setAction',
        'isShow': true,
        'isMore': true,
        disabled: false
      }
    ]
  },
  data: []
}
const hsSwitch = {
  config: {
    activeText: '',
    inactiveText: '',
    disabled: false,
    changeed: ''
  },
  data: []
}
const hsCascader = {
  data: [{
    value: 'zhinan',
    label: '指南',
    children: [{
      value: 'shejiyuanze',
      label: '设计原则',
      children: [{
        value: 'yizhi',
        label: '一致'
      }, {
        value: 'fankui',
        label: '反馈'
      }, {
        value: 'xiaolv',
        label: '效率'
      }, {
        value: 'kekong',
        label: '可控'
      }]
    }, {
      value: 'daohang',
      label: '导航',
      children: [{
        value: 'cexiangdaohang',
        label: '侧向导航'
      }, {
        value: 'dingbudaohang',
        label: '顶部导航'
      }]
    }]
  }, {
    value: 'zujian',
    label: '组件',
    children: [{
      value: 'basic',
      label: 'Basic',
      children: [{
        value: 'layout',
        label: 'Layout 布局'
      }, {
        value: 'color',
        label: 'Color 色彩'
      }]
    }, {
      value: 'form',
      label: 'Form',
      children: [{
        value: 'radio',
        label: 'Radio 单选框'
      }, {
        value: 'checkbox',
        label: 'Checkbox 多选框'
      }]
    }, {
      value: 'data',
      label: 'Data',
      children: [{
        value: 'table',
        label: 'Table 表格'
      }]
    }, {
      value: 'notice',
      label: 'Notice',
      children: [{
        value: 'alert',
        label: 'Alert 警告'
      }, {
        value: 'loading',
        label: 'Loading 加载'
      }, {
        value: 'message',
        label: 'Message 消息提示'
      }]
    }]
  }],
  config: {

  }
}
const hsFile = {
  config: {
    multiple: false,
    accept: '*',
    appCode: '',
    label: '查看附件'
  },
  data: []
}
const hsComputed = {
  config: {
    click: ''
  },
  data: []
}
const hsDialog = {
  config: {
    title: '',
    width: '80%'
  },
  data: []
}
const hsTabs = {
  config: {
    tabsList: [{ label: '测试', name: '测试', content: '内容' }]
  },
  data: []
}
const hsTabsTable = {
  config: {
    tabsList: [{
      label: '明细',
      controlName: 'table1'
    }]
  },
  data: []
}
const hsImg = {
  config: {
    width: 200,
    height: 200
  },
  data: []
}
const hsLookup = {
  config: {
    'flag': 'hsLookup',
    'lookupName': '',
    'displayfield': '',
    'writebackfield': [

    ],
    'per_page': 50,
    'dyncQueryParms': {},
    'multiple': false,
    'disabled': false,
    'value': ''
  },
  data: []
}
const hsDragList = {
  config: {
    'flag': 'hsDragList',
    'lookupName': '',
    'displayfield': '',
    'writebackfield': [

    ],
    'per_page': 50,
    'dyncQueryParms': {},
    'multiple': false,
    'disabled': false,
    'value': ''
  },
  data: []
}
const hsSelectList = {
  config: {
    'flag': 'hsSelectList',
    'lookupName': '',
    'displayfield': '',
    'writebackfield': [

    ],
    'per_page': 50,
    'dyncQueryParms': {},
    'multiple': false,
    'disabled': false,
    'value': ''
  },
  data: []
}
const hsCheckboxGroup = {
  config: {
    checkList: [{
      label: 'A'
    }, {
      label: 'B'
    }]
  },
  data: []
}
const hsPopoverTextarea = {
  config: {
  },
  data: []
}
const hsRadio = {
  config: {
    radioList: [{
      'label': 'A',
      'value': 'a'
    },
    {
      'label': 'B',
      'value': 'b'
    }]
  },
  data: []
}
const hsDateTimePicker = {
  config: {
    'isRange': true
  },
  data: []
}
const hsTableIndexHdrDtlIndex = {
  data: {
    'paging': {
      'page': 1,
      'per_page': 10,
      'total': 78
    },
    'total': [
      {
        '客户': '1000',
        '款式': 6600
      }
    ],
    'table': [
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣'

      },
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣'

      }
    ]
  },
  config: {
    bindEntity: '',
    'isAdaptive': true,
    'showHandle': false,
    disaledDblClick: true,
    expandChild: false,
    handleWidth: 80,
    selection: false,
    showIndex: true,
    isShowTools: false,
    toolDirection: 'column',
    exportExcelName: '',
    handleColumns: [
    ],
    'toolItems': [
    ],
    'columnsConfig': [
      {
        'label': '测试列1',
        'prop': '客户',
        'showOverflowTooltip': true
      },
      {
        'label': '测试列2',
        'prop': '客户',
        'showOverflowTooltip': true
      }
    ]
  }
}
const hsRate = {
  config: {}
}
const hsPageConfigDragList = {
  config: {
    restful_appcode: '',
    'isInitMenuParam': false, // 是否初始化menuParam
    'pageMode': true,
    'version': '2.0',
    'ui': {
      right: {
        isTabsForm: false
      },
      left: {
        showQueryComponent: false
      }
    },
    'entity': {
      'right': {
        'isInitNewDefault': false, // 初始化新增默认值
        'initNewDefaultOnce': true, // 是否只调用一次
        'bill_type': '',
        'enableBillFlow': true,
        'table_name': '',
        'primaryKey': 'id',
        'saveIncludeFields': '', // 保存时一定会传入到后台的字段,无论这些字段是否有修改,多字段时逗号串联
        'saveExcludeFields': '', // 保存时不传给后端的字段,无论这些字段是否有修改,多字段时逗号串联
        'dyncQueryParms': {},
        'check': {}, // 校验字段对象
        'saveDyncParms': {// 保存时的动态参数

        }
      },
      'left': {
        'isInitNewDefault': false, // 初始化新增默认值
        'initNewDefaultOnce': true, // 是否只调用一次
        'check': {},
        'showQueryComponent': false,
        'addNewCount': 0,
        'table_name': '',
        'primaryKey': 'id',
        'saveIncludeFields': '', // 保存时一定会传入到后台的字段,无论这些字段是否有修改,多字段时逗号串联
        'saveExcludeFields': '', // 保存时不传给后端的字段,无论这些字段是否有修改,多字段时逗号串联
        'dyncQueryParms': {},
        'queryOneDyncQueryParms': {},
        'importInfo': [
        ]
      }
    },
    'new_default': {
      'main': {
        'columns': {}
      },
      'dtl': {
        'columns': {}
      }
    }
  },
  data: []
}
const hsInputSelect = {
  config: {
    autoAddEmpty: false,
    ref: {
      table_name: '',
      columns: '',
      remote_condition: ''
    },
    dyncQueryParms: {},
    disabled: false,
    size: 'mini',
    clearable: true,
    title: '',
    placeholder: '',
    label: ''
  },
  data: [
    {
      value: '选项1',
      label: '黄金糕'
    }, {
      value: '选项2',
      label: '双皮奶'
    }
  ]
}
const hsPageConfigQueryBi = {
  config: {
    restful_appcode: '',
    'isInitMenuParam': false, // 是否初始化menuParam
    'pageMode': true,
    'version': '2.0',
    'ui': {
    },
    'entity': {

    }
  },
  data: []
}
const hsButton = {
  config: {
    label: '测试'
  }
}
const mockData = {
  hsLineBar: initLineBar,
  hsPie: initPie,
  hsRadar: initRadar,
  hsSelectPlus: hsSelectPlus,
  hsTable: hsTable,
  hsTableImport: hsTableImport,
  hsAction,
  hsInput,
  hsDivider,
  hsDatePicker,
  hsTags,
  hsCheckbox,
  hsTree,
  hsDyncFormComponent,
  hsButtonTools,
  hsButtonToolsBillMain,
  hsButtonToolsBillIndex,
  hsButtonToolsHdrDtl,
  hsButtonToolsImport,
  importHdrHsButtonTools,
  hsButtonToolsSingleMain,
  hsButtonToolsCommon,
  importDtlHsButtonTools,
  hsSwitch,
  hsCascader,
  hsPageConfig,
  hsPageConfigBill,
  hsPageConfigSingle,
  hsPageConfigHdrDtl,
  hsFile,
  hsComputed,
  hsDialog,
  hsTableList,
  hsTableImportList,
  hsTableDtl,
  hsTabs,
  hsInputNumber,
  hsButtonToolsInDyncDialog,
  hsTableInDyncDialog,
  hsImg,
  hsButtonToolsSingleEditRight,
  hsLookup,
  hsPageConfigImport,
  hsPageConfigHdrDtlImport,
  hsCheckboxGroup,
  hsPopoverTextarea,
  hsRadio,
  hsDateTimePicker,
  hsPageConfigIndexHdrDtl,
  hsTableIndexHdrDtlIndex,
  hsTagsSelect,
  hsTableSimple,
  hsTagsTable,
  hsSelectList,
  hsStatusGroup,
  hsRate,
  hsButtonToolsSingleForm,
  hsPageConfigSingleForm,
  hsDragList,
  hsPageConfigDragList,
  hsInputSelect,
  hsTabsTable,
  hsPageConfigQueryBi,
  hsButton
}
export default mockData
