import moment from 'moment'
// 获取当天开始结束时间
export function getCurrDays() {
  const date = []
  date.push(moment().format('YYYY-MM-DD'))
  date.push(moment().format('YYYY-MM-DD'))
  // 获取当天的开始结束时间，精确到时分秒
  // moment().startOf('days').format('YYYY-MM-DD HH:mm:ss')
  // moment().endOf('days').format('YYYY-MM-DD HH:mm:ss')
  return date
}

// 获取昨天的开始结束时间
export function getYesterday() {
  const date = []
  date.push(moment().subtract('days', 1).format('YYYY-MM-DD'))
  date.push(moment().subtract('days', 1).format('YYYY-MM-DD'))
  // 获取昨天的开始结束时间，精确到时分秒
  // moment().subtract('days',1).startOf('days').format('YYYY-MM-DD HH:mm:ss')
  // moment().subtract('days',1).endOf('days').format('YYYY-MM-DD HH:mm:ss')
  return date
}
// 获取明天的开始结束时间
export function getTomorrow() {
  const date = []
  date.push(moment().add('days', 1).format('YYYY-MM-DD'))
  date.push(moment().add('days', 1).format('YYYY-MM-DD'))
  return date
}
// 获取最近七天的开始结束时间
export function getLast7Days() {
  const date = []
  // 不包含当天
  date.push(moment().subtract('days', 7).format('YYYY-MM-DD'))
  date.push(moment().subtract('days', 1).format('YYYY-MM-DD'))
  // 包含当天
  // date.push(moment().subtract('days',6).format('YYYY-MM-DD'))
  // date.push(moment().format('YYYY-MM-DD'))
  return date
}
// 获取最近30天的开始结束时间
export function getLast30Days() {
  const date = []
  date.push(moment().subtract('days', 30).format('YYYY-MM-DD'))
  date.push(moment().subtract('days', 1).format('YYYY-MM-DD'))
  return date
}
// 获取当前周的开始结束时间，周日到周六
export function getCurrWeekDays() {
  const date = []
  const start = moment().startOf('week').format('YYYY-MM-DD')
  const end = moment().endOf('week').format('YYYY-MM-DD')
  date.push(start)
  date.push(end)
  return date
}

// 获取上一周的开始结束时间，周日到周六
export function getLastWeekDays(f = 1) {
  const date = []
  const start = moment().week(moment().week() + f).startOf('week').add(1, 'days').format('YYYY-MM-DD')
  const end = moment().week(moment().week() + f).endOf('week').add(1, 'days').format('YYYY-MM-DD')
  date.push(start)
  date.push(end)
  return date
}
// 获取下一周的开始结束时间，周日到周六
export function getNextWeekDays() {
  const date = []
  const start = moment().week(moment().week() + 1).startOf('week').format('YYYY-MM-DD')
  const end = moment().week(moment().week() + 1).endOf('week').format('YYYY-MM-DD')
  date.push(start)
  date.push(end)
  return date
}
// 获取当前月的开始结束时间
export function getCurrMonthDays() {
  const date = []
  const start = moment().startOf('month').format('YYYY-MM-DD')
  const end = moment().endOf('month').format('YYYY-MM-DD')
  date.push(start)
  date.push(end)
  return date
}
// 获取某一周的开始时间
export function getSomeWeekStartDays(now, f = 1) {
  const start = moment(now).week(moment(now).week() + f).startOf('week').add(1, 'days').format()
  return new Date(start)
}
export function getSomeMonthStartDays(now, f = 1) {
  const start = moment(now).month(moment(now).month() + f).startOf('month').format()
  return new Date(start)
}
export function getSomeYearStartDays(now, f = 1) {
  const start = moment(now).year(moment(now).year() + f).startOf('year').format()
  return new Date(start)
}
// 获取上一月的开始结束时间
export function getLastMonthDays() {
  const date = []
  const start = moment().month(moment().month() - 1).startOf('month').format('YYYY-MM-DD')
  const end = moment().month(moment().month() - 1).endOf('month').format('YYYY-MM-DD')
  date.push(start)
  date.push(end)
  return date
}
// 当前季度
export function getCurrQuarter() {
  const date = []
  const start = moment().startOf('quarter').format('YYYY-MM-DD')
  const end = moment().endOf('quarter').format('YYYY-MM-DD')
  date.push(start)
  date.push(end)
  return date
}
// 上个季度
export function getLastQuarter() {
  const date = []
  const start = moment().quarter(moment().quarter() - 1).startOf('quarter').format('YYYY-MM-DD')
  const end = moment().quarter(moment().quarter() - 1).endOf('quarter').format('YYYY-MM-DD')
  date.push(start)
  date.push(end)
  return date
}
