
export default {
  bind(el, binding, vnode) {
    el.handler = function(e) {
      if (el.contains(e.target)) {
        return false
      }
      // vnode.context[binding.expression] = false

      binding.value()
    }
    el.stopProp = function(event) {
      event.stopPropagation()
    }
    el.addEventListener('click', el.stopProp)
    document.body.addEventListener('click', el.handler)
  },
  unbind(el, binding) {
    el.removeEventListener('click', el.stopProp)
    document.body.removeEventListener('click', el.handler)
  },
  install(Vue) {
    Vue.directive('clickoutside', {
      bind: this.bind,
      unbind: this.unbind
    })
  }
}
