import uuidv1 from 'uuid/v1'

export default {
  data () {
    return {
      elId: '',
      outBoxDom: null
    }
  },
  created () {
    this.elId = uuidv1() // 获取随机id
  },
  mounted () {
    this.$nextTick(_ => {
      this.showEditJsonDialog()
    })
  },
  destroyed () {
    if (this.outBoxDom) {
      this.outBoxDom.removeEventListener('mousedown', this.boxEventMouse)
    }

    this.chart = null
  },
  beforeDestroy () {
    clearInterval(this.timer)// 清除定时器
    this.timer = null
    if (this.chart) {
      this.chart.clear()
      this.chart.dispose()
      this.chart = null
    }
  },
  methods: {
    boxEventMouse (event) {
      const that = this
      event.stopPropagation()
      if (event.shiftKey && event.altKey && !event.ctrlKey) {
        that.jsoneditorVisible = true
        that.$store.commit('set_pause_status', true)
      }
    },
    // 弹出可编辑的弹框
    showEditJsonDialog () {
      this.outBoxDom = document.getElementById(this.elId)
      this.outBoxDom && this.outBoxDom.addEventListener('mousedown', this.boxEventMouse)
    }

  }
}
