
const data = [
  {
    'sLegendName': 'GO1', // 图例名
    'sColor': '#ffffff', // 颜色
    'sName': '一月', // x轴上的名称
    'dValue': '74' // y轴上的数值
  }, {
    'sLegendName': 'GO1', // 图例名
    'sColor': '#ffffff', // 颜色
    'sName': '二月', // x轴上的名称
    'dValue': '34' // y轴上的数值
  },
  {
    'sLegendName': 'GO1', // 图例名
    'sColor': '#ffffff', // 颜色
    'sName': '三月', // x轴上的名称
    'dValue': '14' // y轴上的数值
  },
  {
    'sLegendName': 'GO1', // 图例名
    'sColor': '#ffffff', // 颜色
    'sName': '四月', // x轴上的名称
    'dValue': '24' // y轴上的数值
  },
  {
    'sLegendName': 'GO2', // 图例名
    'sColor': 'blue', // 颜色
    'sName': '一月', // x轴上的名称
    'dValue': '20' // y轴上的数值
  }, {
    'sLegendName': 'GO2', // 图例名
    'sColor': '#ffffff', // 颜色
    'sName': '二月', // x轴上的名称
    'dValue': '64' // y轴上的数值
  },
  {
    'sLegendName': 'GO2', // 图例名
    'sColor': '#ffffff', // 颜色
    'sName': '三月', // x轴上的名称
    'dValue': '10' // y轴上的数值
  },
  {
    'sLegendName': 'GO2', // 图例名
    'sColor': '#ffffff', // 颜色
    'sName': '四月', // x轴上的名称
    'dValue': '90' // y轴上的数值
  }]
const slegends = [
  { sLegendName: 'GO1', iType: 'line', 'sColor': 'red', iSeqNo: 1, iYDirection: 1 },
  { sLegendName: 'GO2', iType: 'line', 'sColor': 'blue', iSeqNo: 2, iYDirection: 2 }
]
function transSourceData(legentItem, list) {
  const { sLegendName, iType } = legentItem
  const parms = {}
  parms.name = sLegendName
  const data = []
  const xData = []
  let color = ''
  let sType = ''
  // 找出目标图例
  const target = list.filter(item => item.sLegendName === sLegendName)
  target.forEach(item => {
    data.push(item['dValue'])
    xData.push(item['sName'])
    color = item['sColor']
    sType = iType
  })
  parms.data = data
  parms.x_data = xData
  parms.lineStyle = {
    color
  }
  parms.type = sType
  return parms
}
function tranLegends(slegends, data) {
  const result = []
  slegends.forEach(item => {
    result.push(transSourceData(item, data))
  })
  return result
}

console.log(tranLegends(slegends, data))
const limitLines = [
  { 'iYDirection': 1, 'sLimitLineName': '基准线名1', 'sLimitLineColor': 'red', 'sLimitLineWidth': 2, 'sLimitLineValue': 10 },
  { 'iYDirection': 1, 'sLimitLineName': '基准线名11', 'sLimitLineColor': 'yellow', 'sLimitLineWidth': 2, 'sLimitLineValue': 30 },
  { 'iYDirection': 2, 'sLimitLineName': '基准线名2', 'sLimitLineColor': 'blue', 'sLimitLineWidth': 1, 'sLimitLineValue': 40 }
]
// 根据某个字段来分组
function filteriYDirection(value, limitLines) {
  const iYDirectionList = limitLines.filter(item => {
    return parseInt(item.iYDirection) === parseInt(value)
  })
  const datas = []
  let color = ''
  let sLimitLineWidth = ''
  iYDirectionList.forEach(item => {
    datas.push({ name: item.sLimitLineName, yAxis: item.sLimitLineValue })
    color = item.sLimitLineColor
    sLimitLineWidth = item.sLimitLineWidth
  })
  return {
    data: datas,
    label: {
      show: true,
      position: 'middle',
      formatter: '{b}: {c}'
    },
    lineStyle: {
      color,
      width: sLimitLineWidth
    }
  }
}

console.log(filteriYDirection(1, limitLines))
