// 系列: sSeries  计划数、完成数
// x轴:sName
// 值: dValue
const _ = require('lodash')
const options = {
  'yAxis': [
    {
      'type': 'value'
    }
  ],
  'xAxis': {
    'type': 'category',
    'data': [
      '五车间',
      '六车间',
      '七车间',
      '八车间',
      '九车间',
      '十一车间'
    ]
  },
  'legend': {
    'show': true,
    'orient': 'horizontal',
    'bottom': '0',
    'textStyle': {
      'fontSize': 12
    },
    'data': [
      '计划数',
      '完成数'
    ]
  },
  'series': [
    {
      'name': '计划数',
      'data': [],
      'type': 'line'
    },
    {
      'name': '完成数',
      'data': [],
      'type': 'bar'
    }
  ]
}
const data = [
  {
    'sSeries': '计划数',
    'sName': '五车间',
    'dValue': '18',
    'sShowValue': '19'
  },
  {
    'sSeries': '计划数',
    'sName': '六车间',
    'dValue': '28',
    'sShowValue': '28'
  },
  {
    'sSeries': '计划数',
    'sName': '七车间',
    'dValue': '31',
    'sShowValue': '31'
  },
  {
    'sSeries': '计划数',
    'sName': '八车间',
    'dValue': '45',
    'sShowValue': '45'
  },
  {
    'sSeries': '计划数',
    'sName': '九车间',
    'dValue': '57',
    'sShowValue': '57'
  },
  {
    'sSeries': '计划数',
    'sName': '十一车间',
    'dValue': '98',
    'sShowValue': '98'
  },
  {
    'sSeries': '完成数',
    'sName': '五车间',
    'dValue': '45',
    'sShowValue': '45'
  },
  {
    'sSeries': '完成数',
    'sName': '六车间',
    'dValue': '48',
    'sShowValue': '48'
  },
  {
    'sSeries': '完成数',
    'sName': '七车间',
    'dValue': '41',
    'sShowValue': '41'
  },
  {
    'sSeries': '完成数',
    'sName': '八车间',
    'dValue': '60',
    'sShowValue': '60'
  },
  {
    'sSeries': '完成数',
    'sName': '九车间',
    'dValue': '39',
    'sShowValue': '39'
  },
  {
    'sSeries': '完成数',
    'sName': '十一车间',
    'dValue': '39',
    'sShowValue': '39'
  }
]
function processDataLine(config, data) {
// 根据数据的sSeries 进行分组
  const gp = _.groupBy(data, 'sSeries')
  // 所有的系列
  const { series, xAxis } = config
  const options_series = series
  const xData = xAxis.data
  // 给每个系列赋予值
  options_series.forEach(item => {
    const { name } = item
    // 按照x轴(xData)的顺序进行取值
    const sdata = gp[name]
    const list = []
    xData.forEach(x => {
      const targetX = sdata.find(sx => sx.sName === x)
      list.push(targetX.dValue)
    })
    item.data = list
  })
  return config
}
const data_pie = data
const option_pie = {
  tooltip: {
    trigger: 'item',
    formatter: '{a} <br/>{b}: {c} ({d}%)'
  },
  legend: {
    orient: 'vertical',
    left: 10,
    data: ['五车间', '六车间', '七车间', '八车间', '九车间', '十一车间']
  },
  series: [
    {
      name: '计划数',
      type: 'pie',
      radius: ['50%', '70%'],
      avoidLabelOverlap: false,
      label: {
        show: false,
        position: 'center'
      },
      emphasis: {
        label: {
          show: true,
          fontSize: '30',
          fontWeight: 'bold'
        }
      },
      labelLine: {
        show: false
      },
      data: [
        // { value: 335, name: '五车间' },
        // { value: 310, name: '六车间' },
        // { value: 234, name: '七车间' },
        // { value: 135, name: '八车间' },
        // { value: 1548, name: '九车间' },
        // { value: 1548, name: '十一间' }
      ]
    }
  ]
}
function processDataPie(config, data) {
  // 根据数据的sSeries 进行分组
  const gp = _.groupBy(data, 'sSeries')
  // 所有的系列
  const { series, legend } = config
  const options_series = series
  const legendData = legend.data
  // 给每个系列赋予值
  options_series.forEach(item => {
    const { name } = item
    // 按照x轴(xData)的顺序进行取值
    const sdata = gp[name]
    const list = []
    legendData.forEach(x => {
      const targetX = sdata.find(sx => sx.sName === x)
      list.push({ value: targetX.dValue, name: x })
    })
    item.data = list
  })
  console.log(config)
  return config
}

processDataPie(option_pie, data)
