
import axios from 'axios'
import { Notification, Loading } from 'element-ui'
import hsUtil from 'hs-util-js'
import store from '@/store/storeAll'
import httpClient from './startUp'
let fullLoading
function showLoading() {
  fullLoading = Loading.service({
    lock: true,
    text: '加载中...',
    spinner: 'el-icon-loading',
    background: 'rgba(0, 0, 0, 0)'
  })
  setTimeout(_ => {
    fullLoading.close()
  }, 10000)
}
function closeLoading() {
  fullLoading && fullLoading.close()
}
let loading_request_count = 0
function show_full_screen_loading() {
  if (loading_request_count === 0) {
    showLoading()
  }
  loading_request_count++
}
function hide_full_screen_loading() {
  if (loading_request_count <= 0) return
  loading_request_count--
  if (loading_request_count === 0) {
    closeLoading()
  }
}
// 增加一个response拦截器
axios.interceptors.response.use(
  function(response) {
    hide_full_screen_loading()
    if (response.data) {
      const { error_detail, error_title } = response.data
      if (error_title || error_detail) {
        Notification.error({
          title: '错误信息！',
          dangerouslyUseHTMLString: true,
          duration: 100000,
          message: `<div>
          <textarea style="border:0;border-radius:5px;background-color:rgba(241,241,241,.98);width: 300px;height: 400px;padding: 10px;resize: none;position: relative;right: 36px;">
            ${error_title}
            ${error_detail}
          </textarea>
          </div>` // error_detail || error_title,
        })
      } else { // 此处做优化 只有不出错的时候才返回response
        return response
      }
    } else { // 此处做优化 只有不出错的时候才返回response
      return response
    }
  },
  async function(error) {
    hide_full_screen_loading()
    // 如果返回的code中token 过期了则刷新token
    const code = error.response && error.response.status
    const resData = (error.response && error.response.data) || {}
    if (code === 401 && resData.error_type === 'expired' && self !== top) { // 401时过期了把请求缓存起来,等待webframe刷新token后再统一请求!
      return httpClient.tokenModule.hand401Meaage(error.response.config)
    } else {
      response_error_del(error)
      return Promise.reject(error)
    }
  }
)
function response_error_del(error) {
  const { response, code } = error
  const { status, statusText, data } = response || {}
  let error_title = '错误信息'
  let error_detail = ''
  if (!response && !code) {
    // 没网的情况
    error_title = '网络连接失败，请检查网络！'
    error_detail = '尝试关闭网站重新登陆！'
  } else if (code === 'ECONNABORTED') {
    error_title = '请求超时ECONNABORTED'
    error_detail = 'Uncaught (in promise) Error: timeout of 60000ms exceeded'
  } else if (status === 504) {
    error_title = '请求超时504'
    error_detail = data
  } else if (status === 404) {
    error_title = '404资源请求路径找不到'
    error_detail = response.request.responseURL
  } else if (status === 401 && statusText === 'UNAUTHORIZED') {
    if (self !== top) parent.postMessage('login', '*')
    sessionStorage.removeItem('header')
    error_detail = 'UNAUTHORIZED-未授权401'
    error_title = '身份验证失败，请重新登录!'
  } else {
    if (data.message) {
      error_title = data.message
    } else if (data instanceof Blob) {
      // 这条判断是解决 下载文件返回流的情况 要把流转成json
      const reader = new FileReader()
      reader.readAsText(data)
      const dealFileReader = async function() {
        const result = await new Promise(function(resolve, reject) {
          reader.onload = e => {
            resolve(JSON.parse(e.target.result))
          }
        })
        error_title = result.error_title ? result.error_title : '服务器异常'
        error_detail = result.error_detail
        if (sessionStorage['platform']) {
          store.commit('set_error_info', { error_title, error_detail })
        } else {
          hsUtil.IframeMessageModule.sendErrorToWebframe({ error_title, error_detail })
        }
      }
      dealFileReader()
      return
    } else if (Object.keys(data).length === 4) {
      error_title = data.error_title ? data.error_title : '服务器异常'
      error_detail = data.error_detail
    } else {
      error_title = '服务器内部错误'
      error_detail = data
    }
  }
  if (sessionStorage['platform'] || top === self) {
    store.commit('set_error_info', { error_title, error_detail })
  } else {
    hsUtil.IframeMessageModule.sendErrorToWebframe({ error_title, error_detail })
  }
}
axios.interceptors.request.use(
  async config => {
    // 设置token信息
    // config.headers['refreshToken'] = sessionStorage['refresh_token']
    config.headers['Authorization'] = sessionStorage['token']
    config.headers['tenant'] = 'wms'
    if (config.url.indexOf('no_loading') !== -1) {
    } else {
      if (config.url.startsWith('http:') || config.url.startsWith('https:')) {
        // 俺啥都不干
      } else {
        config.url = config.url.replace('//', '/')
      }
      show_full_screen_loading()
    }
    if (config.url.includes('?&')) {
      config.url = config.url.replace('?&', '?')
    }
    return config
  },
  err => {
    hide_full_screen_loading()
    return Promise.reject(err)
  }
)
