import { AUDIT_BILLS, UN_AUDIT_BILLS, CLOSE_BILLS, UN_CLOSE_BILLS, SEND_BILLS, UN_SEND_BILLS, REJECT_BILLS } from '../common/commonModule'
// 单据流类
class Billflow {
  constructor(requestClient) {
    this.requestClient = requestClient
    this.moduleName = 'BillflowModule'
  }
  billHandleCommon(obj) {
    const { data, type } = obj
    let url = ''
    switch (type) {
      case 'billAudit':
        url = `${AUDIT_BILLS}`
        break
      case 'billUnAudit':
        url = `${UN_AUDIT_BILLS}`
        break
      case 'billSend':
        url = `${SEND_BILLS}`
        break
      case 'billUnSend':
        url = `${UN_SEND_BILLS}`
        break
      case 'billClose':
        url = `${CLOSE_BILLS}`
        break
      case 'billUnClose':
        url = `${UN_CLOSE_BILLS}`
        break
      case 'billReject':
        url = `${REJECT_BILLS}`
        break
    }
    return this.requestClient.post(url, data)
  }
}
export default Billflow
