import { TOOL_API } from '../common/commonModule'
class RestFul {
  constructor(requestClient) {
    this.requestClient = requestClient
    this.moduleName = 'RestFulModule'
  }
  query(data) {
    const { tableName, appCode, group, parms, bodyData } = data
    let url = `${TOOL_API}${appCode}/${tableName}/`
    if (group) { // 非标准保存
      url = `${url}${group}/`
    }
    if (bodyData) {
      return this.requestClient.pust(url, bodyData, parms)
    } else {
      return this.requestClient.get(url, parms)
    }
  }
  save(data) {
    const { tableName, appCode, bodyData, group, parms } = data
    let url = `${TOOL_API}${appCode}/${tableName}/`
    if (group) { // 非标准保存
      url = `${url}${group}/`
    }
    return this.requestClient.post(url, bodyData, parms)
  }
  queryOne(data) {
    const { tableName, id, appCode, parms, group, bodyData } = data
    let url_ = `${TOOL_API}${appCode}/${tableName}/${id}/`
    if (group) {
      url_ = `${url_}${group}/`
    }
    if (bodyData) {
      return this.requestClient.put(url_, bodyData, parms)
    } else {
      return this.requestClient.get(url_, parms)
    }
  }
  put(data) {
    const { tableName, appCode, bodyData, group, parms } = data
    let url = `${TOOL_API}${appCode}/${tableName}/`
    if (group) { // 非标准保存
      url = `${url}${group}/`
    }
    return this.requestClient.put(url, bodyData, parms)
  }
  queryList(data) {
    const { tableName, appCode, parms, group, bodyData } = data
    let url_ = `${TOOL_API}${appCode}/${tableName}/`
    if (group) {
      url_ = `${url_}${group}/`
    }
    parms.fuzzy = 1
    if (bodyData) {
      return this.requestClient.put(url_, bodyData, parms)
    } else {
      return this.requestClient.get(url_, parms)
    }
  }
  deleteList(data) {
    const { tableName, appCode, bodyData, parms } = data
    const url_ = `${TOOL_API}${appCode}/${tableName}/`
    return this.requestClient.delete(url_, bodyData, parms)
  }
}
export default RestFul
