
import axios from 'axios'
import { Notification, Loading } from 'element-ui'
import commonUtility from './commonUtility'
import _ from 'lodash'
import hswebapp2frame from 'hswebapp2frame'
let fullLoading
function showLoading() {
  fullLoading = Loading.service({
    lock: true,
    text: '加载中...',
    spinner: 'el-icon-loading',
    background: 'rgba(0, 0, 0, 0)'
  })
  setTimeout(_ => {
    fullLoading.close()
  }, 10000)
}
function closeLoading() {
  fullLoading && fullLoading.close()
}
let loading_request_count = 0
function show_full_screen_loading() {
  if (loading_request_count === 0) {
    showLoading()
  }
  loading_request_count++
}
function hide_full_screen_loading() {
  if (loading_request_count <= 0) return
  loading_request_count--
  if (loading_request_count === 0) {
    closeLoading()
  }
}
// 增加一个response拦截器
axios.interceptors.response.use(
  function(response) {
    hide_full_screen_loading()
    if (response.data) {
      const { error_detail, error_title } = response.data
      if (error_title || error_detail) {
        Notification.error({
          title: '错误信息！',
          dangerouslyUseHTMLString: true,
          duration: 100000,
          message: `<div>
          <textarea style="border:0;border-radius:5px;background-color:rgba(241,241,241,.98);width: 300px;height: 400px;padding: 10px;resize: none;position: relative;right: 36px;">
            ${error_title}
            ${error_detail}
          </textarea>
          </div>` // error_detail || error_title,
        })
      } else { // 此处做优化 只有不出错的时候才返回response
        return response
      }
    } else { // 此处做优化 只有不出错的时候才返回response
      return response
    }
  },
  function(error) {
    hide_full_screen_loading()
    if (self === top) {
      dyncInnerErrorDel(error)
    } else {
      response_error_del(error)
    }
    return Promise.reject(error)
  }
)
function dyncInnerErrorDel(error) {
  if (error.message === 'Network Error') {
    Notification.error({
      title: '错误信息！',
      message: '网络连接错误!请检查您的网络是否正常!',
      type: 'warning'
    })
  }
  if (error.response && typeof error.response.data === 'string') {
    Notification.error({
      title: '错误信息！',
      dangerouslyUseHTMLString: true,
      type: 'warning',
      duration: 100000,
      message: `<div>
      <textarea style="border:0;border-radius:5px;background-color:rgba(241,241,241,.98);width: 300px;height: 400px;padding: 10px;resize: none;position: relative;right: 36px;">
        ${error.response.data}
      </textarea>
      </div>`
    })
  }
  if (error.response && typeof error.response.data === 'object') {
    const { error_detail, error_title } = error.response.data
    Notification.error({
      title: '错误信息！',
      dangerouslyUseHTMLString: true,
      duration: 100000,
      message: `<div>
      <textarea style="border:0;border-radius:5px;background-color:rgba(241,241,241,.98);width: 300px;height: 400px;padding: 10px;resize: none;position: relative;right: 36px;">
        ${error_title}
        ${error_detail}
      </textarea>
      </div>`
    })
  }
}
function response_error_del(error) {
  const { response, code } = error
  const { status, statusText, data } = response || {}
  let error_title = '错误信息'
  let error_detail = ''
  if (!response && !code) {
    // 没网的情况
    error_title = '网络连接失败，请检查网络！'
    error_detail = '尝试关闭网站重新登陆！'
  } else if (code === 'ECONNABORTED') {
    error_title = '请求超时ECONNABORTED'
    error_detail = 'Uncaught (in promise) Error: timeout of 60000ms exceeded'
  } else if (status === 504) {
    error_title = '请求超时504'
    error_detail = data
  } else if (status === 404) {
    error_title = '404资源请求路径找不到'
    error_detail = response.request.responseURL
  } else if (status === 401 && statusText === 'UNAUTHORIZED') {
    if (self !== top) parent.postMessage('login', '*')
    sessionStorage.removeItem('header')
    error_detail = 'UNAUTHORIZED-未授权401'
    error_title = '身份验证失败，请重新登录!'
  } else {
    if (data.message) {
      error_title = data.message
    } else if (data instanceof Blob) {
      // 这条判断是解决 下载文件返回流的情况 要把流转成json
      const reader = new FileReader()
      reader.readAsText(data)
      const dealFileReader = async function() {
        const result = await new Promise(function(resolve, reject) {
          reader.onload = e => {
            resolve(JSON.parse(e.target.result))
          }
        })
        error_title = result.error_title ? result.error_title : '服务器异常'
        error_detail = result.error_detail
        hswebapp2frame.initError({ error_title, error_detail })
      }
      dealFileReader()
      return
    } else if (Object.keys(data).length === 4) {
      error_title = data.error_title ? data.error_title : '服务器异常'
      error_detail = data.error_detail
    } else {
      error_title = '服务器内部错误'
      error_detail = data
    }
  }
  hswebapp2frame.initError({ error_title, error_detail }) // 发错误消息给ifram
}
axios.interceptors.request.use(
  config => {
    if (config.url.indexOf('no_loading') !== -1) {
    } else {
      if (config.url.startsWith('http:') || config.url.startsWith('https:')) {
        // 俺啥都不干
      } else {
        config.url = config.url.replace('//', '/')
      }
      show_full_screen_loading()
    }
    if (config.url.includes('?&')) {
      config.url = config.url.replace('?&', '?')
    }
    return config
  },
  err => {
    hide_full_screen_loading()
    return Promise.reject(err)
  }
)

let fi_data = {}
const tempList = [undefined, 'undefined']
// 需要在登录时将db_name、app_code、isMock参数存到session里
// 需要在代理配置mainAPI
const module_url = `mainAPI/web_query/query/`
const module_url2 = `mainAPI/web_query/query_value/`
const module_url3 = `mainAPI/web_query/`
const module_Gql_query = 'GQLAPI/sql_gql/'
const module_Gql_query_save = 'GQLAPI/sql_gql/save/'
const module_toolAPI = 'toolAPI/api/'
const module_tool = 'toolAPI/'
const module_query_page = 'mainAPI/web_chart_config/query_page/'
const emptyList = [undefined, 'undefined', null, 'null', '']
const commonUtilAPI = 'commonUtilAPI/'
const bill_audit_bills = `${commonUtilAPI}audit_bills/`
const bill_un_audit_bills = `${commonUtilAPI}un_audit_bills/`
const bill_close_bills = `${commonUtilAPI}close_bills/`
const bill_un_close_bills = `${commonUtilAPI}un_close_bills/`
const bill_send_bills = `${commonUtilAPI}send_bills/`
const bill_un_send_bills = `${commonUtilAPI}un_send_bills/`
function getPageParms() {
  const { db_name, is_mock, db_code } = commonUtility.parseUrlQueryString()
  const { appCode, pagename } = commonUtility.parseUrlQueryBIDyncAppcodePageName()
  const isMock = emptyList.includes(is_mock) ? 1 : is_mock
  const dbName = db_name || ''
  const obj = _.cloneDeep({
    dbName,
    appCode,
    page: pagename,
    isMock,
    db_code
  })
  return obj
}
const API = {
  runAsync(url, routerParms = {}, on_off = false) {
    let str = ''
    var p = new Promise(function(resolve, reject) {
      if (!on_off) {
        const { page, isMock, dbName, db_code } = getPageParms()
        const sPag = routerParms.page || page
        const postData = {
          exec_sql: `EXEC dbo.sptmcQueryData @sPage='${sPag}',@sPosition='${routerParms.position}',@sData='${routerParms.other ? JSON.stringify(routerParms.other) : '0x'}',@bMockData=${isMock}`,
          db_name: dbName || '',
          db_code
        }

        axios.post(module_url, postData).then(res => {
          const r_d = res.data[0] ? res.data[0].result : ''
          if (r_d !== '' && r_d !== undefined) {
            fi_data = JSON.parse(r_d)
            resolve(fi_data)
          } else {
            for (const key in routerParms) {
              if (key === 'position' || key === 'path') {
                str += routerParms[key] + '/'
              }
            }
            if (!url.endsWith('/')) {
              url = url + '/'
            }
            axios.get(url + str).then(res => {
              if (res.data.errcode === 404) {
                fi_data = JSON.parse(JSON.stringify(res.data.data))
                resolve(fi_data)
              } else {
                fi_data = JSON.parse(JSON.stringify(res.data))
                resolve(fi_data)
              }
            })
          }
        })
      } else {
        for (const key in routerParms) {
          str += routerParms[key] + '/'
        }
        if (url.substr(url.length - 1, 1) !== '/') {
          url = url + '/'
        }
        axios.get(url + str).then(res => {
          fi_data = JSON.parse(JSON.stringify(res.data))
          resolve(fi_data)
        })
      }
    })
    return p
  },
  getData(data) { // routerParms: page路由 position位置 other参数
    const { appCode, page, isMock, dbName: db_Name, db_code } = getPageParms()
    const { sAppCode: sAppCode_, sPage: sPage_, sControl: sControl_, isMock: is_mock, dbName, elInfo: elInfo_, other } = data
    const db_name = dbName || db_Name || ''
    const elInfo = elInfo_ || {}
    const sPage = sPage_ || elInfo.page || page || ''
    const sAppCode = sAppCode_ || appCode
    const sControl = sControl_ || elInfo.position
    const isMock_ = typeof is_mock !== 'undefined' ? is_mock : (isMock || 1)
    var p = new Promise(function(resolve, reject) {
      const postData = {
        exec_sql: `EXEC dbo.spappCommonQuery_Data @sAppCode='${sAppCode}',@sPage='${sPage}',@sControl='${sControl}',@sParam='${other ? JSON.stringify(other) : '0x'}',@bMockData=${isMock_}`,
        db_name: db_name,
        db_code
      }
      axios.post(module_url, postData).then(res => {
        if (!res) return
        if (isMock) {
          const r_d = res.data[0] ? res.data[0].json_data : ''
          if (r_d !== '' && r_d !== undefined) {
            fi_data = JSON.parse(r_d)
            resolve(fi_data)
          } else {
            resolve([])
          }
        } else {
          fi_data = JSON.parse(res.data)
          resolve(fi_data)
        }
      })
    })
    return p
  },
  getConfig(data) {
    const { appCode, page, dbName: db_Name, db_code } = getPageParms()
    const { sAppCode: sAppCode_, sPage: sPage_, sControl: sControl_, dbName, elInfo: elInfo_, other } = data
    const elInfo = elInfo_ || {}
    const db_name = dbName || db_Name || ''
    const sPage = sPage_ || elInfo.page || page || ''
    const sAppCode = sAppCode_ || appCode
    const sControl = sControl_ || elInfo.position
    const otherParm = other ? JSON.stringify(other) : '0x'
    var p = new Promise(function(resolve, reject) {
      const postData = {
        exec_sql: `EXEC dbo.spappCommonQuery_Config @sAppCode='${sAppCode}',@sPage='${sPage}',@sControl='${sControl}',@sParam='${otherParm}'`,
        db_name: db_name,
        db_code
      }
      axios.post(module_url2, postData).then(res => {
        if (!res) return
        const r_d = res.data
        resolve(r_d)
      })
    })
    return p
  },
  runSave(data) { // routerParms: page路由 position位置 other参数, sConfig 配置json sData 数据json
    const { sAppCode: sAppCode_, sPage: sPage_, sControl: sControl_, sConfig, sData, sQuerySql, is_mock, dbName, elInfo } = data
    const control_type = (elInfo && elInfo.el) || ''
    const { appCode, page, isMock, dbName: db_Name, db_code } = getPageParms()
    var p = new Promise(function(resolve, reject) {
      const db_name = dbName || (elInfo && elInfo.db_name) || db_Name || ''
      const sPage = sPage_ || (elInfo && elInfo.page) || page || ''
      const sAppCode = sAppCode_ || (elInfo && elInfo.sAppCode) || appCode
      var sIsMock
      if (parseInt(is_mock) === 0 || parseInt(is_mock) === 1) {
        sIsMock = is_mock
      } else {
        sIsMock = isMock
      }
      const sSQl = sQuerySql || ''
      const sControl = sControl_ || elInfo.position
      const globalParams = commonUtility.parseGlobalParams()
      const user_id = globalParams.user_id || 1
      const postData = {
        exec_sql: `EXEC dbo.spappWebChartConfig_Save @sAppCode='${sAppCode}',@sPage='${sPage}',@sControl='${sControl}',@sControlType='${control_type}',@sConfig=:sConfig,@sData=:sData,@sQuerySql='${sSQl}',@bMockData='${sIsMock}',@iUserId=${user_id}`,
        db_name: db_name,
        db_code,
        param: {
          sConfig: JSON.stringify(sConfig),
          sData: JSON.stringify(sData)
        }
      }
      axios.post(module_url3, postData).then(res => {
        if (!res) return
        if (isMock) {
          const r_d = res.data[0] ? res.data[0].json_data : ''
          if (r_d !== '' && r_d !== undefined) {
            fi_data = JSON.parse(r_d)
            resolve(fi_data)
          } else {
            resolve([])
          }
        } else {
          fi_data = JSON.parse(res.data)
          resolve(fi_data)
        }
      })
    })
    return p
  },
  getSql(data) {
    const { sAppCode: sAppCode_, sPage: sPage_, sControl: sControl_, dbName } = data
    const { appCode, page, dbName: db_Name, db_code } = getPageParms()
    const globalParams = commonUtility.parseGlobalParams()
    const user_id = globalParams.user_id || 1
    var p = new Promise(function(resolve, reject) {
      const db_name = dbName || db_Name || ''
      const sAppCode = sAppCode_ || appCode
      const sPage = sPage_ || page || ''
      const sControl = sControl_
      const postData = {
        exec_sql: `EXEC dbo.spappWebChartConfig_Query @sAppCode='${sAppCode}',@sPage='${sPage}',@sControl='${sControl}',@iUserId='${user_id}'`,
        db_name: db_name,
        db_code
      }
      axios.post(module_url, postData).then(res => {
        resolve(res.data)
      })
    })
    return p
  },
  download(name, data) {
    var urlObject = window.URL || window.webkitURL || window
    var downloadData = new Blob([data])
    var save_link = document.createElementNS('http://www.w3.org/1999/xhtml', 'a')
    save_link.href = urlObject.createObjectURL(downloadData)
    save_link.download = name
    this.fake_click(save_link)
  },
  fake_click(obj) {
    var ev = document.createEvent('MouseEvents')
    ev.initMouseEvent(
      'click', true, false, window, 0, 0, 0, 0, 0
      , false, false, false, false, 0, null
    )
    obj.dispatchEvent(ev)
  },
  downSql(data) {
    const { sAppCode: sAppCode_, sPage: sPage_, dbName } = data
    const { appCode, page, dbName: db_Name, db_code } = getPageParms()
    const db_name = dbName || db_Name || ''
    const sAppCode = sAppCode_ || appCode
    const sPage = sPage_ || page || ''
    const postData = {
      exec_sql: `EXEC dbo.spappWebChartConfig_SaveAs @sAppCode='${sAppCode}',@sPage='${sPage}'`,
      db_name: db_name,
      db_code
    }
    axios.post(module_url2, postData).then(res => {
      if (!res) return
      const r_d = res.data
      this.download(`spappWebChartConfig_Upgrade_${sAppCode}_${sPage}.sql`, r_d)
    })
  },
  execSql(data) {
    var postData = {}
    const { dbName: db_Name, db_code } = getPageParms()
    if (typeof data === 'object') {
      const { sQuerySql, dbName } = data
      const db_name = dbName || db_Name || ''
      postData = {
        exec_sql: sQuerySql,
        db_name,
        db_code
      }
    } else {
      postData = {
        exec_sql: data,
        db_Name,
        db_code
      }
    }
    var p = new Promise(function(resolve, reject) {
      axios.post(module_url, postData).then(res => {
        resolve(res.data)
      })
    })
    return p
  },
  getPageLog(data) {
    const { sAppCode: sAppCode_, sPage: sPage_, dbName, sControl } = data
    const { appCode, page, dbName: db_Name, db_code } = getPageParms()
    const db_name = dbName || db_Name || ''
    const sAppCode = sAppCode_ || appCode
    const sPage = sPage_ || page || ''
    var p = new Promise(function(resolve, reject) {
      const postData = {
        exec_sql: `EXEC dbo.spappWebChartConfig_QueryLog  @sAppCode='${sAppCode}',@sPageName='${sPage}',@sControlName='${sControl}'`,
        db_name: db_name,
        db_code
      }
      axios.post(module_url, postData).then(res => {
        if (!res) {
          resolve([])
          return
        }
        if (res && !res.data) {
          resolve([])
          return
        }
        resolve(res.data)
      })
    })
    return p
  },
  revertPageLog(data) {
    const { sAppCode: sAppCode_, sPage: sPage_, dbName, sControl, version: version_ } = data
    const { appCode, page, dbName: db_Name, db_code } = getPageParms()
    const db_name = dbName || db_Name || ''

    const sAppCode = sAppCode_ || appCode
    const sPage = sPage_ || page || ''
    const version = version_ || ''
    var p = new Promise(function(resolve, reject) {
      const postData = {
        exec_sql: `EXEC dbo.spappWebChartConfig_Revert  @sAppCode='${sAppCode}',@sPageName='${sPage}',@sControlName='${sControl}',@iVersion='${version}'`,
        db_name: db_name,
        db_code
      }
      axios.post(module_url3, postData).then(res => {
        resolve(res.data)
      })
    })
    return p
  },
  getPageInfo(data) {
    const queryString = commonUtility.parseUrlQueryString()
    const { sAppCode: sAppCode_, sPage: sPage_, dbName, control_name, param, return_type } = data
    const { appCode, page, dbName: db_Name, db_code } = getPageParms()
    const db_name = dbName || db_Name || ''
    const sAppCode = sAppCode_ || appCode
    const sPage = sPage_ || page || ''
    const globalParams = commonUtility.parseGlobalParams()
    const user_id = globalParams.user_id || 1
    const type = typeof param
    let _parm = {}
    if (type === 'string') {
      _parm = JSON.parse(param)
    }
    if (type === 'object') {
      _parm = _.cloneDeep(param)
    }
    const param_ = _.cloneDeep(_parm || {})
    param_.menuParam = queryString
    param_.globalParam = globalParams || {}
    const datas = {
      db_name: db_name,
      app_code: sAppCode,
      page: sPage,
      param: JSON.stringify(param_),
      // param: param || '{}',
      control_name,
      return_type: return_type || 3,
      db_code
    }
    if (user_id) {
      datas.user_id = user_id
    }
    var p = new Promise(function(resolve, reject) {
      axios.post(`${module_query_page}`, datas).then(res => {
        if (!res) {
          resolve([])
          return
        }
        if (res && !res.data) {
          resolve([])
          return
        }
        resolve(res.data)
      })
    })
    return p
  },
  getGqlData(data, url = module_Gql_query) {
    const { dbName: db_Name } = getPageParms()
    let url_ = url
    if (!url_.includes('?')) {
      url_ += '?'
    }
    if (!url_.includes('db_name')) {
      if (url_.endsWith('&')) {
        url_ = `${url_}db_name=${db_Name}`
      } else {
        url_ = `${url_}&db_name=${db_Name}`
      }
    }
    return axios.post(url_, data)
  },
  saveGqlData(data, url = module_Gql_query_save) {
    const { dbName: db_Name } = getPageParms()
    let url_ = url
    if (!url.includes('?')) {
      url += '?'
    }
    if (!url.includes('db_name')) {
      url_ = `${url_}?db_name=${db_Name}`
    }
    const data_ = {
      'data': {
        'pbWebDyncCode': data
      }
    }
    return axios.post(url_, data_)
  },
  parseUrlParams(queryParms = {}) {
    const urlQueryParams = commonUtility.parseUrlQueryString()
    let queryParms_str = ''
    if (queryParms && typeof queryParms === 'object') {
      Object.assign(urlQueryParams, queryParms)
    }
    Object.keys(urlQueryParams).forEach(key => {
      if (!tempList.includes(urlQueryParams[key])) {
        queryParms_str += `&${key}=${encodeURIComponent(urlQueryParams[key])}`
      }
    })
    queryParms_str = queryParms_str.substr(1)
    return queryParms_str
  },
  // 通过主键id 来查询值
  queryByParimaryKey(parms) {
    const { tableName, id, appCode: appCode_, queryParms, group, dyncQueryParms } = parms
    const menuParams = getPageParms()
    const appCode__ = appCode_ || menuParams.appCode
    const queryObj = Object.assign({}, queryParms, dyncQueryParms || {})
    const queryParms_str = this.parseUrlParams(queryObj)
    let url_ = `${module_toolAPI}${appCode__}/${tableName}/${id}/`
    if (group) {
      url_ = `${url_}${group}/`
    }
    url_ = `${url_}?` + queryParms_str
    return axios.get(url_)
  },
  // 保存
  save(data) {
    const { tableName, appCode: appCode_, bodyData, group, parms } = data
    const { appCode } = getPageParms()
    const queryParms_str = this.parseUrlParams(parms)
    const appCode__ = appCode_ || appCode
    let url = `${module_toolAPI}${appCode__}/${tableName}/`
    if (group) { // 非标准保存
      url = `${url}${group}/`
    }
    url = url + '?' + queryParms_str
    return axios.post(url, bodyData)
  },
  put(data) {
    const { tableName, appCode: appCode_, bodyData, group, parms } = data
    const { appCode } = getPageParms()
    const queryParms_str = this.parseUrlParams(parms)
    const appCode__ = appCode_ || appCode
    let url = `${module_toolAPI}${appCode__}/${tableName}/`
    if (group) { // 非标准保存
      url = `${url}${group}/`
    }
    url = url + '?' + queryParms_str
    return axios.put(url, bodyData)
  },
  // 查询列表
  queryList(parms) {
    const { tableName, appCode: appCode_, queryParms, group, bodyData } = parms
    const { appCode } = getPageParms()
    const appCode__ = appCode_ || appCode
    const queryParms_str = this.parseUrlParams(queryParms)
    let url_ = `${module_toolAPI}${appCode__}/${tableName}/`
    if (group) {
      url_ = `${url_}${group}/`
    }
    url_ = `${url_}?` + queryParms_str + `&fuzzy=1`
    if (bodyData) {
      return axios.put(url_, bodyData)
    } else {
      return axios.get(url_)
    }
  },
  // 批量删除
  deleteList(parms) {
    const { tableName, appCode: appCode_, bodyData } = parms
    const { appCode } = getPageParms()
    const queryParms_str = this.parseUrlParams()
    const appCode__ = appCode_ || appCode
    const url_ = `${module_toolAPI}${appCode__}/${tableName}/` + '?' + queryParms_str
    return axios.delete(url_, {
      data: bodyData
    })
  },
  importExcel(formData, data) {
    const { table_name, queryParms } = data
    const { appCode, dbName } = getPageParms()
    let strParms = ''
    if (queryParms) {
      const itemParms_ = _.cloneDeep(queryParms)
      const menuGlobalParams = commonUtility.parseUrlQueryString()
      commonUtility.recursiveDyncParam(itemParms_, menuGlobalParams)
      for (const key in itemParms_) {
        strParms += `&${key}=${itemParms_[key]}`
      }
    }
    const url = `${module_toolAPI}${appCode}/${table_name}/import_excel/?db_name=${dbName}${strParms}`
    return axios.post(url, formData)
  },
  getNewId(number) {
    const number_ = number || 100
    return axios.get(module_tool + `common/new_id/${number_}/`)
  },
  importDataIframe(data, parms) {
    const { dbName, appCode } = getPageParms()
    const { table_name, import_name, queryParms } = parms
    let strParms = ''
    if (queryParms) {
      const itemParms_ = _.cloneDeep(queryParms)
      const menuGlobalParams = commonUtility.parseUrlQueryString()
      commonUtility.recursiveDyncParam(itemParms_, menuGlobalParams)
      for (const key in itemParms_) {
        strParms += `&${key}=${itemParms_[key]}`
      }
    }
    const url_ = `${module_toolAPI}${appCode}/${table_name}/${import_name}/?db_name=${dbName}${strParms}`
    return axios.post(url_, data)
  },
  // 单据流控制
  billHandleCommon(obj) {
    const { data, type } = obj
    let url = ''
    switch (type) {
      case 'billAudit':
        url = `${bill_audit_bills}`
        break
      case 'billUnAudit':
        url = `${bill_un_audit_bills}`
        break
      case 'billSend':
        url = `${bill_send_bills}`
        break
      case 'billUnSend':
        url = `${bill_un_send_bills}`
        break
      case 'billClose':
        url = `${bill_close_bills}`
        break
      case 'billUnClose':
        url = `${bill_un_close_bills}`
        break
    }
    return axios.post(url, data)
  },
  queryBillpbWebDyncCode(parms) {
    const { appCode: appCode_, queryParms, tableName } = parms
    const { appCode, page } = getPageParms()
    const appCode__ = appCode_ || appCode
    const queryParms_str = this.parseUrlParams(queryParms)// QueryBI
    let url_ = `${module_toolAPI}queryBi/${tableName}/`
    url_ = `${url_}?` + queryParms_str + '&' + `app_code=${appCode__}&page_name=${page}&usable=1`
    return axios.get(url_)
  },
  // action打印
  printTask(data) {
    const url = `${module_tool}common/print_task/`
    return axios.post(url, data)
  },
  // 默认单据类型打印
  TypePrintTask(data) {
    const url = `${module_tool}common/print_task_by_bill_type/`
    return axios.post(url, data)
  },
  get(url) {
    return axios.get(url)
  },
  // 上传附件
  uploadFile(formData) {
    const { appCode } = getPageParms()
    return axios.post(`fileresourceAPI/file/${appCode}/`, formData)
  }

}
export default API
