
import axios from 'axios'
import { Notification, Loading } from 'element-ui'
import commonUtility from './commonUtility'
import _ from 'lodash'
let fullLoading
function showLoading() {
  fullLoading = Loading.service({
    lock: true,
    text: '加载中...',
    spinner: 'el-icon-loading',
    background: 'rgba(0, 0, 0, 0)'
  })
  setTimeout(_ => {
    fullLoading.close()
  }, 10000)
}
function closeLoading() {
  fullLoading && fullLoading.close()
}
let loading_request_count = 0
function show_full_screen_loading() {
  if (loading_request_count === 0) {
    showLoading()
  }
  loading_request_count++
}
function hide_full_screen_loading() {
  if (loading_request_count <= 0) return
  loading_request_count--
  if (loading_request_count === 0) {
    closeLoading()
  }
}
// 增加一个response拦截器
axios.interceptors.response.use(
  function(response) {
    hide_full_screen_loading()
    if (response.data) {
      const { error_detail, error_title } = response.data
      if (error_title || error_detail) {
        Notification.error({
          title: '错误信息！',
          dangerouslyUseHTMLString: true,
          duration: 100000,
          message: `<div>
          <textarea style="border:0;border-radius:5px;background-color:rgba(241,241,241,.98);width: 300px;height: 400px;padding: 10px;resize: none;position: relative;right: 36px;">
            ${error_title}
            ${error_detail}
          </textarea>
          </div>` // error_detail || error_title,
        })
      } else { // 此处做优化 只有不出错的时候才返回response
        return response
      }
    } else { // 此处做优化 只有不出错的时候才返回response
      return response
    }
  },
  function(error) {
    hide_full_screen_loading()
    dyncInnerErrorDel(error)
    return Promise.reject(error)
  }
)
function dyncInnerErrorDel(error) {
  if (error.message === 'Network Error') {
    Notification.error({
      title: '错误信息！',
      message: '网络连接错误!请检查您的网络是否正常!',
      type: 'warning'
    })
  }
  if (error.response && typeof error.response.data === 'string') {
    Notification.error({
      title: '错误信息！',
      dangerouslyUseHTMLString: true,
      type: 'warning',
      duration: 100000,
      message: `<div>
      <textarea style="border:0;border-radius:5px;background-color:rgba(241,241,241,.98);width: 300px;height: 400px;padding: 10px;resize: none;position: relative;right: 36px;">
        ${error.response.data}
      </textarea>
      </div>`
    })
  }
  if (error.response && typeof error.response.data === 'object') {
    const { error_detail, error_title } = error.response.data
    Notification.error({
      title: '错误信息！',
      dangerouslyUseHTMLString: true,
      duration: 100000,
      message: `<div>
      <textarea style="border:0;border-radius:5px;background-color:rgba(241,241,241,.98);width: 300px;height: 400px;padding: 10px;resize: none;position: relative;right: 36px;">
        ${error_title}
        ${error_detail}
      </textarea>
      </div>`
    })
  }
}
axios.interceptors.request.use(
  config => {
    if (config.url.indexOf('no_loading') !== -1) {
    } else {
      if (config.url.startsWith('http:') || config.url.startsWith('https:')) {
        // 俺啥都不干
      } else {
        config.url = config.url.replace('//', '/')
      }
      show_full_screen_loading()
    }
    if (config.url.includes('?&')) {
      config.url = config.url.replace('?&', '?')
    }
    return config
  },
  err => {
    hide_full_screen_loading()
    return Promise.reject(err)
  }
)

let fi_data = {}
const tempList = [undefined, 'undefined']
// 需要在登录时将db_name、app_code、isMock参数存到session里
// 需要在代理配置mainAPI
const module_url = `mainAPI/web_query/query/`
const module_url2 = `mainAPI/web_query/query_value/`
const module_url3 = `mainAPI/web_query/`
const module_query_page = 'mainAPI/web_chart_config/query_page/'
const emptyList = [undefined, 'undefined', null, 'null', '']
function getPageParms() {
  const { db_name, is_mock, db_code } = commonUtility.parseUrlQueryString()
  const { appCode, pagename } = commonUtility.parseUrlQueryBIDyncAppcodePageName()
  const isMock = emptyList.includes(is_mock) ? 1 : is_mock
  const dbName = db_name || ''
  const obj = _.cloneDeep({
    dbName,
    appCode,
    page: pagename,
    isMock,
    db_code
  })
  return obj
}
const API = {
  runSave(data) { // routerParms: page路由 position位置 other参数, sConfig 配置json sData 数据json
    const { sAppCode: sAppCode_, sPage: sPage_, sControl: sControl_, sConfig, sData, sQuerySql, is_mock, dbName, elInfo } = data
    const control_type = (elInfo && elInfo.el) || ''
    const { appCode, page, isMock, dbName: db_Name, db_code } = getPageParms()
    var p = new Promise(function(resolve, reject) {
      const db_name = dbName || (elInfo && elInfo.db_name) || db_Name || ''
      const sPage = sPage_ || (elInfo && elInfo.page) || page || ''
      const sAppCode = sAppCode_ || (elInfo && elInfo.sAppCode) || appCode
      var sIsMock
      if (parseInt(is_mock) === 0 || parseInt(is_mock) === 1) {
        sIsMock = is_mock
      } else {
        sIsMock = isMock
      }
      const sSQl = sQuerySql || ''
      const sControl = sControl_ || elInfo.position
      const globalParams = commonUtility.parseGlobalParams()
      const user_id = globalParams.user_id || 1
      const postData = {
        exec_sql: `EXEC dbo.spappWebChartConfig_Save @sAppCode='${sAppCode}',@sPage='${sPage}',@sControl='${sControl}',@sControlType='${control_type}',@sConfig=:sConfig,@sData=:sData,@sQuerySql='${sSQl}',@bMockData='${sIsMock}',@iUserId=${user_id}`,
        db_name: db_name,
        db_code,
        param: {
          sConfig: JSON.stringify(sConfig),
          sData: JSON.stringify(sData)
        }
      }
      axios.post(module_url3, postData).then(res => {
        if (!res) return
        if (isMock) {
          const r_d = res.data[0] ? res.data[0].json_data : ''
          if (r_d !== '' && r_d !== undefined) {
            fi_data = JSON.parse(r_d)
            resolve(fi_data)
          } else {
            resolve([])
          }
        } else {
          fi_data = JSON.parse(res.data)
          resolve(fi_data)
        }
      })
    })
    return p
  },
  getSql(data) {
    const { sAppCode: sAppCode_, sPage: sPage_, sControl: sControl_, dbName } = data
    const { appCode, page, dbName: db_Name, db_code } = getPageParms()
    const globalParams = commonUtility.parseGlobalParams()
    const user_id = globalParams.user_id || 1
    var p = new Promise(function(resolve, reject) {
      const db_name = dbName || db_Name || ''
      const sAppCode = sAppCode_ || appCode
      const sPage = sPage_ || page || ''
      const sControl = sControl_
      const postData = {
        exec_sql: `EXEC dbo.spappWebChartConfig_Query @sAppCode='${sAppCode}',@sPage='${sPage}',@sControl='${sControl}',@iUserId='${user_id}'`,
        db_name: db_name,
        db_code
      }
      axios.post(module_url, postData).then(res => {
        resolve(res.data)
      })
    })
    return p
  },
  download(name, data) {
    var urlObject = window.URL || window.webkitURL || window
    var downloadData = new Blob([data])
    var save_link = document.createElementNS('http://www.w3.org/1999/xhtml', 'a')
    save_link.href = urlObject.createObjectURL(downloadData)
    save_link.download = name
    this.fake_click(save_link)
  },
  fake_click(obj) {
    var ev = document.createEvent('MouseEvents')
    ev.initMouseEvent(
      'click', true, false, window, 0, 0, 0, 0, 0
      , false, false, false, false, 0, null
    )
    obj.dispatchEvent(ev)
  },
  downSql(data) {
    const { sAppCode: sAppCode_, sPage: sPage_, dbName } = data
    const { appCode, page, dbName: db_Name, db_code } = getPageParms()
    const db_name = dbName || db_Name || ''
    const sAppCode = sAppCode_ || appCode
    const sPage = sPage_ || page || ''
    const postData = {
      exec_sql: `EXEC dbo.spappWebChartConfig_SaveAs @sAppCode='${sAppCode}',@sPage='${sPage}'`,
      db_name: db_name,
      db_code
    }
    axios.post(module_url2, postData).then(res => {
      if (!res) return
      const r_d = res.data
      this.download(`spappWebChartConfig_Upgrade_${sAppCode}_${sPage}.sql`, r_d)
    })
  },
  execSql(data) {
    var postData = {}
    const { dbName: db_Name, db_code } = getPageParms()
    if (typeof data === 'object') {
      const { sQuerySql, dbName } = data
      const db_name = dbName || db_Name || ''
      postData = {
        exec_sql: sQuerySql,
        db_name,
        db_code
      }
    } else {
      postData = {
        exec_sql: data,
        db_Name,
        db_code
      }
    }
    var p = new Promise(function(resolve, reject) {
      axios.post(module_url, postData).then(res => {
        resolve(res.data)
      })
    })
    return p
  },
  getPageLog(data) {
    const { sAppCode: sAppCode_, sPage: sPage_, dbName, sControl } = data
    const { appCode, page, dbName: db_Name, db_code } = getPageParms()
    const db_name = dbName || db_Name || ''
    const sAppCode = sAppCode_ || appCode
    const sPage = sPage_ || page || ''
    var p = new Promise(function(resolve, reject) {
      const postData = {
        exec_sql: `EXEC dbo.spappWebChartConfig_QueryLog  @sAppCode='${sAppCode}',@sPageName='${sPage}',@sControlName='${sControl}'`,
        db_name: db_name,
        db_code
      }
      axios.post(module_url, postData).then(res => {
        if (!res) {
          resolve([])
          return
        }
        if (res && !res.data) {
          resolve([])
          return
        }
        resolve(res.data)
      })
    })
    return p
  },
  revertPageLog(data) {
    const { sAppCode: sAppCode_, sPage: sPage_, dbName, sControl, version: version_ } = data
    const { appCode, page, dbName: db_Name, db_code } = getPageParms()
    const db_name = dbName || db_Name || ''

    const sAppCode = sAppCode_ || appCode
    const sPage = sPage_ || page || ''
    const version = version_ || ''
    var p = new Promise(function(resolve, reject) {
      const postData = {
        exec_sql: `EXEC dbo.spappWebChartConfig_Revert  @sAppCode='${sAppCode}',@sPageName='${sPage}',@sControlName='${sControl}',@iVersion='${version}'`,
        db_name: db_name,
        db_code
      }
      axios.post(module_url3, postData).then(res => {
        resolve(res.data)
      })
    })
    return p
  },
  getPageInfo(data) {
    const queryString = commonUtility.parseUrlQueryString()
    const { sAppCode: sAppCode_, sPage: sPage_, dbName, control_name, param, return_type } = data
    const { appCode, page, dbName: db_Name, db_code } = getPageParms()
    const db_name = dbName || db_Name || ''
    const sAppCode = sAppCode_ || appCode
    const sPage = sPage_ || page || ''
    const globalParams = commonUtility.parseGlobalParams()
    const user_id = globalParams.user_id || 1
    const type = typeof param
    let _parm = {}
    if (type === 'string') {
      _parm = JSON.parse(param)
    }
    if (type === 'object') {
      _parm = _.cloneDeep(param)
    }
    const param_ = _.cloneDeep(_parm || {})
    param_.menuParam = queryString
    param_.globalParam = globalParams || {}
    const datas = {
      db_name: db_name,
      app_code: sAppCode,
      page: sPage,
      param: JSON.stringify(param_),
      control_name,
      return_type: return_type || 3,
      db_code
    }
    if (user_id) {
      datas.user_id = user_id
    }
    var p = new Promise(function(resolve, reject) {
      axios.post(`${module_query_page}`, datas).then(res => {
        if (!res) {
          resolve([])
          return
        }
        if (res && !res.data) {
          resolve([])
          return
        }
        resolve(res.data)
      })
    })
    return p
  },
  // 上传附件
  uploadFile(formData) {
    const { appCode } = getPageParms()
    return axios.post(`fileresourceAPI/file/${appCode}/`, formData)
  }

}
export default API
