const path = require('path')
let api = '47.110.145.204:59168' // 代理服务器地址
const mainAPI = `http://${api}/Tool/api/`
const mockAPI = 'http://47.110.145.204:8082/mock/203'
const authAPI = `http://${api}/HSRight/api/`
const menuAPI = 'http://localhost:3000'
const GQLAPI = `http://${api}/GQL/api/`
const toolAPI = `http://${api}/Tool/api/`
const commonUtilAPI=`http://${api}/CommonUtil/api/`
const ipCommonAPI=`http://${api}/`
const fileresourceAPI=`http://${api}/fileresource/api/`
module.exports = {  
  // 部署应用包时的基本 URL,用法和 webpack 本身的 output.publicPath 一致
  publicPath: './',  
  // 输出文件目录
  outputDir: 'lib',  
  // eslint-loader 是否在保存的时候检查
  lintOnSave: true,  
  // 是否使用包含运行时编译器的 Vue 构建版本
  runtimeCompiler: false,  
  // 生产环境是否生成 sourceMap 文件
  productionSourceMap: false,  
  // 生成的 HTML 中的 <link rel="stylesheet"> 和 <script> 标签上启用 Subresource Integrity (SRI)
  integrity: false,  
  // webpack相关配置
  chainWebpack: (config) => {
    config.resolve.alias
      .set('vue$', 'vue/dist/vue.esm.js')
      .set('@', path.resolve(__dirname, './src'))
  },
  configureWebpack: (config) => {    
  if (process.env.NODE_ENV === 'production') {      
      // 生产环境
      config.mode = 'production'
    } else {      
      // 开发环境
      config.mode = 'development'
    }
  },  
  // css相关配置
  css: {    
    // 是否分离css（插件ExtractTextPlugin）
    extract: true,    
    // 是否开启 CSS source maps
    sourceMap: false,   
    // css预设器配置项
    loaderOptions: {},    
    // 是否启用 CSS modules for all css / pre-processor files.
    requireModuleExtension: true
  },  
  // 是否使用 thread-loader
  parallel: require('os').cpus().length > 1, 
  // PWA 插件相关配置
  pwa: {}, 
  // webpack-dev-server 相关配置
  devServer: {
    open: true,
    host: 'localhost',
    port: 8080,
    https: false,
    hotOnly: false,   
    // http 代理配置
    proxy: {
      '/fileresourceAPI': {
        target: fileresourceAPI,
        changeOrigin: true,
        pathRewrite: {
          '^/fileresourceAPI': ''
        }
      },
      '/GQLAPI': {
        target: GQLAPI,
        changeOrigin: true,
        pathRewrite: {
          '^/GQLAPI': ''
        }
      },
      '/mainAPI': {
        target: mainAPI,
        changeOrigin: true,
        pathRewrite: {
          '^/mainAPI': ''
        }
      },
      '/menuAPI': {
        target: menuAPI,
        changeOrigin: true,
        pathRewrite: {
          '^/menuAPI': ''
        }
      },
      '/mockAPI': {
        target: mockAPI,
        changeOrigin: true,
        pathRewrite: {
          '^/mockAPI': ''
        }
      },
      '/authAPI': {
        target: authAPI,
        changeOrigin: true,
        pathRewrite: {
          '^/authAPI': ''
        }
      },
      '/toolAPI': {
        target: toolAPI,
        changeOrigin: true,
        pathRewrite: {
          '^/toolAPI': ''
        }
      },
      '/commonUtilAPI': {
        target: commonUtilAPI,
        changeOrigin: true,
        pathRewrite: {
          '^/commonUtilAPI': ''
        }
      },
      '/ipCommonAPI': {
        target: ipCommonAPI,
        changeOrigin: true,
        pathRewrite: {
          '^/ipCommonAPI': ''
        }
      }
    },
    before: (app) => {}
  }, 
  // 第三方插件配置
  pluginOptions: {

  }
}