import axios from 'axios'
import _ from 'lodash'
export default {
  data () {
    return {
      config: {
        'url': '',
        'ref': {
          const_id: '0',
          table_name: '',
          columns: '',
          remote_condition: '',
          displayfield: '',
          writebackfield: []
        },
        dyncQueryParms: {},
        multiple: false,
        disabled: false,
        size: 'mini',
        clearable: true,
        title: '',
        placeholder: '',
        value: '',
        label: '',
        is_computed: false
      }
    }
  },
  methods: {
    async requestMethod (config, value) {
      const { ref, dyncQueryParms } = config || {}
      const { remote_condition } = ref || {}
      let real_url = this.initRealUrl(config)
      if (!real_url) return []
      let remote_condition_ = remote_condition.trim()
      let parms = ''
      const dyncQueryParms_ = _.cloneDeep(dyncQueryParms || {})
      if (value) {
        dyncQueryParms_[remote_condition_] = value.trim()
      }
      for (const key in dyncQueryParms_) {
        if (key === remote_condition) {
          parms += `&${key}=${encodeURIComponent('%' + dyncQueryParms_[key] + '%')}`
        } else {
          parms += `&${key}=${encodeURIComponent(dyncQueryParms_[key])}`
        }
      }
      if (real_url.includes('?')) {
        real_url += parms
      } else {
        real_url += '?' + parms
      }
      const type = typeof value
      if (type === 'undefined' && remote_condition_) {// 远程搜索的时候
        return []
      } else {
        const res = await axios.get(real_url)
        const options = Array.isArray(res.data)
          ? this.tansLate(res.data, config)
          : this.translate_json(res.data)
        return options
      }

    },
    tansLate (data, config) {
      const arr = data
      const list = []
      const { value, label } = config
      arr.forEach(element => {
        const parm = {}
        for (const pro in element) {
          if (pro === value && value === label) {
            parm.value = element[pro]
            parm.label = element[pro]
          } else if (pro === value) {
            parm.value = element[pro]
          } else if (pro === label) {
            parm.label = element[label]
          }
          parm[pro] = element[pro]
        }
        list.push(parm)
      })

      return list
    },
    initRealUrl (config) {
      const { url, ref, proxyTag } = config
      const { const_id, table_name, columns, remote_condition } = ref
      const url_dynamic = `${proxyTag}/ref/table`
      const url_static = `${proxyTag}/ref/items`
      if (remote_condition) {
        if (table_name) {
          return `${url_dynamic}/${table_name}/${columns}/`
        } else {
          return `${url}`
        }
      } else {
        if (const_id && Number(const_id) !== 0) {
          return `${url_static}/${const_id}/`
        } else if (table_name) {
          return `${url_dynamic}/${table_name}/${columns}/`
        } else {
          return url
        }
      }
    },
    uploadFileFun(appCode,formData) {
      return axios.post(`fileresourceAPI/file/${appCode}/`, formData)
    }
  },
}
