// dialog.js
import Vue from 'vue'
function makeDialog(option) {
  var dom = document.createElement('div')
  document.getElementsByTagName('body')[0].appendChild(dom)
  const tpl = `
        <el-dialog 
            :close-on-click-modal="false"
            :custom-class="customClass"
            :title="title"
            :visible.sync="show"
            :size="size"
            :before-close="handleClose"
            @close="close">
                <dialogContent  @close="closeDialog" @confirm="confirmDialog" v-model="dialogData"></dialogContent>
        </el-dialog>`
  var vue = new Vue({
    el: dom,
    data: function() {
      return {
        title: option.title,
        size: option.size || 'small',
        show: true,
        dialogData: option.data
      }
    },
    template: tpl,
    computed: {
      customClass() {
        return `el-dialog--width-${option.size || 'auto'}`
      }
    },
    methods: {
      handleClose(done) {
        if (option.beforeClose) {
          option.beforeClose(done)
        } else {
          done()
        }
      },
      close() {
        if (option.close) {
          option.close()
        }
      },

      closeDialog() {
        this.show = false
      },
      confirmDialog(result) {
        this.show = false
        option.confirm && option.confirm(result)
      }
    },
    components: {
      dialogContent: option.component
    }
  })
  return vue
}

export default {
  open(options) {
    return makeDialog(options)
  }
}
