// 折线图和柱状图原始配置和数据
const initLineBar = {
  config: {
    isTransverse: false,
    'title': {
      'text': '标题（模拟数据）',
      'left': 'center',
      'textStyle': {
        'color': '#a2a3e3',
        'fontSize': 20
      }
    },
    'tooltip': {
      'trigger': 'axis'
    },
    'grid': {
      'left': '10',
      'right': '20',
      'bottom': '20',
      'top': '40',
      'containLabel': true
    },
    'xAxis': {
      'name': '',
      'nameLocation': 'end',
      'axisLine': {
        'show': true,
        'lineStyle': {
          'color': '#a2a3e3'
        }
      },
      'data': [
        'DKN1',
        'DKN2',
        'DKN3',
        'DKN4',
        'DKN5'
      ]
    },
    'yAxis': [
      {
        'show': true,
        'type': 'value',
        'name': '%',
        'nameLocation': 'end',
        'min': null,
        'max': null,
        'splitNumber': 5,
        'axisLine': {
          'show': true,
          'lineStyle': {
            'color': '#a2a3e3'
          }
        },
        'axisTick': {
          'show': true
        },
        'axisLabel': {
          'show': true
        },
        'splitLine': {
          'lineStyle': {
            'color': '#282953'
          }
        }
      }
    ],
    'legend': {
      'show': false,
      'orient': 'horizontal',
      'bottom': '0',
      'textStyle': {
        'fontSize': 12
      },
      'data': [
        '计划数',
        '完成数'
      ]
    },
    'series': [
      {
        'name': '计划数',
        'type': 'bar',
        'yAxisIndex': 0,
        'barWidth': '12',
        'stack': '这个值相同的话 就会叠加',
        'data': [],
        'itemStyle': {
          'color': {
            'x': 0,
            'y': 0,
            'x2': 0,
            'y2': 1,
            'type': 'linear',
            'global': false,
            'colorStops': [
              {
                'offset': 0,
                'color': '#436EEE'
              },
              {
                'offset': 1,
                'color': '#8B2252'
              }
            ]
          },
          'barBorderRadius': [
            10,
            10,
            0,
            0
          ],
          'hsColor': [
            '#4fcee4',
            '#ab5ee2'
          ]
        },
        'label': {
          'show': true,
          'position': 'top',
          'color': '#8888b0',
          'fontSize': 12
        },
        'xData': []
      },
      {
        'name': '完成数',
        'type': 'bar',
        'yAxisIndex': 0,
        'barWidth': '12',
        'data': [],
        'itemStyle': {
          'color': {
            'x': 0,
            'y': 0,
            'x2': 0,
            'y2': 1,
            'type': 'linear',
            'global': false,
            'colorStops': [
              {
                'offset': 0,
                'color': '#436EEE'
              },
              {
                'offset': 1,
                'color': '#8B2252'
              }
            ]
          },
          'barBorderRadius': [
            10,
            10,
            0,
            0
          ],
          'hsColor': [
            '#4fcee4',
            '#ab5ee2'
          ]
        },
        'label': {
          'show': true,
          'position': 'top',
          'color': '#8888b0',
          'fontSize': 12
        },
        'xData': []
      },
      {
        'name': 'G04',
        'type': 'bar',
        'yAxisIndex': 0,
        'barWidth': '12',
        'stack': '这个值相同的话 就会叠加',
        'data': [],
        'itemStyle': {
          'color': {
            'x': 0,
            'y': 0,
            'x2': 0,
            'y2': 1,
            'type': 'linear',
            'global': false,
            'colorStops': [
              {
                'offset': 0,
                'color': '#436EEE'
              },
              {
                'offset': 1,
                'color': '#8B2252'
              }
            ]
          },
          'barBorderRadius': [
            10,
            10,
            0,
            0
          ],
          'hsColor': [
            '#4fcee4',
            '#ab5ee2'
          ]
        },
        'label': {
          'show': true,
          'position': 'top',
          'color': '#8888b0',
          'fontSize': 12
        },
        'xData': []
      }
    ]
  },
  sourceData: [
    {
      'sSeries': '计划数',
      'sName': '五车间',
      'dValue': '15',
      'sShowValue': '15'
    },
    {
      'sSeries': '计划数',
      'sName': '六车间',
      'dValue': '28',
      'sShowValue': '28'
    },
    {
      'sSeries': '计划数',
      'sName': '七车间',
      'dValue': '31',
      'sShowValue': '31'
    },
    {
      'sSeries': '计划数',
      'sName': '八车间',
      'dValue': '45',
      'sShowValue': '45'
    },
    {
      'sSeries': '计划数',
      'sName': '九车间',
      'dValue': '57',
      'sShowValue': '57'
    },
    {
      'sSeries': '计划数',
      'sName': '十一车间',
      'dValue': '98',
      'sShowValue': '98'
    },
    {
      'sSeries': '完成数',
      'sName': '五车间',
      'dValue': '45',
      'sShowValue': '45'
    },
    {
      'sSeries': '完成数',
      'sName': '六车间',
      'dValue': '48',
      'sShowValue': '48'
    },
    {
      'sSeries': '完成数',
      'sName': '七车间',
      'dValue': '41',
      'sShowValue': '41'
    },
    {
      'sSeries': '完成数',
      'sName': '八车间',
      'dValue': '60',
      'sShowValue': '60'
    },
    {
      'sSeries': '完成数',
      'sName': '九车间',
      'dValue': '39',
      'sShowValue': '39'
    },
    {
      'sSeries': '完成数',
      'sName': '十一车间',
      'dValue': '39',
      'sShowValue': '39'
    }
  ]
}
// 饼图
const initPie = {
  config: {
    tooltip: {
      trigger: 'item',
      formatter: '{a} <br/>{b}: {c} ({d}%)'
    },
    legend: {
      orient: 'vertical',
      x: 'left',
      data: ['测试1', '测试2']
    },
    color: ['#F5D423', '#47FE75', '#47FDFE', '#325AF0', '#8266F5', '#C566F5', '#F566B5', '#F56666', '#F58566', '#F5A623'],
    calculable: true,
    graphic: [
      { // 设置饼状图内部文字
        type: 'text',
        left: 'center', // 设置偏移量
        top: 180,
        z: 2
      }
    ],
    series: [{
      name: '访问来源',
      type: 'pie',
      radius: ['45%', '70%'],
      itemStyle: {
        normal: {
          label: {
            show: true,
            position: 'outer',
            formatter: params => {
              return params.data.name
            }
          },
          labelLine: {
            show: false,
            length: 2
          }
        }
      },
      data: []
    }]
  },
  sourceData: [
    {
      name: '测试1',
      sName: '上衣',
      dValue: 30,
      msg: '测试1',
      sSeries: '访问来源',
      sLegendData: ''
    },
    {
      name: '测试2',
      sName: '裤子2',
      dValue: 25,
      msg: '测试2',
      sSeries: '访问来源',
      sLegendData: ''
    }]
}
// 雷达图
const initRadar = {
  config: {
    grid: {
      left: '20',
      right: '10',
      bottom: '2',
      top: '20',
      containLabel: true
    },
    title: {
      text: '面料（米）',
      bottom: '10px',
      left: 'center',
      textStyle: {
        fontSize: 20,
        color: '#A48463',
        fontFamily: 'myFont',
        fontWeight: 400
      }
    },
    tooltip: {
      trigger: 'axis'
    },
    radar: [{
      triggerEvent: true,
      shape: 'circle',
      center: ['50%', '50%'],
      radius: '55%',
      splitNumber: 4,
      nameGap: 35,
      name: {
        textStyle: {
          fontFamily: 'myFont',
          color: '#A48463',
          fontSize: '20'
        }
      },
      label: { // 坐标轴文本标签，详见axis.axisLabel
        show: true,
        textStyle: {
          color: '#FFC774' // 坐标轴刻度文字的样式
        }
      },
      splitArea: {
        show: false,
        areaStyle: {
          color: 'rgba(167,134,99,0.9)' // 图表背景网格的颜色
        }
      },
      splitLine: {
        show: true,
        lineStyle: {
          width: 1,
          color: '#A48463' // 图表背景网格线的颜色
        }
      },
      indicator: [{
        text: '来料',
        max: 10000
      },
      {
        text: '裁剪入库',
        max: 10000
      },
      {
        text: '裁剪下线',
        max: 10000
      },
      {
        text: '已裁',
        max: 10000
      },
      {
        text: '已领',
        max: 10000
      }
      ]
    }],
    calculable: true,
    series: [{
      name: '雷达图',
      type: 'radar',
      data: [],
      itemStyle: {
        normal: {
          lineStyle: {
            width: 1,
            color: '#FFC774' // 图表中各个图区域的边框线颜色
          },
          areaStyle: {
            type: 'default',
            color: '#6495ED',
            opacity: 0.4
          }
        }
      },
      label: {
        normal: {
          show: true,
          position: 'outer',
          textStyle: {
            color: '#6495ED',
            fontSize: 18
          }
        }
      }
    }]
  },
  sourceData: [{
    sSeries: '雷达图',
    dValue: [10000, 4000, 3000, 3100, 4000]
  }]
}
const hsSelectPlus = {
  config: {
    'url': '',
    'ref': {
      const_id: '0',
      table_name: '',
      columns: '',
      remote_condition: '',
      displayfield: '',
      writebackfield: []
    },
    dyncQueryParms: {},
    multiple: false,
    disabled: false,
    size: 'mini',
    clearable: true,
    title: '',
    placeholder: '',
    value: '',
    label: '',
    is_computed: false,
    备注: '(url:完整的请求链接,const_id:常量ID,table_name:表名,columns:查询的字段名,remote_condition:远程搜索条件,displayfield:默认字段,writebackfield:回写字段,value:回写给绑定字段的值,label:给用户看到的值;);(优先级:const_id>table_name>url)'
  },
  sourceData: [
    {
      value: '选项1',
      label: '黄金糕'
    }, {
      value: '选项2',
      label: '双皮奶'
    }
  ]
}
const hsTableImport = {
  sourceData: {
    'paging': {
      'page': 1,
      'per_page': 10,
      'total': 78
    },
    'total': [
      {
        '任务数': '1000',
        '完成数': 6600
      }
    ],
    'table': [
      {
        'name': '海宁安正1',
        'age': 18,
        '计划数/完成数__2019-08-14': '0/0',
        '计划数/完成数__2019-08-15': '60/0'
      },
      {
        'name': '海宁安正2',
        'age': 18,
        '计划数/完成数__2019-08-14': '0/0',
        '计划数/完成数__2019-08-15': '60/0'
      }
    ]
  },
  config: {
    'hsConfig': {
      'default_type': 1
    },
    'isAdaptive': true,
    'showHandle': false,
    disaledDblClick: false,
    handleWidth: 80,
    selection: false,
    showIndex: true,
    isShowTools: false,
    'toolItems': [
      {
        label: '表格列设置',
        isHide: false,
        click: '$tableColumnSet',
        disabled: false
      }
    ],
    'columnsConfig': [
      {
        'label': '测试列1',
        'prop': 'name',
        'showOverflowTooltip': true
      },
      {
        'label': '测试列2',
        'prop': 'age',
        'showOverflowTooltip': true
      }
    ]
  }
}
// 表格模拟数据
const hsTableImportList = {
  sourceData: {
    'paging': {
      'page': 1,
      'per_page': 10,
      'total': 78
    },
    'total': [
      {
        '客户': '1000',
        '款式': 6600
      }
    ],
    'table': [
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣'

      },
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣'

      }
    ]
  },
  config: {
    'hsConfig': {
      'default_type': 1
    },
    'isAdaptive': true,
    'showHandle': false,
    disaledDblClick: false,
    handleWidth: 80,
    selection: true,
    showIndex: true,
    isShowTools: true,
    'toolItems': [
      {
        label: '表格列设置',
        isHide: false,
        click: '$tableColumnSet',
        disabled: false
      }
    ],
    'columnsConfig': [
      {
        'label': '测试列1',
        'prop': '客户',
        'showOverflowTooltip': true
      },
      {
        'label': '测试列2',
        'prop': '客户',
        'showOverflowTooltip': true
      }
    ]
  }
}
// 表格模拟数据
const hsTableList = {
  sourceData: {
    'paging': {
      'page': 1,
      'per_page': 10,
      'total': 78
    },
    'total': [
      {
        '客户': '1000',
        '款式': 6600
      }
    ],
    'table': [
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣'

      },
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣'

      }
    ]
  },
  config: {
    'hsConfig': {
      'default_type': 1
    },
    'isAdaptive': true,
    'showHandle': false,
    disaledDblClick: false,
    handleWidth: 80,
    selection: false,
    showIndex: true,
    isShowTools: true,
    exportExcelName: '导出表的名字',
    'toolItems': [
      {
        label: '导出本页',
        isHide: false,
        click: '$exportCurrPageData',
        disabled: false
      }, {
        label: '导出全部',
        isHide: false,
        click: '$exportAllPageData',
        disabled: false
      }, {
        label: '表格列设置',
        isHide: false,
        click: '$tableColumnSet',
        disabled: false
      }
    ],
    'columnsConfig': [
      {
        'label': '测试列1',
        'prop': '客户',
        'showOverflowTooltip': true
      },
      {
        'label': '测试列2',
        'prop': '客户',
        'showOverflowTooltip': true
      }
    ]
  }
}
const hsTableDtl = {
  sourceData: {
    'paging': {
      'page': 1,
      'per_page': 10,
      'total': 78
    },
    'total': [
      {
        '客户': '1000',
        '款式': 6600
      }
    ],
    'table': [
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣'

      },
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣'

      }
    ]
  },
  config: {
    'hsConfig': {
      'default_type': 1
    },
    'isAdaptive': true,
    'showHandle': false,
    disaledDblClick: false,
    handleWidth: 80,
    selection: false,
    showIndex: true,
    isShowTools: true,
    exportExcelName: '导出表的名字',
    'toolItems': [
      {
        label: '导出本页',
        isHide: false,
        click: '$exportCurrPageData',
        disabled: false
      }, {
        label: '导出全部',
        isHide: false,
        click: '$exportAllPageData',
        disabled: false
      }, {
        label: '表格列设置',
        isHide: false,
        click: '$tableColumnSet',
        disabled: false
      },
      {
        label: '新增行',
        isHide: false,
        click: '$addRow',
        disabled: false
      }, {
        label: '删除行',
        isHide: false,
        click: '$deleteRow',
        disabled: false
      }
    ],
    'columnsConfig': [
      {
        'label': '测试列1',
        'prop': '客户',
        'showOverflowTooltip': true
      },
      {
        'label': '测试列2',
        'prop': '客户',
        'showOverflowTooltip': true
      }
    ]
  }
}
// 表格模拟数据
const hsTable = {
  sourceData: {
    'paging': {
      'page': 1,
      'per_page': 10,
      'total': 78
    },
    'total': [
      {
        '任务数': '1000',
        '完成数': 6600
      }
    ],
    'table': [
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣',
        '订单号': '3204HT190771',
        '批次': '3204HT',
        '颜色': '缺省',
        '尺码': '缺省',
        '班组': '二组',
        '任务数': 230,
        '完成数': 660,
        '计划数/完成数__2019-08-14': '0/0',
        '计划数/完成数__2019-08-15': '60/0',
        '计划数/完成数__2019-08-16': '0/98',
        '计划数/完成数__2019-08-17': '60/98',
        '计划数/完成数__2019-08-18': '60/50',
        '计划数/完成数__2019-08-19': '0/60'
      },
      {
        '客户': '海宁安正',
        '款式': '002b-5春秋夹工作服上衣',
        '订单号': '3204HT190771',
        '批次': '3204HT',
        '颜色': '缺省',
        '尺码': '缺省',
        '班组': '二组',
        '任务数': 230,
        '完成数': 660,
        '计划数/完成数__2019-08-14': '0/0',
        '计划数/完成数__2019-08-15': '60/0',
        '计划数/完成数__2019-08-16': '0/98',
        '计划数/完成数__2019-08-17': '60/98',
        '计划数/完成数__2019-08-18': '60/50',
        '计划数/完成数__2019-08-19': '0/60'
      }
    ]
  },
  config: {
    'hsConfig': {
      'default_type': 1
    },
    'isAdaptive': true,
    'showHandle': false,
    disaledDblClick: false,
    handleWidth: 80,
    selection: false,
    showIndex: true,
    isShowTools: true,
    exportExcelName: '导出表的名字',
    toolItems: [{
      label: '导出本页',
      isHide: false,
      click: '$exportCurrPageData',
      disabled: false
    }, {
      label: '导出全部',
      isHide: false,
      click: '$exportAllPageData',
      disabled: false
    }, {
      label: '表格列设置',
      isHide: false,
      click: '$tableColumnSet',
      disabled: false
    }],
    'columnsConfig': [
      {
        'label': '测试列1',
        'prop': '客户',
        'showOverflowTooltip': true
      },
      {
        'label': '测试列2',
        'prop': '客户',
        'showOverflowTooltip': true
      }
    ]
  }
}
const hsAction = {
  sourceData: [],
  config: {
    text: '按钮',
    'buttonProps': {
      'size': 'mini'
    }
  }
}
const hsInput = {
  sourceData: [],
  config: {
    title: '标题1'
  }
}
const hsDivider = {
  sourceData: [],
  config: {
    direction: 'horizontal',
    contentPosition: 'left'
  }
}
const hsDatePicker = {
  config: {
    'title': '标题',
    'type': 'daterange',
    'valueFormat': 'yyyy-MM-dd',
    'rangeSeparator': '至',
    'startPlaceholder': '开始日期',
    'endPlaceholder': '结束日期'
  },
  sourceData: []
}
const hsTags = {
  config: {
    'size': 'medium'
  },
  sourceData: [
    {
      'title': '数学',
      'type': 'primary'
    },
    {
      'title': '语文',
      'type': 'primary'
    },
    {
      'title': '美术',
      'type': 'primary'
    },
    {
      'title': '英语',
      'type': 'primary'
    }
  ]
}
const hsCheckbox = {
  config: {
    title: '标题'
  },
  sourceData: []
}
const hsTree = {
  config: {
    defaultProps: {
      children: 'children',
      label: 'label'
    }
  },
  sourceData: [{
    label: '一级 1',
    children: [{
      label: '二级 1-1',
      children: [{
        label: '三级 1-1-1'
      }]
    }]
  }, {
    label: '一级 2',
    children: [{
      label: '二级 2-1',
      children: [{
        label: '三级 2-1-1'
      }]
    }, {
      label: '二级 2-2',
      children: [{
        label: '三级 2-2-1'
      }]
    }]
  }]
}
const hsDyncFormComponent = {
  height: '130px',
  config: {
    'formColumn': [
      {
        'type': 'input',
        'label': '标题1',
        'prop': 'title1',
        labelWidth: 120
      },
      {
        'type': 'input',
        'label': '标题2',
        'prop': 'title2',
        labelWidth: 120,
        'isMoreSearch': true
      }
    ]
  },
  sourceData: []
}
const hsPageConfigSingle = {
  config: {
    'entity': {
      'index': {
        'width': '220px',
        'group': 'Tree',
        'isHideQueryZoneButtonTools': true,
        'isShowEdiAreaTree': true,
        'defaultProps': {
          'children': 'childs',
          'label': ''
        },
        'isTree': true,
        'table_name': '',
        'primaryKey': 'id',
        'dyncQueryParms': {},
        'indexTitle': ''
      },
      'main': {
        enableBillFlowType: true,
        queryDefault: {},
        isTreeLastLevelAdd: false,
        'isHideQueryZone': false,
        'group': '',
        'table_name': '',
        'primaryKey': 'id',
        'dyncQueryParms': {
        },
        'importInfo': [
          {
            label: '导入',
            url: '',
            import_name: '',
            parms: {},
            click: '$dataImportItem',
            saveParms: {},
            remark: 'url为空-excel导入,否则为-数据导入!parms传给导入界面的查询参数,saveParms导入过程的保存参数'
          }
        ]
      }
    },
    'new_default': {
      'main': {
        'columns': {
        }
      }
    }
  },
  sourceData: []
}
const hsPageConfigHdrDtl = {
  config: {
    'entity': {
      'main': {
        'bill_type': '',
        'enableBillFlowType': true,
        'table_name': '',
        'primaryKey': 'id',
        'dyncQueryParms': {}
      },
      'dtl': {
        'autoAddEmpty': true,
        'showQueryComponent': false,
        'table_name': '',
        'primaryKey': 'id',
        'dyncQueryParms': {},
        'importInfo': [
          {
            'label': '导入',
            'url': '',
            'import_name': '',
            'parms': {},
            'saveParms': {},
            'remark': 'url为空-excel导入,否则为-数据导入!parms传给导入界面的查询参数,saveParms导入过程的保存参数'
          }
        ]
      }
    },
    'new_default': {
      'main': {
        'columns': {}
      },
      'dtl': {
        'columns': {}
      }
    }
  },
  sourceData: []
}
const hsPageConfigBill = {
  config: {
    'entity': {
      'index': {
        'width': '220px',
        'group': 'Tree',
        'isHideQueryZoneButtonTools': true,
        'defaultProps': {
          'children': 'childs',
          'label': ''
        },
        'isTree': true,
        'table_name': '',
        'primaryKey': 'id',
        'dyncQueryParms': {},
        'indexTitle': ''
      },
      'main': {
        queryDefault: {},
        'isHideQueryZone': false,
        'group': '',
        'table_name': '',
        'primaryKey': 'id',
        'detailPath': '',
        'detailName': '',
        detailDyncQueryParms: {},
        'dyncQueryParms': {
        },
        'dtlList': [
          {
            'label': '字表1',
            isHide: false,
            'url': '/DyncUI/HdrDtl/PBOrg/im_arrive_dtl'
          },
          {
            'label': '字表2',
            isHide: false,
            'url': '/DyncUI/HdrDtl/PBOrg/im_arrive_dtl1'
          }
        ],
        'importInfo': [
          {
            'label': '导入',
            url: '',
            import_name: '',
            parms: {},
            saveParms: {},
            remark: 'url为空-excel导入,否则为-数据导入!'
          }
        ]
      }
    },
    'new_default': {
      'main': {
        'columns': {
        }
      }
    }
  },
  sourceData: []
}
const hsPageConfig = {
  config: {
    'entity': {
      'index': {
        'width': '220px',
        'group': 'Tree',
        'isHideQueryZoneButtonTools': true,
        'defaultProps': {
          'children': 'childs',
          'label': 'department_name'
        },
        'isTree': true,
        'table_name': '',
        'primaryKey': 'id',
        'dyncQueryParms': {},
        'indexTitle': '部门'
      },
      'main': {
        'isHideQueryZone': false,
        'group': '',
        'table_name': '',
        'primaryKey': 'id',
        'detailPath': '/DyncUI/HdrDtl/PBOrg/im_arrive_dtl',
        'detailName': '到货单详情',
        'dyncQueryParms': {
        },
        'dtlList': [
          {
            'detailName': '字表1',
            'detailPath': '/DyncUI/HdrDtl/PBOrg/im_arrive_dtl'
          }
        ]
      },
      'dtl': {
        'group': '',
        'table_name': '',
        'primaryKey': 'id',
        'dyncQueryParms': {
        }
      }
    },
    'new_default': {
      'main': {
        'columns': {
        }
      }
    }
  },
  sourceData: []
}
const hsButtonToolsSingleMain = {
  config: {
    'buttonList': [
      {
        'label': '',
        'icon': 'el-icon-search',
        'click': '$search',
        'isMore': false,
        'isHide': true
      },
      {
        'label': '',
        'icon': 'el-icon-plus',
        'click': '$add',
        'isMore': false,
        'isHide': false
      },
      {
        'label': '',
        'icon': 'el-icon-delete',
        'click': '$delete',
        'isMore': false,
        'isHide': false
      },
      {
        'label': '配置',
        'icon': '',
        'click': '$setPageConfig',
        'isHide': false,
        'isMore': true
      },
      {
        'label': 'Action',
        'icon': '',
        'click': '$setAction',
        'isHide': false,
        'isMore': true
      }
    ]
  },
  sourceData: []
}
const hsButtonToolsBillIndex = {
  config: {
    'buttonList': [
      {
        'label': '',
        'icon': 'el-icon-refresh',
        'click': '$refresh',
        'isMore': false,
        'isHide': false
      },
      {
        'label': '',
        'icon': 'el-icon-plus',
        'click': '$add',
        'isMore': false,
        'isHide': false
      },
      {
        'label': '',
        'icon': 'el-icon-edit',
        'click': '$edit',
        'isMore': false,
        'isHide': true
      },
      {
        'label': '',
        'icon': 'el-icon-delete',
        'click': '$delete',
        'isMore': false,
        'isHide': false
      }
    ]
  },
  sourceData: []
}
const hsButtonToolsBillMain = {
  config: {
    'buttonList': [
      {
        'label': '',
        'icon': 'el-icon-search',
        'click': '$search',
        'isMore': false,
        'isHide': true
      },
      {
        'label': '',
        'icon': 'el-icon-plus',
        'click': '$add',
        'isMore': false,
        'isHide': false
      },
      {
        'label': '',
        'icon': 'el-icon-delete',
        'click': '$delete',
        'isMore': false,
        'isHide': false
      },
      {
        'label': '审核',
        'icon': '',
        'click': '$billAudit',
        'isMore': true,
        'isHide': false
      },
      {
        'label': '取消审核',
        'icon': '',
        'click': '$billUnAudit',
        'isMore': true,
        'isHide': false
      },

      {
        'label': '关闭',
        'icon': '',
        'click': '$billClose',
        'isMore': true,
        'isHide': false
      },
      {
        'label': '取消关闭',
        'icon': '',
        'click': '$billUnClose',
        'isMore': true,
        'isHide': false
      },
      {
        'label': '配置',
        'icon': '',
        'click': '$setPageConfig',
        'isHide': false,
        'isMore': true
      },
      {
        'label': 'Action',
        'icon': '',
        'click': '$setAction',
        'isHide': false,
        'isMore': true
      }
    ]
  },
  sourceData: []
}
const hsButtonToolsHdrDtl = {
  config: {
    'buttonList': [
      {
        'label': '',
        'icon': 'el-icon-refresh',
        'click': '$refresh',
        'isMore': false,
        'isHide': false
      },
      {
        'label': '',
        'icon': 'el-icon-plus',
        'click': '$add',
        'isMore': false,
        'isHide': false
      },
      {
        'label': '',
        'icon': 'el-icon-delete',
        'click': '$delete',
        'isMore': false,
        'isHide': false
      },
      {
        'label': '保存',
        'click': '$save',
        'icon': '',
        'isHide': false,
        'isMore': false
      },
      {
        'label': '审核',
        'icon': '',
        'click': '$billAudit',
        'isHide': false,
        'isMore': false
      },
      {
        'label': '取消审核',
        'icon': '',
        'click': '$billUnAudit',
        'isHide': false,
        'isMore': false
      },
      {
        'label': '关闭',
        'icon': '',
        'click': '$billClose',
        'isHide': false,
        'isMore': false
      },
      {
        'label': '取消关闭',
        'icon': '',
        'click': '$billUnClose',
        'isHide': false,
        'isMore': false
      },
      {
        'label': '配置',
        'icon': '',
        'click': '$setPageConfig',
        'isHide': false,
        'isMore': true
      },
      {
        'label': 'Action',
        'icon': '',
        'click': '$setAction',
        'isHide': false,
        'isMore': true
      }
    ]
  },
  sourceData: []
}
const importHdrHsButtonTools = {
  config: {
    'buttonList': [
      {
        'label': '配置',
        'icon': '',
        'click': '$setPageConfig',
        'isHide': false,
        'isMore': true
      },
      {
        'label': 'Action',
        'icon': '',
        'click': '$setAction',
        'isHide': false,
        'isMore': true
      }
    ]
  },
  sourceData: []
}
const importDtlHsButtonTools = {
  config: {
    'buttonList': [
      {
        'label': '导入',
        'icon': '',
        'click': '$dataImportHdrDtl',
        'isMore': false,
        'isHide': false
      }
    ]
  },
  sourceData: []
}
const hsButtonToolsImport = {
  config: {
    'buttonList': [
      {
        'label': '导入',
        'click': '$dataImport',
        'icon': '',
        'isHide': false,
        'isMore': false
      },
      {
        'label': '',
        'icon': 'el-icon-search',
        'click': '$search',
        'isMore': false,
        'isHide': true
      },
      {
        'label': '配置',
        'icon': '',
        'click': '$setPageConfig',
        'isHide': false,
        'isMore': true
      },
      {
        'label': 'Action',
        'icon': '',
        'click': '$setAction',
        'isHide': false,
        'isMore': true
      }
    ]
  },
  sourceData: []
}
const hsButtonToolsCommon = {
  config: {
    'buttonList': [
      {
        'label': '确定',
        'icon': '',
        'click': '',
        'isMore': false,
        'isHide': false
      }
    ]
  },
  sourceData: []
}
const hsButtonTools = {
  config: {
    'buttonList': [
      {
        'label': '',
        'icon': 'el-icon-search',
        'click': '$search',
        'isMore': false,
        'isHide': true
      },
      {
        'label': '',
        'icon': 'el-icon-refresh',
        'click': '$refresh',
        'isMore': false,
        'isHide': false
      },
      {
        'label': '',
        'icon': 'el-icon-plus',
        'click': '$add',
        'isMore': false,
        'isHide': false
      },
      {
        'label': '',
        'icon': 'el-icon-edit',
        'click': '$edit',
        'isMore': false,
        'isHide': true
      },
      {
        'label': '',
        'icon': 'el-icon-delete',
        'click': '$delete',
        'isMore': false,
        'isHide': false
      },
      {
        'label': '保存',
        'click': '$save',
        'icon': '',
        'isHide': false,
        'isMore': true
      },
      {
        'label': '导入',
        'click': '$dataImport',
        'icon': '',
        'isHide': true,
        'isMore': true
      },
      {
        'label': '配置',
        'icon': '',
        'click': '$setPageConfig',
        'isHide': false,
        'isMore': true
      },
      {
        'label': 'Action',
        'icon': '',
        'click': '$setAction',
        'isHide': false,
        'isMore': true
      }
    ]
  },
  sourceData: []
}
const hsSwitch = {
  config: {
    activeText: '',
    inactiveText: ''
  },
  sourceData: []
}
const hsCascader = {
  sourceData: [{
    value: 'zhinan',
    label: '指南',
    children: [{
      value: 'shejiyuanze',
      label: '设计原则',
      children: [{
        value: 'yizhi',
        label: '一致'
      }, {
        value: 'fankui',
        label: '反馈'
      }, {
        value: 'xiaolv',
        label: '效率'
      }, {
        value: 'kekong',
        label: '可控'
      }]
    }, {
      value: 'daohang',
      label: '导航',
      children: [{
        value: 'cexiangdaohang',
        label: '侧向导航'
      }, {
        value: 'dingbudaohang',
        label: '顶部导航'
      }]
    }]
  }, {
    value: 'zujian',
    label: '组件',
    children: [{
      value: 'basic',
      label: 'Basic',
      children: [{
        value: 'layout',
        label: 'Layout 布局'
      }, {
        value: 'color',
        label: 'Color 色彩'
      }, {
        value: 'typography',
        label: 'Typography 字体'
      }, {
        value: 'icon',
        label: 'Icon 图标'
      }, {
        value: 'button',
        label: 'Button 按钮'
      }]
    }, {
      value: 'form',
      label: 'Form',
      children: [{
        value: 'radio',
        label: 'Radio 单选框'
      }, {
        value: 'checkbox',
        label: 'Checkbox 多选框'
      }, {
        value: 'input',
        label: 'Input 输入框'
      }, {
        value: 'input-number',
        label: 'InputNumber 计数器'
      }, {
        value: 'select',
        label: 'Select 选择器'
      }, {
        value: 'cascader',
        label: 'Cascader 级联选择器'
      }, {
        value: 'switch',
        label: 'Switch 开关'
      }, {
        value: 'slider',
        label: 'Slider 滑块'
      }, {
        value: 'time-picker',
        label: 'TimePicker 时间选择器'
      }, {
        value: 'date-picker',
        label: 'DatePicker 日期选择器'
      }, {
        value: 'datetime-picker',
        label: 'DateTimePicker 日期时间选择器'
      }, {
        value: 'upload',
        label: 'Upload 上传'
      }, {
        value: 'rate',
        label: 'Rate 评分'
      }, {
        value: 'form',
        label: 'Form 表单'
      }]
    }, {
      value: 'data',
      label: 'Data',
      children: [{
        value: 'table',
        label: 'Table 表格'
      }, {
        value: 'tag',
        label: 'Tag 标签'
      }, {
        value: 'progress',
        label: 'Progress 进度条'
      }, {
        value: 'tree',
        label: 'Tree 树形控件'
      }, {
        value: 'pagination',
        label: 'Pagination 分页'
      }, {
        value: 'badge',
        label: 'Badge 标记'
      }]
    }, {
      value: 'notice',
      label: 'Notice',
      children: [{
        value: 'alert',
        label: 'Alert 警告'
      }, {
        value: 'loading',
        label: 'Loading 加载'
      }, {
        value: 'message',
        label: 'Message 消息提示'
      }, {
        value: 'message-box',
        label: 'MessageBox 弹框'
      }, {
        value: 'notification',
        label: 'Notification 通知'
      }]
    }, {
      value: 'navigation',
      label: 'Navigation',
      children: [{
        value: 'menu',
        label: 'NavMenu 导航菜单'
      }, {
        value: 'tabs',
        label: 'Tabs 标签页'
      }, {
        value: 'breadcrumb',
        label: 'Breadcrumb 面包屑'
      }, {
        value: 'dropdown',
        label: 'Dropdown 下拉菜单'
      }, {
        value: 'steps',
        label: 'Steps 步骤条'
      }]
    }, {
      value: 'others',
      label: 'Others',
      children: [{
        value: 'dialog',
        label: 'Dialog 对话框'
      }, {
        value: 'tooltip',
        label: 'Tooltip 文字提示'
      }, {
        value: 'popover',
        label: 'Popover 弹出框'
      }, {
        value: 'card',
        label: 'Card 卡片'
      }, {
        value: 'carousel',
        label: 'Carousel 走马灯'
      }, {
        value: 'collapse',
        label: 'Collapse 折叠面板'
      }]
    }]
  }, {
    value: 'ziyuan',
    label: '资源',
    children: [{
      value: 'axure',
      label: 'Axure Components'
    }, {
      value: 'sketch',
      label: 'Sketch Templates'
    }, {
      value: 'jiaohu',
      label: '组件交互文档'
    }]
  }],
  config: {

  }
}
const hsFile = {
  config: {
    appCode: ''
  },
  sourceData: []
}
const hsComputed = {
  config: {
    click: ''
  },
  sourceData: []
}
const hsDialog = {
  config: {
    title: '提示'
  },
  sourceData: []
}
const hsTabs = {
  config: {
    tabsData: [{ label: '测试', name: '测试' }]
  },
  sourceData: []
}
const mockData = {
  hsLineBar: initLineBar,
  hsPie: initPie,
  hsRadar: initRadar,
  hsSelectPlus: hsSelectPlus,
  hsTable: hsTable,
  hsTableImport: hsTableImport,
  hsAction,
  hsInput,
  hsDivider,
  hsDatePicker,
  hsTags,
  hsCheckbox,
  hsTree,
  hsDyncFormComponent,
  hsPageConfig,
  hsButtonTools,
  hsButtonToolsBillMain,
  hsButtonToolsBillIndex,
  hsButtonToolsHdrDtl,
  hsButtonToolsImport,
  importHdrHsButtonTools,
  hsButtonToolsSingleMain,
  hsButtonToolsCommon,
  importDtlHsButtonTools,
  hsSwitch,
  hsCascader,
  hsPageConfigBill,
  hsPageConfigSingle,
  hsPageConfigHdrDtl,
  hsFile,
  hsComputed,
  hsDialog,
  hsTableList,
  hsTableImportList,
  hsTableDtl,
  hsTabs
}
export default mockData
