// 写一个递归方法把请求回来的数据 依次遍历 替换值
import commonUtility from '../funTools/commonUtility'
const parseUrlQueryParams = commonUtility.parseUrlQueryString() || {}
const parseGlobalParams = commonUtility.parseGlobalParams() || {}
function recursiveFun(obj) {
  const objType = typeof obj
  if (Array.isArray(obj)) {
    obj.forEach((item) => {
      recursiveFun(item)
    })
  } else if (objType === 'object') {
    for (const prop in obj) {
      recursiveFun(obj[prop])
    }
  } else {
    obj = commonUtility.parseMenuGlobalParams(obj, parseUrlQueryParams, parseGlobalParams)
  }
}

const obj = {
  'init_data': {
    'columns': {
      'usable': 1,
      'type': 100
    },
    'exec_sql': 'select bill_date=getdate()',
    'exec_js': 'funcA'
  },
  'entity': {
    'index': {
      'isShowEdiAreaTree': true,
      'defaultProps': {
        'children': 'childs',
        'label': 'equipment_type'
      },
      'isTree': false,
      'table_name': 'emEquipmentType',
      'primaryKey': 'id',
      'queryMainParms': [
        'equipment_type_id=id'
      ],
      'indexTitle': '设备类型',
      'dyncQueryParms': {
        'ort': '11',
        'bb_name': '{menuParam.name}'
      }
    },
    'main': {
      'table_name': 'emEquipmentModel',
      'primaryKey': 'id',
      'is_master_detail': true,
      'dyncQueryParms': {
        'number': '12312',
        'th_name': '{menuParam.name}'
      }
    }
  },
  'new_default': {
    'main': {
      'copy_prerow': 'column1,column2',
      'only_set_null_field': true,
      'columns': {
        'name': '{menuParam.name}',
        'type': 100
      },
      'exec_sql': 'select bill_date=getdate()',
      'exec_js': 'funcA'
    }
  },
  'required_column': {
    'columns': [
      {
        'name': 'column1',
        'null_value': 0
      },
      {
        'name': 'column2'
      }
    ],
    'exec_sql': 'select bill_date=getdate()',
    'exec_js': 'funcA'
  },
  'custom': {
    'bill_type': 100
  }
}
recursiveFun(obj)
console.log(obj)
