import _ from 'lodash'
class DataTool {
  constructor() {}
  // 折线图
  processDataLine(config, data) {
    // 根据数据的sSeries 进行分组
    const gp = _.groupBy(data, 'sSeries')
    // 所有的系列
    const { series, xAxis } = config
    const options_series = series
    const xData = xAxis.data
    // 给每个系列赋予值
    options_series.forEach(item => {
      const { name } = item
      // 按照x轴(xData)的顺序进行取值
      const sdata = gp[name]
      const list = []
      xData.forEach(x => {
        const targetX = sdata.find(sx => sx.sName === x)
        list.push(targetX.dValue)
      })
      item.data = list
    })
    return config
  }
  // 柱状图
  processDataBar(config, data) {
    // 根据数据的sSeries 进行分组
    const gp = _.groupBy(data, 'sSeries')
    // 所有的系列
    const { series, xAxis } = config
    const options_series = series
    const xData = xAxis.data
    // 给每个系列赋予值
    options_series.forEach(item => {
      const { name } = item
      // 按照x轴(xData)的顺序进行取值
      const sdata = gp[name]
      const list = []
      xData.forEach(x => {
        const targetX = sdata.find(sx => sx.sName === x)
        list.push(targetX.dValue)
      })
      item.data = list
    })
    return config
  }
  // 饼状图
  processDataPie(config, data) {
    // 根据数据的sSeries 进行分组
    const gp = _.groupBy(data, 'sSeries')
    // 所有的系列
    const { series, legend } = config
    const options_series = series
    const legendData = legend.data
    // 给每个系列赋予值
    options_series.forEach(item => {
      const { name } = item
      // 按照x轴(xData)的顺序进行取值
      const sdata = gp[name]
      if (!item.data || !item.data.length) { // 全部系列名
        const list = []
        legendData.forEach(x => {
          const targetX = sdata.find(sx => sx.sName === x)
          list.push({ value: targetX.dValue, name: x })
        })
        item.data = list
      } else if (item.data.length) { // 这个是指定name 的系列
        item.data.forEach(x => {
          const targetX = sdata.find(sx => sx.sName === x.name)
          x.value = targetX.dValue
        })
      }
    })
    return config
  }
}
export default DataTool
