import { TOOL_API, SERVICE_API } from '../common/commonModule'
class RestFul {
  constructor (requestClient, isService) {
    this.requestClient = requestClient
    this.moduleName = 'RestFulModule'
    // 如果isService 是字符串就直接试用这个字符串作为代理前缀,是不尔值:true就使用用默认的字符串:SERVICE_PROXY
    const typeof_isService = typeof isService
    this.MODULE_API = TOOL_API
    if (typeof_isService === 'boolean') {
      this.MODULE_API = isService ? SERVICE_API : TOOL_API
    } else if (typeof_isService === 'string' && isService) {
      this.MODULE_API = isService
    }
  }
  // 处理传入的data 如果有appCode dbName
  packParamHandle (parms) {
    const { appCode } = parms
    if (!appCode) {
      parms.appCode = this.requestClient.appCode //|| urlParam.appCode
    }
  }
  mergeHeaderQueryMaster (isQueryMaster) {
    if (isQueryMaster) {
      return {
        'x-db_router_type': 'master'
      }
    } else {
      return {}
    }
  }
  query (data) {
    this.packParamHandle(data)
    const { tableName, appCode, group, parms, bodyData, isQueryMaster } = data
    let url = `${this.MODULE_API}${appCode}/${tableName}/`
    if (group) {
      // 非标准保存
      url = `${url}${group}/`
    }
    const header = this.mergeHeaderQueryMaster(isQueryMaster)
    if (bodyData) {
      return this.requestClient.put(url, bodyData, parms, header)
    } else {
      return this.requestClient.get(url, parms, header)
    }
  }
  save (data) {
    this.packParamHandle(data)
    const { tableName, appCode, bodyData, group, parms } = data
    let url = `${this.MODULE_API}${appCode}/${tableName}/`
    if (group) {
      // 非标准保存
      url = `${url}${group}/`
    }
    return this.requestClient.post(url, bodyData, parms)
  }
  queryOne (data) {
    this.packParamHandle(data)
    const {
      tableName,
      id,
      appCode,
      parms,
      group,
      bodyData,
      isQueryMaster
    } = data
    let url_ = `${this.MODULE_API}${appCode}/${tableName}/` //${id}/`
    if (group) {
      url_ = `${url_}${group}/`
    }
    url_ = `${url_}${id}/`
    const header = this.mergeHeaderQueryMaster(isQueryMaster)
    if (bodyData) {
      return this.requestClient.put(url_, bodyData, parms, header)
    } else {
      return this.requestClient.get(url_, parms, header)
    }
  }
  put (data) {
    this.packParamHandle(data)
    const { tableName, appCode, bodyData, group, parms, isQueryMaster } = data
    let url = `${this.MODULE_API}${appCode}/${tableName}/`
    if (group) {
      // 非标准保存
      url = `${url}${group}/`
    }
    const header = this.mergeHeaderQueryMaster(isQueryMaster)
    return this.requestClient.put(url, bodyData, parms, header)
  }
  queryList (data) {
    this.packParamHandle(data)
    const { tableName, appCode, parms, group, bodyData, isQueryMaster } = data
    let url_ = `${this.MODULE_API}${appCode}/${tableName}/`
    if (group) {
      url_ = `${url_}${group}/`
    }
    parms.fuzzy = 1
    const header = this.mergeHeaderQueryMaster(isQueryMaster)
    if (bodyData) {
      return this.requestClient.put(url_, bodyData, parms, header)
    } else {
      return this.requestClient.get(url_, parms, header)
    }
  }
  deleteList (data) {
    this.packParamHandle(data)
    const { tableName, appCode, bodyData, parms, ids } = data
    let url_ = `${this.MODULE_API}${appCode}/${tableName}/`
    if (ids) {
      url_ + ids + '/'
    }
    return this.requestClient.delete(url_, bodyData, parms)
  }
  // 兼容新版java的ref查询
  get(data){
    this.packParamHandle(data)
    const { tableName, appCode, parms,group } = data
    let url_ = `${this.MODULE_API}${appCode}/${tableName}/`
    if (group) {
      url_ = `${url_}${group}/`
    }
    return this.requestClient.get(url_, parms)
  }
}
export default RestFul
