
import Root from './root'
import Billflow from './packages/modules/billflow'
import WebChartConfig from './packages/modules/webChartConfig'
import Restful from './packages/modules/restful'
import System from './packages/modules/system'
import WebQueryClient from './packages/modules/webQueryClient'
import Ref from './packages/modules/ref'
class HttpClient {
  constructor(axios, appCode, pageName,isService) {
    this.axios = axios
    const root = new Root(axios)
    appCode && (root.appCode = appCode)
    pageName && (root.pageName = pageName)
    this.root = root
    const restful = new Restful(root,isService)
    const webQueryClient = new WebQueryClient(root)
    const billflow = new Billflow(root)
    const system = new System(root, restful)
    const webChartConfig = new WebChartConfig(root)
    const ref = new Ref(root)
    const list = [root, webQueryClient, billflow, system, webChartConfig, restful, ref]
    // const api = {
    // }
    list.forEach(item => {
      this[item.moduleName] = item
    })
    // const root_prototype = root.__proto__
    // const root_prototype_keys = Object.getOwnPropertyNames(root_prototype)
    // root_prototype_keys.forEach(k => {
    //   if (k !== 'constructor') {
    //     this[`${k}`] = root_prototype[k]
    //   }
    // })
  }
  init (config) {
    config.appCode && (this.root.appCode = config.appCode)
    config.pageName && (this.root.pageName = config.pageName)
  }
}

export default HttpClient
