import axios from 'axios'
import hsUtil from 'hs-util-js'
class Root {
  constructor (_axios) {
    this.moduleName = 'rootModule'
    this.axios = _axios || axios
  }
  getParseGlobalParams () {
    return hsUtil.SystemModule.parseGlobalParams() || {}
  }
  getuUrlParam () {
    return hsUtil.SystemModule.getUrlParams() || {}
  }
  filterEmptyValue (obj) {
    if (!obj) return
    const emptyValues = [null, undefined, 'null', 'undefined', NaN]
    for (const k in obj) {
      if (emptyValues.includes(obj[k])) {
        console.log(`数据中有空值${k}`, obj[k])
        delete obj[k]
      } else if (typeof obj[k] === 'object') {
        return this.filterEmptyValue(obj[k])
      }
    }
  }
  get (url, params, headers, config) {
    return this.request('get', url, null, params, headers, config)
  }
  post (url, data, params, headers, config) {
    return this.request('post', url, data, params, headers, config)
  }
  put (url, data, params, headers, config) {
    return this.request('put', url, data, params, headers, config)
  }
  delete (url, data, params, headers, config) {
    return this.request('delete', url, data, params, headers, config)
  }
  requestConfig (config) {
    return axios(config)
  }
  handleParams (params) {
    if (params) {
      delete params.token
      delete params._user_info
      delete params.user_info
      const replaceStr = {
        '%': '%25',
        '#': '%23',
        '&': '%26',
        '>': '%3E',
        '<': '%3C',
        '+': '%2B',
        '/': '%2F',
        '=': '3D',
        ':': '3A'
      }
      const replaceStrKeys = Object.keys(replaceStr)
      for (let k in params) {
        let value = params[k]
        replaceStrKeys.forEach(rkey => {
          const reg = new RegExp(`\${rkey}`, 'g')
          value = value.replace(reg, replaceStr[rkey])
        })
        params[k] = value
      }
    }
  }
  getDbName () {
    const parseGlobalParams = this.getParseGlobalParams()
    const urlParam = this.getuUrlParam()
    if (urlParam.dbName) return urlParam.dbName
    if (parseGlobalParams.db_name) return parseGlobalParams.db_name
    return ''
  }
  request (method, url, data, params, headers = null, config = {}) {
    this.filterEmptyValue(data)
    // 公共头设置
    const aixosCtx = { method, url }
    if (config) {
      Object.assign(aixosCtx, config)
    }
    //this.handleParams(params)
    params && (aixosCtx.params = params)
    if (aixosCtx.params && aixosCtx.params.token) delete aixosCtx.params.token
    if (aixosCtx.params && aixosCtx.params._user_info)
      delete aixosCtx.params._user_info
    // 给问号参数加上db_name,逻辑是 session中没有 就去取url上的
    if (!aixosCtx.params) {
      // 问号参数不存在时加一个参数
      aixosCtx.params = {
        db_name: this.getDbName()
      }
    } else {
      if (aixosCtx.params && !aixosCtx.params.db_name) {
        aixosCtx.params.db_name = this.getDbName()
      }
    }

    data && (aixosCtx.data = data)
    headers && (aixosCtx.headers = headers)
    const result = this.axios(aixosCtx)
    return result
  }
}

export default Root
