
import Root from './root'
import Billflow from './packages/modules/billflow'
import WebChartConfig from './packages/modules/webChartConfig'
import Restful from './packages/modules/restful'
import System from './packages/modules/system'
import WebQueryClient from './packages/modules/webQueryClient'
import Ref from './packages/modules/ref'
const root = new Root()
const restful = new Restful(root)
const webQueryClient = new WebQueryClient(root)
const billflow = new Billflow(root)
const system = new System(root, restful)
const webChartConfig = new WebChartConfig(root)
const ref = new Ref(root)
const list = [webQueryClient, billflow, system, webChartConfig, restful, ref]
const api = {
}
list.forEach(item => {
  api[item.moduleName] = item
})
const root_prototype = root.__proto__
const root_prototype_keys = Object.getOwnPropertyNames(root_prototype)
root_prototype_keys.forEach(k => {
  if (k !== 'constructor') {
    api[`${k}`] = root_prototype[k]
  }
})
export default api
