
import { TOOL_PROXY, FILE_RESOURCE_PROXY } from '../common/commonProxy'
class System {
  constructor(requestClient, restfulClient) {
    this.moduleName = 'SystemModule'
    this.requestClient = requestClient
    this.restfulClient = restfulClient
  }
  // 获取number个id
  getNewId (number = 100) {
    return this.requestClient.get(`${TOOL_PROXY}/common/new_id/${number}/`)
  }
  // 获取 动态中的action列表
  queryBillpbWebDyncCode (data) {
    const { appCode, pageName } = data
    const params = {
      parms: {
        app_code: appCode,
        page_name: pageName,
        usable: 1
      },
      appCode: 'queryBi',
      tableName: 'pbWebDyncCode'
    }
    return this.restfulClient.query(params)
  }
  // 获取 动态中的action列表
  saveBillpbWebDyncCode (data) {
    const params = {
      bodyData: data,
      appCode: 'queryBi',
      tableName: 'pbWebDyncCode'
    }
    return this.restfulClient.save(params)
  }
  // 打印
  printTask (data) {
    const url = `${TOOL_PROXY}/common/print_task/`
    return this.requestClient.post(url, data)
  }
  typePrintTask (data) {
    const url = `${TOOL_PROXY}/common/print_task_by_bill_type/`
    return this.requestClient.post(url, data)
  }
  // 上传文件
  uploadFile (formData, app_code, tenant_code, config = {}) {
    const parms = {
      tenant_code
    }
    return this.requestClient.post(`${FILE_RESOURCE_PROXY}/file/${app_code}/`, formData, parms, null, config)
  }
  importExcel (data) {
    data.group = 'import_excel'
    return this.restfulClient.save(data)
  }
  exportExcelData (data) {
    data.group = 'ExportExcel'
    return this.restfulClient.queryList(data)
  }
}
export default System
