import axios from 'axios'
class Root {
  constructor(_axios) {
    this.axios = _axios || axios
  }
  filterEmptyValue (obj) {
    if (!obj) return
    const emptyValues = [null, undefined, 'null', 'undefined', NaN]
    for (const k in obj) {
      if (emptyValues.includes(obj[k])) {
        console.log(`数据中有空值${k}`, obj[k])
        delete obj[k]
      } else if (typeof obj[k] === 'object') {
        return this.filterEmptyValue(obj[k])
      }
    }
  }
  get (url, params, headers, config) {
    return this.request('get', url, null, params, headers, config)
  }
  post (url, data, params, headers, config) {
    return this.request('post', url, data, params, headers, config)
  }
  put (url, data, params, headers, config) {
    return this.request('put', url, data, params, headers, config)
  }
  delete (url, data, params, headers, config) {
    return this.request('delete', url, data, params, headers, config)
  }
  requestConfig (config) {
    return axios(config)
  }
  request (method, url, data, params, headers = null, config = {}) {
    this.filterEmptyValue(data)
    // 公共头设置
    const aixosCtx = { method, url }
    if (config) {
      Object.assign(aixosCtx, config)
    }
    params && (aixosCtx.params = params)
    if (aixosCtx.params && aixosCtx.params.token) delete aixosCtx.params.token
    if (aixosCtx.params && aixosCtx.params._user_info) delete aixosCtx.params._user_info
    data && (aixosCtx.data = data)
    headers && (aixosCtx.headers = headers)
    const result = this.axios(aixosCtx)
    return result
  }
}

export default Root
