
import { WEB_QUERY, WEB_QUERY_QUERY, WEB_QUERY_QUERY_VALUE, WEB_QUERY_PAGE } from '../common/commonModule'
import hsUtil from 'hs-util-js'
const urlParam = hsUtil.SystemModule.getUrlParams()
const { user_id } = hsUtil.SystemModule.parseGlobalParams()
class Control {
  constructor(requestClient) {
    this.requestClient = requestClient
    this.moduleName = 'WebChartConfigModule'
  }
  // 处理传入的data 如果有appCode,pageName dbName
  packParamHandle(parms) {
    const { appCode, pageName, dbName, dbCode, userId } = parms
    if (!appCode) {
      parms.appCode = urlParam.appCode
    }
    if (!pageName) {
      parms.pageName = urlParam.pageName
    }
    if (!dbName) {
      parms.dbName = urlParam.dbName || ''
    }
    if (!dbCode) {
      parms.dbCode = urlParam.dbCode || ''
    }
    if (!userId) {
      parms.userId = user_id || 1
    }
  }
  // 保存控件配置
  /**
       * sAppCode:页面appCode
       * sPage:页面名称
       * sControl:控件名称
       * sControlType: 类型
       * sQuerySql:  sql语句
       * bMockData: 是否是模拟数据
       * iUserId:用户id
       * db_name: 数据库名
       * db_code:数据库code
       * sConfig:控件配置
       * sData: 数据
       * @param {*} data
       */
  webChartConfigSave(param) { // routerParms: page路由 position位置 other参数, sConfig 配置json sData 数据json
    this.packParamHandle(param)
    const { appCode, pageName, controlName, controlType, querySql, mockData, userId, dbName, dbCode, config, data } = param
    const postData = {
      exec_sql: `EXEC dbo.spappWebChartConfig_Save @sAppCode='${appCode}',@sPage='${pageName}',@sControl='${controlName}',@sControlType='${controlType || ''}',@sConfig=:sConfig,@sData=:sData,@sQuerySql='${querySql || ''}',@bMockData='${mockData || ''}',@iUserId=${userId || 1}`,
      db_name: dbName,
      db_code: dbCode,
      param: {
        sConfig: JSON.stringify(config),
        sData: JSON.stringify(data)
      }
    }
    return this.requestClient.post(WEB_QUERY, postData)
  }
  // 查询配置
  /**
       * sAppCode:页面appCode
       * sPage:页面名称
       * sControl:控件名称
       * sControlType: 类型
       * sQuerySql:  sql语句
       * bMockData: 是否是模拟数据
       * iUserId:用户id
       * db_name: 数据库名
       * db_code:数据库code
       * sConfig:控件配置
       * sData: 数据
       * @param {*} data
       */
  webChartConfigQuery(data) {
    this.packParamHandle(data)
    const { appCode, pageName, controlName, userId, dbName, dbCode } = data
    const postData = {
      exec_sql: `EXEC dbo.spappWebChartConfig_Query @sAppCode='${appCode}',@sPage='${pageName}',@sControl='${controlName}',@iUserId='${userId}'`,
      db_name: dbName,
      db_code: dbCode
    }
    return this.requestClient.post(WEB_QUERY_QUERY, postData)
  }
  // 获取将要另存到本地的配置
  webChartConfigSaveAs(data) {
    this.packParamHandle(data)
    const { appCode, pageName, dbName, dbCode } = data
    const postData = {
      exec_sql: `EXEC dbo.spappWebChartConfig_SaveAs @sAppCode='${appCode}',@sPage='${pageName}'`,
      db_name: dbName,
      db_code: dbCode
    }
    return this.requestClient.post(WEB_QUERY_QUERY_VALUE, postData)
  }
  // 另存配置
  async saveAsDataToLocal(data) {
    this.packParamHandle(data)
    const { appCode, pageName } = data
    const res = await this.webChartConfigSaveAs(data)
    if (!res) return
    this.download(`spappWebChartConfig_Upgrade_${appCode}_${pageName}.sql`, res.data)
  }
  download(name, data) {
    var urlObject = window.URL || window.webkitURL || window
    var downloadData = new Blob([data])
    var save_link = document.createElementNS('http://www.w3.org/1999/xhtml', 'a')
    save_link.href = urlObject.createObjectURL(downloadData)
    save_link.download = name
    this.fake_click(save_link)
  }
  fake_click(obj) {
    var ev = document.createEvent('MouseEvents')
    ev.initMouseEvent(
      'click', true, false, window, 0, 0, 0, 0, 0
      , false, false, false, false, 0, null
    )
    obj.dispatchEvent(ev)
  }
  // 直接执行sql语句
  execSql(data) {
    this.packParamHandle(data)
    const { execSql, dbName, dbCode } = data
    const postData = {
      exec_sql: execSql,
      db_name: dbName,
      db_code: dbCode
    }
    return this.requestClient.post(WEB_QUERY_QUERY, postData)
  }
  webChartConfigQueryLog(data) {
    this.packParamHandle(data)
    const { appCode, pageName, controlName, dbName, dbCode } = data
    const postData = {
      exec_sql: `EXEC dbo.spappWebChartConfig_QueryLog  @sAppCode='${appCode}',@sPageName='${pageName}',@sControlName='${controlName}'`,
      db_name: dbName,
      db_code: dbCode
    }
    return this.requestClient.post(WEB_QUERY_QUERY, postData)
  }
  webChartConfigRevert(data) {
    this.packParamHandle(data)
    const { appCode, pageName, dbName, dbCode, controlName, version } = data
    const postData = {
      exec_sql: `EXEC dbo.spappWebChartConfig_Revert  @sAppCode='${appCode}',@sPageName='${pageName}',@sControlName='${controlName}',@iVersion='${version}'`,
      db_name: dbName,
      db_code: dbCode
    }
    return this.requestClient.post(WEB_QUERY, postData)
  }
  // 控件配置查询
  webControlQuery(data) {
    this.packParamHandle(data)
    const { dbName, pageName, param, appCode, controlName, returnType, dbCode, userId } = data
    const postData = {
      db_name: dbName,
      app_code: appCode,
      page: pageName,
      param: JSON.stringify(param || {}),
      control_name: controlName,
      return_type: returnType || 3,
      db_code: dbCode,
      user_id: userId
    }
    return this.requestClient.post(WEB_QUERY_PAGE, postData)
  }
}
export default Control
