import scrollparent from './scrollparent';
export class FcRectangleSelectService {
    constructor(modelService, selectElement, applyFunction) {
        this.selectRect = {
            x1: 0,
            x2: 0,
            y1: 0,
            y2: 0
        };
        this.modelService = modelService;
        this.selectElement = selectElement;
        this.$canvasElement = $(this.modelService.canvasHtmlElement);
        this.$scrollParent = $(scrollparent(this.modelService.canvasHtmlElement));
        this.applyFunction = applyFunction;
    }
    mousedown(e) {
        if (this.modelService.isEditable() && !e.ctrlKey && !e.metaKey && e.button === 0
            && this.selectElement.hidden) {
            this.selectElement.hidden = false;
            const offset = this.$canvasElement.offset();
            this.selectRect.x1 = Math.round(e.pageX - offset.left);
            this.selectRect.y1 = Math.round(e.pageY - offset.top);
            this.selectRect.x2 = this.selectRect.x1;
            this.selectRect.y2 = this.selectRect.y1;
            this.updateSelectRect();
        }
    }
    mousemove(e) {
        if (this.modelService.isEditable() && !e.ctrlKey && !e.metaKey && e.button === 0
            && !this.selectElement.hidden) {
            const offset = this.$canvasElement.offset();
            this.selectRect.x2 = Math.round(e.pageX - offset.left);
            this.selectRect.y2 = Math.round(e.pageY - offset.top);
            this.updateScroll(offset);
            this.updateSelectRect();
        }
    }
    updateScroll(offset) {
        const rect = this.$scrollParent[0].getBoundingClientRect();
        const bottom = rect.bottom - offset.top;
        const right = rect.right - offset.left;
        const top = rect.top - offset.top;
        const left = rect.left - offset.left;
        if (this.selectRect.y2 - top < 25) {
            const topScroll = 25 - (this.selectRect.y2 - top);
            const scroll = this.$scrollParent.scrollTop();
            this.$scrollParent.scrollTop(scroll - topScroll);
        }
        else if (bottom - this.selectRect.y2 < 40) {
            const bottomScroll = 40 - (bottom - this.selectRect.y2);
            const scroll = this.$scrollParent.scrollTop();
            this.$scrollParent.scrollTop(scroll + bottomScroll);
        }
        if (this.selectRect.x2 - left < 25) {
            const leftScroll = 25 - (this.selectRect.x2 - left);
            const scroll = this.$scrollParent.scrollLeft();
            this.$scrollParent.scrollLeft(scroll - leftScroll);
        }
        else if (right - this.selectRect.x2 < 40) {
            const rightScroll = 40 - (right - this.selectRect.x2);
            const scroll = this.$scrollParent.scrollLeft();
            this.$scrollParent.scrollLeft(scroll + rightScroll);
        }
    }
    mouseup(e) {
        if (this.modelService.isEditable() && !e.ctrlKey && !e.metaKey && e.button === 0
            && !this.selectElement.hidden) {
            const rectBox = this.selectElement.getBoundingClientRect();
            this.selectElement.hidden = true;
            this.selectObjects(rectBox);
        }
    }
    updateSelectRect() {
        const x3 = Math.min(this.selectRect.x1, this.selectRect.x2);
        const x4 = Math.max(this.selectRect.x1, this.selectRect.x2);
        const y3 = Math.min(this.selectRect.y1, this.selectRect.y2);
        const y4 = Math.max(this.selectRect.y1, this.selectRect.y2);
        this.selectElement.style.left = x3 + 'px';
        this.selectElement.style.top = y3 + 'px';
        this.selectElement.style.width = x4 - x3 + 'px';
        this.selectElement.style.height = y4 - y3 + 'px';
    }
    selectObjects(rectBox) {
        this.applyFunction(() => {
            this.modelService.selectAllInRect(rectBox);
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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