import os
from pprint import pprint


def init_env():
    if os.path.exists(r"/etc/profile.d/huansi.sh"):
        with open(r"/etc/profile.d/huansi.sh", "r") as f:
            setting = f.readlines()
        print("当前DB配置：\n{}\n".format(''.join([item.replace(r'\n', '') for item in setting])))

    while True:
        print('=========================设置DB=========================')
        print('如果想要退出，按住CTRL+C键然后再按一下Enter键即可退出，如果不知道，想象一下你要复制文本时候的按键')
        print('========================================================\n')

        HSCUSCODE = input("请输入客户代号HSCUSCODE:")
        print(HSCUSCODE)
        HSDB_HOST = input("请输入数据库主机地址HSDB_HOST:")
        print(HSDB_HOST)
        HSDB_PORT = input("请输入数据库端口号HSDB_PORT(默认端口1433):")
        print(HSDB_PORT)
        HSDB_USER = input("请输入数据库用户HSDB_USER:")
        print(HSDB_USER)
        HSDB_PASSWORD = input("请输入数据库密码HSDB_PASSWORD:")
        print(HSDB_PASSWORD)
        HSDB_NAME = input("请输入ERP数据库名称HSDB_NAME(默认HsGmtERP):")
        print(HSDB_NAME)
        MESDB_NAME = input("请输入MES数据库名称MESDB_NAME(默认HsGmtMES):")
        print(MESDB_NAME)
        HSPASSWORD = "huansi.net"
        is_proxy = input("是否设置代理,确认请输入Y,输入N不设置代理:")
        if is_proxy.upper() == 'Y':
            ip_and_port = input("请输入代理的ip地址和端口(列如192.168.1.1:808):").strip()
            # CCProxy代理默认端口808
            if ":" not in ip_and_port:
                ip_and_port = ip_and_port + ":808"
        else:
            ip_and_port = None

        env = dict(HSCUSCODE=HSCUSCODE,
                   HSDB_HOST=HSDB_HOST,
                   HSDB_PORT=HSDB_PORT,
                   HSDB_USER=HSDB_USER,
                   HSDB_PASSWORD=HSDB_PASSWORD,
                   HSDB_NAME=HSDB_NAME,
                   MESDB_NAME=MESDB_NAME,
                   HSPASSWORD=HSPASSWORD
                   )
        pprint(env)
        flag = input("请检查以上环境变量设置是否正确,确认请输入Y,输入其他,重新设置:")
        if flag.upper() == 'Y':
            with open("/etc/profile.d/huansi.sh", "w") as f:
                for k, v in env.items():
                    f.writelines("export {}={}\n".format(k, v))

            print('环境变量设置成功,目标文件为/etc/profile.d/huansi.sh')
            # 返回客户编号和代理地址
            return HSCUSCODE, ip_and_port
        elif flag == "N":
            continue
        else:
            continue


if __name__ == "__main__":
    init_env()
    print("环境变量设置结束")
