import request from '../request'
import { AxiosResponse } from 'axios'
import { LoginFrom } from '@/types/views/login'
import { ResponseData } from '@/types/api/public'
import { LoginSuccess, UserInfo, RouterData } from '@/types/api/login'

type ConfigType<T = ResponseData> = Promise<AxiosResponse<T>>

/**
 * @desc: 登录
 * @param { Object } data 输入的账号密码
 */
export const login = (data: LoginFrom): ConfigType<LoginSuccess> => {
  return request({
    url: '/login',
    method: 'post',
    data
  })
}

/**
 * @desc: 获取用户信息
 * @returns data
 */
export const info = (): ConfigType<UserInfo> => {
  return request({
    url: '/info',
    method: 'get'
  })
}

/**
 * @desc: 获取菜单
 */
export const menu = (): ConfigType<RouterData> => {
  return request({
    url: '/menu',
    method: 'get'
  })
}

/**
 * @desc: 退出登录
 */
export const logout = (): ConfigType => {
  return request({
    url: '/logout',
    method: 'post'
  })
}


export const data1 = [{
  "id": 1,
  "pid": 0,
  "name": "基础模板",
  "path": "/",
  "redirect": "/page/pendingdrive_page",
  "component": "BasicLayout",
  "icon": "AppleOutlined",
  "key": "layout",
  "children": [{
    "id": 2,
    "pid": 1,
    "name": "幕后管理",
    "path": "/page",
    "redirect": "/page/pendingdrive_page",
    "component": "RouteView",
    "icon": "ChromeOutlined",
    "key": "page",
    "children": [{
      "id": 10,
      "pid": 2,
      "name": "待审驱动",
      "path": "/page/pendingdrive_page",
      "redirect": "",
      "component": "/page/pendingdrive_page",
      "icon": "",
      "key": "pendingdrive_page",
      "keepAlive": true
    },
    {
      "id": 11,
      "pid": 2,
      "name": "品牌型号",
      "path": "/page/brandmodel_page",
      "redirect": "",
      "component": "/page/brandmodel_page",
      "icon": "",
      "key": "brandmodel_page"
    },
    {
      "id": 12,
      "pid": 2,
      "name": "驱动列表",
      "path": "/page/drivelist_page",
      "redirect": "",
      "component": "/page/drivelist_page",
      "icon": "",
      "key": "drivelist_page"
    },
    {
      "id": 12,
      "pid": 2,
      "name": "驱动修改",
      "path": "/page/driverAddorEdite_page",
      "redirect": "",
       "component": "/page/driverAddorEdite_page",
      "icon": "",
      "key": "driverAddorEdite_page",
      "hidden":true
    },
    {
      "id": 13,
      "pid": 2,
      "name": "型号维护",
      "path": "/page/modelmaintain_page",
      "redirect": "",
       "component": "/page/modelmaintain_page",
      "icon": "",
      "key": "modelmaintain_page",
      "hidden":true
    }
    ]
  },
  {
    "id": 3,
    "pid": 1,
    "name": "网关管理",
    "path": "/page",
    "redirect": "/page/gatewaylist_page",
    "component": "RouteView",
    "icon": "WechatOutlined",
    "key": "gatewaylist_page",
    "children": [{
      "id": 12,
      "pid": 3,
      "name": "网关列表",
      "path": "/page/gatewaylist_page",
      "redirect": "",
      "component": "/page/gatewaylist_page",
      "icon": "",
      "key": "join"
    }]
  },
  {
    "id": 4,
    "pid": 0,
    "name": "平台管理",
    "path": "/page",
    "redirect": "/page/usermng_page",
    "component": "RouteView",
    "icon": "AppleOutlined",
    "key": "lan",
    "children": [{
      "id": 14,
      "pid": 4,
      "name": "用户管理",
      "path": "/page/usermng_page",
      "redirect": "",
      "component": "/page/usermng_page",
      "icon": "",
      "key": "usermng_page",
      "keepAlive": true
    }
    ]
  }
  ]
}
]
