// 挂载变量
import {
	API_URL,
	IMG_URL,
	UPLOAD_URL
} from '../../env.js';
// import store from '@/config/store';
import http from '@/config/request';
import platform from '@/config/platform';
import tools from '@/config/utils/tools';
import mixins from '@/config/mixins';


// #ifdef H5
// uni方法重写, h5的粘贴板的设置，获取。图片视频的保存
import wxsdk from '@/config/wechat/sdk'
import VConsole from 'vconsole'
import '@/config/utils/sdk-h5.js'
// #endif

import wechat from '@/config/wechat/wechat';

const install = Vue => {
	Vue.prototype.$API_URL = API_URL;
	Vue.prototype.$IMG_URL = IMG_URL;
	Vue.prototype.$UPLOAD_URL = UPLOAD_URL;
	// 挂载请求
	Vue.prototype.$http = http;
	// 平台判断
	Vue.prototype.$platform = platform;
	// 挂载工具函数
	Vue.prototype.$tools = tools;
	// 挂载通用处理的生命周期
	Vue.mixin(mixins);

	// #ifdef H5
	// 微信H5,sdk挂载
	Vue.prototype.$wxsdk = wxsdk;
	//  调试微信jssdk
	process.env.NODE_ENV === 'development' && new VConsole()
	// #endif
}

export async function init(options) {
	// #ifdef H5
	platform.entry();
	// #endif
	// #ifdef MP-WEIXIN
	// 检测小程序更新(如果从朋友圈场景进入则无此API)
	options.scene !== 1154 && wechat.checkMiniProgramUpdate();
	// #endif

}

export default {
	install
}
