/**
 * 处理一些公共逻辑
 *
 * onLoad
 * @description 小程序下分享
 *  onShareAppMessage
 *  onShareTimeline
 */

import {
	router
} from '@/config/router'
export default {
	onLoad(options) {
		let that = this;
		// 后端拼接的具体page页面 直接进入 （如订阅消息场景下直接跳转）
		// #ifdef MP
		if (options?.scene) {
			let scene = decodeURIComponent(options.scene);
			let sceneObj = scene.split('=');
			options[sceneObj[0]] = sceneObj[1];
		}
		// #endif
		// 传个地址过来跳转的模式
		if (options?.page) {
			router.push({
				path: decodeURIComponent(options.page)
			})
		}
		// if (options?.custom_id) {
		// 	router.push({
		// 		path: '/pages/index/view',
		// 		query: {
		// 			id: options.custom_id
		// 		}
		// 	})
		// }
	},
	// #ifdef MP-WEIXIN
	onShareAppMessage(res) {

	},
	onShareTimeline(res) {

	}
	// #endif
}
