import config from "../config/index";
let className = 'stylelibraryorder'
let baseUrl = `${config.baseUrl}/${className}`
export default {
    [className]:{
        'page': {
            url: `${baseUrl}/page`,
            method: 'post'
        },
        'details':{
            url: `${baseUrl}/details`,
            method: 'get'
        },
        // 潜在客户列表
        'potentialCustomersPage':{
            url: `${baseUrl}/potentialCustomersPage`,
            method: 'post'
        },
        // 潜在客户详情 enterpriseId
        'potentialCustomersDetails':{
            url: `${baseUrl}/potentialCustomersDetails`,
            method: 'get'
        },
        // 上架单列表
        'listingList':{
            url: `${baseUrl}/listingList`,
            method: 'post'
        },
        // 上架单详情
        'listingDetails':{
            url: `${baseUrl}/listingList`,
            method: 'get'
        },
        // 上架管理列表
        'getToShelvesManagerList':{
            url: `${baseUrl}/getToShelvesManagerList`,
            method: 'get'
        },
        // 上架管理详情
        'getStyleDetails':{
            url: `${baseUrl}/getStyleDetails`,
            method: 'get'
        },
        // 加入待上架
        'addToShelves':{
            url: `${baseUrl}/addToShelves`,
            method: 'post'
        },
        // 一键上架
        'oneClickListing':{
            url: `${baseUrl}/oneClickListing`,
            method: 'post'
        },
        'unlisted':{
            url: `${baseUrl}/unlisted`,
            method: 'post'
        },
        'shPay':{
            url: `${baseUrl}/shPay`,
            method: 'post'
        },
        'listingDetailsByCode':{
            url: `${baseUrl}/listingDetailsByCode`,
            method: 'get'
        }
    }
}
