import http from '@/config/request';
/**
 * 过滤字典值
 * @param {Array} data -图片地址
 * @param {String} type - 字典名
 * @param {String} $type - 类型别名
 * @param {String} key - 过滤用的名称
 * @param {String} targetKey - 取数目标字段
 */
function filterDictionary(data,type,$type,key ="dictName" , targetKey = "dictList"){
  let length = data.length ,res = [];
  for (let i = 0; i < length; i++) {
    let item = data[i];
    if(item[key] === type){
      res = item[targetKey];
      break;
    }
  }
  return res.map((item) => {
    return {
      ...item,
      ...{
        $type: $type
      }
    }
  });
}
/**
 * 过滤字典值
 * @param {Array} trees -
 */
function tree2List(trees){
  const newList = []
  const queue = []
  trees.forEach(tree => {
    // 1. 对根节点的处理
    const { children, ...meta } = tree // 去除子节点集合
    newList.push(meta) // 把当前节点介入到 新的list里
    if (children) { // 如果当前节点的 children 数组属性不为空，就把它加入到队列中
      queue.push(children)
    }
    // 2. 对根节点以外的节点进行处理
    // 遍历队列，可以看出 队列的操作 ： 边遍历,边放入新的元素
    while (queue.length) {
      const item = queue.pop() // 从队列里推出一个元素
      item && item.forEach(node => { // 如果子节点还有子节点，就继续往队列里存放
        // 以下是重复性操作
        const { children, ...meta } = node
        newList.push(meta)
        if (children) {
          queue.push(children)
        }
      })
    }
  })
  return newList
}
/**
 * 统一字典 尺码 品类 数据格式
 * @param {Array} data - 数据源
 * @param {String} label - 显示文本的
 * @param {String} value - 制
 * @param {String} $type - 类型别名 品类初始化是没有过 filterDictionary 缺少 $type
 */
function filterDictionaryLabelAndKey(data,label = 'dictValue',value = 'dictKey',$type){
	return data.map((item) =>{
		return {
		  label: item[label],
		  value: item[value],
		  $type: item.$type || $type
		}
	})
}
function filterArray(data){
  for (let i = 0; i < data.length; i++) {
    let item = data[i];
    if(item.children.length === 0){
      delete item.children;
    }else{
      filterArray(item.children)
    }
  }
  return data
}
const state = {
	brandArray : [], // 品牌
	saleSeasonArray : [], //销售季
	positionArray : [], //用料部位
	technologyTypeArray : [], //工艺类型
	technologyPositionArray : [], //工艺节点
	productionTypeArray : [], //生产类型
	styleTypeArray : [], //开发类型
	saleTypeArray : [], //销售类型
	yearArray : [], //年份
	seriesArray : [], //系列
	waveArray : [], //波段
	patternArray : [], //版型
	basicCompany : [], //基本单位
	materialNodeArray : [], //物料节点
	clothWidthUnitArray: [], // 门幅单位
	fabricWidthUnitArray: [], // 克重单位
	developmentRulesArray: [], // 开发规则
	productionArray: [], // 生产类别
	priceFixedArray: [], // 价格定位
	ageFixedArray: [], // 年龄定位
	styleFixedArray: [], //风格定位
	customerTypeArray: [], //客户类型
	sizeArray:[] , //尺码
	categoryArray: [], // 品类
}
const getters = {
	brandDictionary: ({brandArray}) => {
		return filterDictionaryLabelAndKey(brandArray)
	},
	categoryDictionary: ({categoryArray}) => {
		return filterDictionaryLabelAndKey(tree2List(categoryArray),'name','id','category')
	},
	saleSeasonDictionary: ({saleSeasonArray}) => {
		return filterDictionaryLabelAndKey(saleSeasonArray)
	},
	positionDictionary: ({positionArray}) => {
		return filterDictionaryLabelAndKey(positionArray)
	},
	technologyTypeDictionary: ({technologyTypeArray}) => {
		return filterDictionaryLabelAndKey(technologyTypeArray)
	},
	technologyPositionDictionary: ({technologyPositionArray}) => {
		return filterDictionaryLabelAndKey(technologyPositionArray)
	},
	productionTypeDictionary: ({productionTypeArray}) => {
		return filterDictionaryLabelAndKey(productionTypeArray)
	},
	styleTypeDictionary: ({styleTypeArray}) => {
		return filterDictionaryLabelAndKey(styleTypeArray)
	},
	saleTypeDictionary: ({saleTypeArray}) => {
		return filterDictionaryLabelAndKey(saleTypeArray)
	},
	yearDictionary: ({yearArray}) => {
		return filterDictionaryLabelAndKey(yearArray)
	},
	seriesDictionary:({seriesArray}) => {
		return filterDictionaryLabelAndKey(seriesArray)
	},
	waveDictionary:({waveArray}) => {
		return filterDictionaryLabelAndKey(waveArray)
	},
	patternDictionary:({patternArray}) => {
		return filterDictionaryLabelAndKey(patternArray)
	},
	basicCompanyDictionary:({basicCompany}) => {
		return filterDictionaryLabelAndKey(basicCompany)
	},
	sizeDictionary:({sizeArray}) => {
		return filterDictionaryLabelAndKey(sizeArray,'describes','id','size')
	},
	materialNodeDictionary:({materialNodeArray}) => {
		return filterDictionaryLabelAndKey(materialNodeArray)
	},
	// 门幅单位
	clothWidthUnitArrayDictionary: ({ clothWidthUnitArray }) => {
		return filterDictionaryLabelAndKey(clothWidthUnitArray);
	},
	// 克重单位
	fabricWidthUnitArrayDictionary: ({ fabricWidthUnitArray }) => {
		return filterDictionaryLabelAndKey(fabricWidthUnitArray);
	},
	// 开发规则
	developmentRulesArrayDictionary: ({ developmentRulesArray }) => {
		return filterDictionaryLabelAndKey(developmentRulesArray);
	},
	// 生产类别
	productionArrayDictionary: ({ productionArray }) => {
		return filterDictionaryLabelAndKey(productionArray);
	},
	// 价格定位
	priceFixedArrayDictionary: ({ priceFixedArray }) => {
		return filterDictionaryLabelAndKey(priceFixedArray);
	},
	// 年龄定位
	ageFixedArrayDictionary: ({ ageFixedArray }) => {
		return filterDictionaryLabelAndKey(ageFixedArray);
	},
	// 风格定位
	styleFixedArrayDictionary: ({ styleFixedArray }) => {
		return filterDictionaryLabelAndKey(styleFixedArray);
	},
	// 客户类型
	customerTypeArrayDictionary: ({ customerTypeArray }) => {
		return filterDictionaryLabelAndKey(customerTypeArray);
	}
}

const mutations = {

}
const actions = {
	async getDictionary(){
		return new Promise((resolve,reject) => {
			// 品牌  销售季 用料部位 工艺类型 工艺节点
			// 生产类型、开发类型、销售类型、年份、系列、波段、版型、单位
			// 物料节点、门幅单位、克重单位、开发规则、 生产类别
			// 价格定位、年龄定位、风格定位、客户类型
			let codeList = [
			  'brand','sale_season','material_position','technolog_type','technology_point',
			  'production_type','style_type','sale_type','year','series','wave','pattern','base_unit',
			  'material_node','cloth_width_unit','fabric_width_unit','development_rules','production_list',
			  'price_fixed','age_fixed','style_fixed','customer_type','express'
			];
			http('base.dictionary',{codeList}).then(res => {
				let { code, data } = res;
				if(code === 200){
					state.brandArray = filterDictionary(data,"品牌","brand");
					state.saleSeasonArray = filterDictionary(data,"销售季","sale_season");
					state.positionArray = filterDictionary(data,"用料部位","material_position");
					state.technologyTypeArray = filterDictionary(data,"工艺类型","technolog_type");
					state.technologyPositionArray = filterDictionary(data,"工艺节点","technology_point");
					state.productionTypeArray = filterDictionary(data,"生产类型","production_type");
					state.styleTypeArray = filterDictionary(data,"开发类型","style_type");
					state.saleTypeArray = filterDictionary(data,"销售类型","sale_type");
					state.yearArray = filterDictionary(data,"年份","year");
					state.seriesArray = filterDictionary(data,"系列","series");
					state.waveArray = filterDictionary(data,"波段","wave");
					state.patternArray = filterDictionary(data,"版型","pattern");
					state.basicCompany = filterDictionary(data,"基本单位","base_unit");
					state.materialNodeArray = filterDictionary(data,"物料节点","material_node");
					state.clothWidthUnitArray = filterDictionary(data, '门幅单位', 'cloth_width_unit');
					state.fabricWidthUnitArray = filterDictionary(data, '克重单位', 'fabric_width_unit');
					state.developmentRulesArray = filterDictionary(data, '开发规则', 'development_rules');
					state.productionArray = filterDictionary(data, '生产类别', 'production_list');
					state.priceFixedArray = filterDictionary(data, '价格定位', 'price_fixed');
					state.ageFixedArray = filterDictionary(data, '年龄定位', 'age_fixed');
					state.styleFixedArray = filterDictionary(data, '风格定位', 'style_fixed');
					state.customerTypeArray = filterDictionary(data, '客户类型', 'customer_type');
					resolve();
				}
			}).catch(e => {
				reject(e)
			})
		})
	},
	async getCategoryList(){
		return new Promise((resolve,reject) => {
			// type(默认全部 CY-成衣 WL-物料 ML-面料 FL-辅料)
			http('base.getCategoryList',{type: ''})
				.then(res => {
					let { code, data } = res;
					if(code === 200){
						state.categoryArray = filterArray(data);
						resolve();
					}
				})
				.catch(e => {
					reject(e)
				})
		})
	},
	async getSizeList(){
		return new Promise((resolve,reject) => {
			http('base.sizeGroup',{queryName: ""})
				.then(res => {
					let { code, data } = res;
				    if(code === 200){
					  state.sizeArray = data.sizeGroupList;
					  resolve();
				    }
				})
				.catch(e => {
					reject(e)
				})
		})
	},
}
export default {
	state,
	mutations,
	actions,
	getters
}
